/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableControlRequest extends ControlTowerRequest implements
        ToCopyableBuilder<EnableControlRequest.Builder, EnableControlRequest> {
    private static final SdkField<String> CONTROL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlIdentifier").getter(getter(EnableControlRequest::controlIdentifier))
            .setter(setter(Builder::controlIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifier").build()).build();

    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetIdentifier").getter(getter(EnableControlRequest::targetIdentifier))
            .setter(setter(Builder::targetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_IDENTIFIER_FIELD,
            TARGET_IDENTIFIER_FIELD));

    private final String controlIdentifier;

    private final String targetIdentifier;

    private EnableControlRequest(BuilderImpl builder) {
        super(builder);
        this.controlIdentifier = builder.controlIdentifier;
        this.targetIdentifier = builder.targetIdentifier;
    }

    /**
     * <p>
     * The ARN of the control. Only <b>Strongly recommended</b> and <b>Elective</b> controls are permitted, with the
     * exception of the <b>Region deny</b> control. For information on how to find the <code>controlIdentifier</code>,
     * see <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
     * </p>
     * 
     * @return The ARN of the control. Only <b>Strongly recommended</b> and <b>Elective</b> controls are permitted, with
     *         the exception of the <b>Region deny</b> control. For information on how to find the
     *         <code>controlIdentifier</code>, see <a
     *         href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
     */
    public final String controlIdentifier() {
        return controlIdentifier;
    }

    /**
     * <p>
     * The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
     * </p>
     * 
     * @return The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see
     *         <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
     *         page</a>.
     */
    public final String targetIdentifier() {
        return targetIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableControlRequest)) {
            return false;
        }
        EnableControlRequest other = (EnableControlRequest) obj;
        return Objects.equals(controlIdentifier(), other.controlIdentifier())
                && Objects.equals(targetIdentifier(), other.targetIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableControlRequest").add("ControlIdentifier", controlIdentifier())
                .add("TargetIdentifier", targetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlIdentifier":
            return Optional.ofNullable(clazz.cast(controlIdentifier()));
        case "targetIdentifier":
            return Optional.ofNullable(clazz.cast(targetIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableControlRequest, T> g) {
        return obj -> g.apply((EnableControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableControlRequest> {
        /**
         * <p>
         * The ARN of the control. Only <b>Strongly recommended</b> and <b>Elective</b> controls are permitted, with the
         * exception of the <b>Region deny</b> control. For information on how to find the
         * <code>controlIdentifier</code>, see <a
         * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
         * </p>
         * 
         * @param controlIdentifier
         *        The ARN of the control. Only <b>Strongly recommended</b> and <b>Elective</b> controls are permitted,
         *        with the exception of the <b>Region deny</b> control. For information on how to find the
         *        <code>controlIdentifier</code>, see <a
         *        href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
         *        page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlIdentifier(String controlIdentifier);

        /**
         * <p>
         * The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see <a
         * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
         * </p>
         * 
         * @param targetIdentifier
         *        The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>,
         *        see <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
         *        page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifier(String targetIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private String controlIdentifier;

        private String targetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableControlRequest model) {
            super(model);
            controlIdentifier(model.controlIdentifier);
            targetIdentifier(model.targetIdentifier);
        }

        public final String getControlIdentifier() {
            return controlIdentifier;
        }

        public final void setControlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
        }

        @Override
        public final Builder controlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
            return this;
        }

        public final String getTargetIdentifier() {
            return targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableControlRequest build() {
            return new EnableControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
