/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the landing zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LandingZoneDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<LandingZoneDetail.Builder, LandingZoneDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(LandingZoneDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<LandingZoneDriftStatusSummary> DRIFT_STATUS_FIELD = SdkField
            .<LandingZoneDriftStatusSummary> builder(MarshallingType.SDK_POJO).memberName("driftStatus")
            .getter(getter(LandingZoneDetail::driftStatus)).setter(setter(Builder::driftStatus))
            .constructor(LandingZoneDriftStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatus").build()).build();

    private static final SdkField<String> LATEST_AVAILABLE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestAvailableVersion").getter(getter(LandingZoneDetail::latestAvailableVersion))
            .setter(setter(Builder::latestAvailableVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAvailableVersion").build())
            .build();

    private static final SdkField<Document> MANIFEST_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("manifest").getter(getter(LandingZoneDetail::manifest)).setter(setter(Builder::manifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifest").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(LandingZoneDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(LandingZoneDetail::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DRIFT_STATUS_FIELD,
            LATEST_AVAILABLE_VERSION_FIELD, MANIFEST_FIELD, STATUS_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final LandingZoneDriftStatusSummary driftStatus;

    private final String latestAvailableVersion;

    private final Document manifest;

    private final String status;

    private final String version;

    private LandingZoneDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.driftStatus = builder.driftStatus;
        this.latestAvailableVersion = builder.latestAvailableVersion;
        this.manifest = builder.manifest;
        this.status = builder.status;
        this.version = builder.version;
    }

    /**
     * <p>
     * The ARN of the landing zone.
     * </p>
     * 
     * @return The ARN of the landing zone.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The drift status of the landing zone.
     * </p>
     * 
     * @return The drift status of the landing zone.
     */
    public final LandingZoneDriftStatusSummary driftStatus() {
        return driftStatus;
    }

    /**
     * <p>
     * The latest available version of the landing zone.
     * </p>
     * 
     * @return The latest available version of the landing zone.
     */
    public final String latestAvailableVersion() {
        return latestAvailableVersion;
    }

    /**
     * <p>
     * The landing zone <code>manifest.yaml</code> text file that specifies the landing zone configurations.
     * </p>
     * 
     * @return The landing zone <code>manifest.yaml</code> text file that specifies the landing zone configurations.
     */
    public final Document manifest() {
        return manifest;
    }

    /**
     * <p>
     * The landing zone deployment status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LandingZoneStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The landing zone deployment status.
     * @see LandingZoneStatus
     */
    public final LandingZoneStatus status() {
        return LandingZoneStatus.fromValue(status);
    }

    /**
     * <p>
     * The landing zone deployment status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LandingZoneStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The landing zone deployment status.
     * @see LandingZoneStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The landing zone's current deployed version.
     * </p>
     * 
     * @return The landing zone's current deployed version.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(driftStatus());
        hashCode = 31 * hashCode + Objects.hashCode(latestAvailableVersion());
        hashCode = 31 * hashCode + Objects.hashCode(manifest());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LandingZoneDetail)) {
            return false;
        }
        LandingZoneDetail other = (LandingZoneDetail) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(driftStatus(), other.driftStatus())
                && Objects.equals(latestAvailableVersion(), other.latestAvailableVersion())
                && Objects.equals(manifest(), other.manifest()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LandingZoneDetail").add("Arn", arn()).add("DriftStatus", driftStatus())
                .add("LatestAvailableVersion", latestAvailableVersion()).add("Manifest", manifest())
                .add("Status", statusAsString()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "driftStatus":
            return Optional.ofNullable(clazz.cast(driftStatus()));
        case "latestAvailableVersion":
            return Optional.ofNullable(clazz.cast(latestAvailableVersion()));
        case "manifest":
            return Optional.ofNullable(clazz.cast(manifest()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LandingZoneDetail, T> g) {
        return obj -> g.apply((LandingZoneDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LandingZoneDetail> {
        /**
         * <p>
         * The ARN of the landing zone.
         * </p>
         * 
         * @param arn
         *        The ARN of the landing zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The drift status of the landing zone.
         * </p>
         * 
         * @param driftStatus
         *        The drift status of the landing zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftStatus(LandingZoneDriftStatusSummary driftStatus);

        /**
         * <p>
         * The drift status of the landing zone.
         * </p>
         * This is a convenience method that creates an instance of the {@link LandingZoneDriftStatusSummary.Builder}
         * avoiding the need to create one manually via {@link LandingZoneDriftStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LandingZoneDriftStatusSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #driftStatus(LandingZoneDriftStatusSummary)}.
         * 
         * @param driftStatus
         *        a consumer that will call methods on {@link LandingZoneDriftStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driftStatus(LandingZoneDriftStatusSummary)
         */
        default Builder driftStatus(Consumer<LandingZoneDriftStatusSummary.Builder> driftStatus) {
            return driftStatus(LandingZoneDriftStatusSummary.builder().applyMutation(driftStatus).build());
        }

        /**
         * <p>
         * The latest available version of the landing zone.
         * </p>
         * 
         * @param latestAvailableVersion
         *        The latest available version of the landing zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestAvailableVersion(String latestAvailableVersion);

        /**
         * <p>
         * The landing zone <code>manifest.yaml</code> text file that specifies the landing zone configurations.
         * </p>
         * 
         * @param manifest
         *        The landing zone <code>manifest.yaml</code> text file that specifies the landing zone configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifest(Document manifest);

        /**
         * <p>
         * The landing zone deployment status.
         * </p>
         * 
         * @param status
         *        The landing zone deployment status.
         * @see LandingZoneStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The landing zone deployment status.
         * </p>
         * 
         * @param status
         *        The landing zone deployment status.
         * @see LandingZoneStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneStatus
         */
        Builder status(LandingZoneStatus status);

        /**
         * <p>
         * The landing zone's current deployed version.
         * </p>
         * 
         * @param version
         *        The landing zone's current deployed version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private LandingZoneDriftStatusSummary driftStatus;

        private String latestAvailableVersion;

        private Document manifest;

        private String status;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(LandingZoneDetail model) {
            arn(model.arn);
            driftStatus(model.driftStatus);
            latestAvailableVersion(model.latestAvailableVersion);
            manifest(model.manifest);
            status(model.status);
            version(model.version);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final LandingZoneDriftStatusSummary.Builder getDriftStatus() {
            return driftStatus != null ? driftStatus.toBuilder() : null;
        }

        public final void setDriftStatus(LandingZoneDriftStatusSummary.BuilderImpl driftStatus) {
            this.driftStatus = driftStatus != null ? driftStatus.build() : null;
        }

        @Override
        public final Builder driftStatus(LandingZoneDriftStatusSummary driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        public final String getLatestAvailableVersion() {
            return latestAvailableVersion;
        }

        public final void setLatestAvailableVersion(String latestAvailableVersion) {
            this.latestAvailableVersion = latestAvailableVersion;
        }

        @Override
        public final Builder latestAvailableVersion(String latestAvailableVersion) {
            this.latestAvailableVersion = latestAvailableVersion;
            return this;
        }

        public final Document getManifest() {
            return manifest;
        }

        public final void setManifest(Document manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(Document manifest) {
            this.manifest = manifest;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LandingZoneStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public LandingZoneDetail build() {
            return new LandingZoneDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
