/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLandingZoneResponse extends ControlTowerResponse implements
        ToCopyableBuilder<UpdateLandingZoneResponse.Builder, UpdateLandingZoneResponse> {
    private static final SdkField<String> OPERATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationIdentifier").getter(getter(UpdateLandingZoneResponse::operationIdentifier))
            .setter(setter(Builder::operationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_IDENTIFIER_FIELD));

    private final String operationIdentifier;

    private UpdateLandingZoneResponse(BuilderImpl builder) {
        super(builder);
        this.operationIdentifier = builder.operationIdentifier;
    }

    /**
     * <p>
     * A unique identifier assigned to a <code>UpdateLandingZone</code> operation. You can use this identifier as an
     * input of <code>GetLandingZoneOperation</code> to check the operation's status.
     * </p>
     * 
     * @return A unique identifier assigned to a <code>UpdateLandingZone</code> operation. You can use this identifier
     *         as an input of <code>GetLandingZoneOperation</code> to check the operation's status.
     */
    public final String operationIdentifier() {
        return operationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(operationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLandingZoneResponse)) {
            return false;
        }
        UpdateLandingZoneResponse other = (UpdateLandingZoneResponse) obj;
        return Objects.equals(operationIdentifier(), other.operationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLandingZoneResponse").add("OperationIdentifier", operationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operationIdentifier":
            return Optional.ofNullable(clazz.cast(operationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLandingZoneResponse, T> g) {
        return obj -> g.apply((UpdateLandingZoneResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLandingZoneResponse> {
        /**
         * <p>
         * A unique identifier assigned to a <code>UpdateLandingZone</code> operation. You can use this identifier as an
         * input of <code>GetLandingZoneOperation</code> to check the operation's status.
         * </p>
         * 
         * @param operationIdentifier
         *        A unique identifier assigned to a <code>UpdateLandingZone</code> operation. You can use this
         *        identifier as an input of <code>GetLandingZoneOperation</code> to check the operation's status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationIdentifier(String operationIdentifier);
    }

    static final class BuilderImpl extends ControlTowerResponse.BuilderImpl implements Builder {
        private String operationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLandingZoneResponse model) {
            super(model);
            operationIdentifier(model.operationIdentifier);
        }

        public final String getOperationIdentifier() {
            return operationIdentifier;
        }

        public final void setOperationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
        }

        @Override
        public final Builder operationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
            return this;
        }

        @Override
        public UpdateLandingZoneResponse build() {
            return new UpdateLandingZoneResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
