/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLandingZoneRequest extends ControlTowerRequest implements
        ToCopyableBuilder<CreateLandingZoneRequest.Builder, CreateLandingZoneRequest> {
    private static final SdkField<Document> MANIFEST_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("manifest").getter(getter(CreateLandingZoneRequest::manifest)).setter(setter(Builder::manifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifest").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateLandingZoneRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CreateLandingZoneRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_FIELD, TAGS_FIELD,
            VERSION_FIELD));

    private final Document manifest;

    private final Map<String, String> tags;

    private final String version;

    private CreateLandingZoneRequest(BuilderImpl builder) {
        super(builder);
        this.manifest = builder.manifest;
        this.tags = builder.tags;
        this.version = builder.version;
    }

    /**
     * <p>
     * The manifest JSON file is a text file that describes your Amazon Web Services resources. For examples, review <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch your landing zone</a>.
     * </p>
     * 
     * @return The manifest JSON file is a text file that describes your Amazon Web Services resources. For examples,
     *         review <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch your
     *         landing zone</a>.
     */
    public final Document manifest() {
        return manifest;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to be applied to the landing zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be applied to the landing zone.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The landing zone version, for example, 3.0.
     * </p>
     * 
     * @return The landing zone version, for example, 3.0.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(manifest());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLandingZoneRequest)) {
            return false;
        }
        CreateLandingZoneRequest other = (CreateLandingZoneRequest) obj;
        return Objects.equals(manifest(), other.manifest()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLandingZoneRequest").add("Manifest", manifest()).add("Tags", hasTags() ? tags() : null)
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "manifest":
            return Optional.ofNullable(clazz.cast(manifest()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLandingZoneRequest, T> g) {
        return obj -> g.apply((CreateLandingZoneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLandingZoneRequest> {
        /**
         * <p>
         * The manifest JSON file is a text file that describes your Amazon Web Services resources. For examples, review
         * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch your landing
         * zone</a>.
         * </p>
         * 
         * @param manifest
         *        The manifest JSON file is a text file that describes your Amazon Web Services resources. For examples,
         *        review <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch your
         *        landing zone</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifest(Document manifest);

        /**
         * <p>
         * Tags to be applied to the landing zone.
         * </p>
         * 
         * @param tags
         *        Tags to be applied to the landing zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The landing zone version, for example, 3.0.
         * </p>
         * 
         * @param version
         *        The landing zone version, for example, 3.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private Document manifest;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLandingZoneRequest model) {
            super(model);
            manifest(model.manifest);
            tags(model.tags);
            version(model.version);
        }

        public final Document getManifest() {
            return manifest;
        }

        public final void setManifest(Document manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(Document manifest) {
            this.manifest = manifest;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLandingZoneRequest build() {
            return new CreateLandingZoneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
