/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns a summary of information about an enabled control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledControlSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnabledControlSummary.Builder, EnabledControlSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EnabledControlSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONTROL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlIdentifier").getter(getter(EnabledControlSummary::controlIdentifier))
            .setter(setter(Builder::controlIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifier").build()).build();

    private static final SdkField<DriftStatusSummary> DRIFT_STATUS_SUMMARY_FIELD = SdkField
            .<DriftStatusSummary> builder(MarshallingType.SDK_POJO).memberName("driftStatusSummary")
            .getter(getter(EnabledControlSummary::driftStatusSummary)).setter(setter(Builder::driftStatusSummary))
            .constructor(DriftStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatusSummary").build())
            .build();

    private static final SdkField<EnablementStatusSummary> STATUS_SUMMARY_FIELD = SdkField
            .<EnablementStatusSummary> builder(MarshallingType.SDK_POJO).memberName("statusSummary")
            .getter(getter(EnabledControlSummary::statusSummary)).setter(setter(Builder::statusSummary))
            .constructor(EnablementStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()).build();

    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetIdentifier").getter(getter(EnabledControlSummary::targetIdentifier))
            .setter(setter(Builder::targetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONTROL_IDENTIFIER_FIELD, DRIFT_STATUS_SUMMARY_FIELD, STATUS_SUMMARY_FIELD, TARGET_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String controlIdentifier;

    private final DriftStatusSummary driftStatusSummary;

    private final EnablementStatusSummary statusSummary;

    private final String targetIdentifier;

    private EnabledControlSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.controlIdentifier = builder.controlIdentifier;
        this.driftStatusSummary = builder.driftStatusSummary;
        this.statusSummary = builder.statusSummary;
        this.targetIdentifier = builder.targetIdentifier;
    }

    /**
     * <p>
     * The ARN of the enabled control.
     * </p>
     * 
     * @return The ARN of the enabled control.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The <code>controlIdentifier</code> of the enabled control.
     * </p>
     * 
     * @return The <code>controlIdentifier</code> of the enabled control.
     */
    public final String controlIdentifier() {
        return controlIdentifier;
    }

    /**
     * <p>
     * The drift status of the enabled control.
     * </p>
     * 
     * @return The drift status of the enabled control.
     */
    public final DriftStatusSummary driftStatusSummary() {
        return driftStatusSummary;
    }

    /**
     * <p>
     * A short description of the status of the enabled control.
     * </p>
     * 
     * @return A short description of the status of the enabled control.
     */
    public final EnablementStatusSummary statusSummary() {
        return statusSummary;
    }

    /**
     * <p>
     * The ARN of the organizational unit.
     * </p>
     * 
     * @return The ARN of the organizational unit.
     */
    public final String targetIdentifier() {
        return targetIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(controlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(driftStatusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(targetIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledControlSummary)) {
            return false;
        }
        EnabledControlSummary other = (EnabledControlSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(controlIdentifier(), other.controlIdentifier())
                && Objects.equals(driftStatusSummary(), other.driftStatusSummary())
                && Objects.equals(statusSummary(), other.statusSummary())
                && Objects.equals(targetIdentifier(), other.targetIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnabledControlSummary").add("Arn", arn()).add("ControlIdentifier", controlIdentifier())
                .add("DriftStatusSummary", driftStatusSummary()).add("StatusSummary", statusSummary())
                .add("TargetIdentifier", targetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "controlIdentifier":
            return Optional.ofNullable(clazz.cast(controlIdentifier()));
        case "driftStatusSummary":
            return Optional.ofNullable(clazz.cast(driftStatusSummary()));
        case "statusSummary":
            return Optional.ofNullable(clazz.cast(statusSummary()));
        case "targetIdentifier":
            return Optional.ofNullable(clazz.cast(targetIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnabledControlSummary, T> g) {
        return obj -> g.apply((EnabledControlSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnabledControlSummary> {
        /**
         * <p>
         * The ARN of the enabled control.
         * </p>
         * 
         * @param arn
         *        The ARN of the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The <code>controlIdentifier</code> of the enabled control.
         * </p>
         * 
         * @param controlIdentifier
         *        The <code>controlIdentifier</code> of the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlIdentifier(String controlIdentifier);

        /**
         * <p>
         * The drift status of the enabled control.
         * </p>
         * 
         * @param driftStatusSummary
         *        The drift status of the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftStatusSummary(DriftStatusSummary driftStatusSummary);

        /**
         * <p>
         * The drift status of the enabled control.
         * </p>
         * This is a convenience method that creates an instance of the {@link DriftStatusSummary.Builder} avoiding the
         * need to create one manually via {@link DriftStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DriftStatusSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #driftStatusSummary(DriftStatusSummary)}.
         * 
         * @param driftStatusSummary
         *        a consumer that will call methods on {@link DriftStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driftStatusSummary(DriftStatusSummary)
         */
        default Builder driftStatusSummary(Consumer<DriftStatusSummary.Builder> driftStatusSummary) {
            return driftStatusSummary(DriftStatusSummary.builder().applyMutation(driftStatusSummary).build());
        }

        /**
         * <p>
         * A short description of the status of the enabled control.
         * </p>
         * 
         * @param statusSummary
         *        A short description of the status of the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummary(EnablementStatusSummary statusSummary);

        /**
         * <p>
         * A short description of the status of the enabled control.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnablementStatusSummary.Builder} avoiding
         * the need to create one manually via {@link EnablementStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnablementStatusSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #statusSummary(EnablementStatusSummary)}.
         * 
         * @param statusSummary
         *        a consumer that will call methods on {@link EnablementStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusSummary(EnablementStatusSummary)
         */
        default Builder statusSummary(Consumer<EnablementStatusSummary.Builder> statusSummary) {
            return statusSummary(EnablementStatusSummary.builder().applyMutation(statusSummary).build());
        }

        /**
         * <p>
         * The ARN of the organizational unit.
         * </p>
         * 
         * @param targetIdentifier
         *        The ARN of the organizational unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifier(String targetIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String controlIdentifier;

        private DriftStatusSummary driftStatusSummary;

        private EnablementStatusSummary statusSummary;

        private String targetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledControlSummary model) {
            arn(model.arn);
            controlIdentifier(model.controlIdentifier);
            driftStatusSummary(model.driftStatusSummary);
            statusSummary(model.statusSummary);
            targetIdentifier(model.targetIdentifier);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getControlIdentifier() {
            return controlIdentifier;
        }

        public final void setControlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
        }

        @Override
        public final Builder controlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
            return this;
        }

        public final DriftStatusSummary.Builder getDriftStatusSummary() {
            return driftStatusSummary != null ? driftStatusSummary.toBuilder() : null;
        }

        public final void setDriftStatusSummary(DriftStatusSummary.BuilderImpl driftStatusSummary) {
            this.driftStatusSummary = driftStatusSummary != null ? driftStatusSummary.build() : null;
        }

        @Override
        public final Builder driftStatusSummary(DriftStatusSummary driftStatusSummary) {
            this.driftStatusSummary = driftStatusSummary;
            return this;
        }

        public final EnablementStatusSummary.Builder getStatusSummary() {
            return statusSummary != null ? statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(EnablementStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(EnablementStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final String getTargetIdentifier() {
            return targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        @Override
        public EnabledControlSummary build() {
            return new EnabledControlSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
