/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.BaselineSummary;
import software.amazon.awssdk.services.controltower.model.BaselinesCopier;
import software.amazon.awssdk.services.controltower.model.ControlTowerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBaselinesResponse
extends ControlTowerResponse
implements ToCopyableBuilder<Builder, ListBaselinesResponse> {
    private static final SdkField<List<BaselineSummary>> BASELINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("baselines").getter(ListBaselinesResponse.getter(ListBaselinesResponse::baselines)).setter(ListBaselinesResponse.setter(Builder::baselines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BaselineSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBaselinesResponse.getter(ListBaselinesResponse::nextToken)).setter(ListBaselinesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINES_FIELD, NEXT_TOKEN_FIELD));
    private final List<BaselineSummary> baselines;
    private final String nextToken;

    private ListBaselinesResponse(BuilderImpl builder) {
        super(builder);
        this.baselines = builder.baselines;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBaselines() {
        return this.baselines != null && !(this.baselines instanceof SdkAutoConstructList);
    }

    public final List<BaselineSummary> baselines() {
        return this.baselines;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaselines() ? this.baselines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBaselinesResponse)) {
            return false;
        }
        ListBaselinesResponse other = (ListBaselinesResponse)((Object)obj);
        return this.hasBaselines() == other.hasBaselines() && Objects.equals(this.baselines(), other.baselines()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBaselinesResponse").add("Baselines", this.hasBaselines() ? this.baselines() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baselines": {
                return Optional.ofNullable(clazz.cast(this.baselines()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBaselinesResponse, T> g) {
        return obj -> g.apply((ListBaselinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerResponse.BuilderImpl
    implements Builder {
        private List<BaselineSummary> baselines = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBaselinesResponse model) {
            super(model);
            this.baselines(model.baselines);
            this.nextToken(model.nextToken);
        }

        public final List<BaselineSummary.Builder> getBaselines() {
            List<BaselineSummary.Builder> result = BaselinesCopier.copyToBuilder(this.baselines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBaselines(Collection<BaselineSummary.BuilderImpl> baselines) {
            this.baselines = BaselinesCopier.copyFromBuilder(baselines);
        }

        @Override
        public final Builder baselines(Collection<BaselineSummary> baselines) {
            this.baselines = BaselinesCopier.copy(baselines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselines(BaselineSummary ... baselines) {
            this.baselines(Arrays.asList(baselines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselines(Consumer<BaselineSummary.Builder> ... baselines) {
            this.baselines(Stream.of(baselines).map(c -> (BaselineSummary)((BaselineSummary.Builder)BaselineSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBaselinesResponse build() {
            return new ListBaselinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ControlTowerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBaselinesResponse> {
        public Builder baselines(Collection<BaselineSummary> var1);

        public Builder baselines(BaselineSummary ... var1);

        public Builder baselines(Consumer<BaselineSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

