/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object of shape <code>BaselineOperation</code>, returning details about the specified <code>Baseline</code>
 * operation ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BaselineOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<BaselineOperation.Builder, BaselineOperation> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(BaselineOperation::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> OPERATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationIdentifier").getter(getter(BaselineOperation::operationIdentifier))
            .setter(setter(Builder::operationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationIdentifier").build())
            .build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationType").getter(getter(BaselineOperation::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(BaselineOperation::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BaselineOperation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(BaselineOperation::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            OPERATION_IDENTIFIER_FIELD, OPERATION_TYPE_FIELD, START_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant endTime;

    private final String operationIdentifier;

    private final String operationType;

    private final Instant startTime;

    private final String status;

    private final String statusMessage;

    private BaselineOperation(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.operationIdentifier = builder.operationIdentifier;
        this.operationType = builder.operationType;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The end time of the operation (if applicable), in ISO 8601 format.
     * </p>
     * 
     * @return The end time of the operation (if applicable), in ISO 8601 format.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The identifier of the specified operation.
     * </p>
     * 
     * @return The identifier of the specified operation.
     */
    public final String operationIdentifier() {
        return operationIdentifier;
    }

    /**
     * <p>
     * An enumerated type (<code>enum</code>) with possible values of <code>ENABLE_BASELINE</code>,
     * <code>DISABLE_BASELINE</code>, <code>UPDATE_ENABLED_BASELINE</code>, or <code>RESET_ENABLED_BASELINE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link BaselineOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return An enumerated type (<code>enum</code>) with possible values of <code>ENABLE_BASELINE</code>,
     *         <code>DISABLE_BASELINE</code>, <code>UPDATE_ENABLED_BASELINE</code>, or
     *         <code>RESET_ENABLED_BASELINE</code>.
     * @see BaselineOperationType
     */
    public final BaselineOperationType operationType() {
        return BaselineOperationType.fromValue(operationType);
    }

    /**
     * <p>
     * An enumerated type (<code>enum</code>) with possible values of <code>ENABLE_BASELINE</code>,
     * <code>DISABLE_BASELINE</code>, <code>UPDATE_ENABLED_BASELINE</code>, or <code>RESET_ENABLED_BASELINE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link BaselineOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return An enumerated type (<code>enum</code>) with possible values of <code>ENABLE_BASELINE</code>,
     *         <code>DISABLE_BASELINE</code>, <code>UPDATE_ENABLED_BASELINE</code>, or
     *         <code>RESET_ENABLED_BASELINE</code>.
     * @see BaselineOperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The start time of the operation, in ISO 8601 format.
     * </p>
     * 
     * @return The start time of the operation, in ISO 8601 format.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * An enumerated type (<code>enum</code>) with possible values of <code>SUCCEEDED</code>, <code>FAILED</code>, or
     * <code>IN_PROGRESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BaselineOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return An enumerated type (<code>enum</code>) with possible values of <code>SUCCEEDED</code>,
     *         <code>FAILED</code>, or <code>IN_PROGRESS</code>.
     * @see BaselineOperationStatus
     */
    public final BaselineOperationStatus status() {
        return BaselineOperationStatus.fromValue(status);
    }

    /**
     * <p>
     * An enumerated type (<code>enum</code>) with possible values of <code>SUCCEEDED</code>, <code>FAILED</code>, or
     * <code>IN_PROGRESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BaselineOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return An enumerated type (<code>enum</code>) with possible values of <code>SUCCEEDED</code>,
     *         <code>FAILED</code>, or <code>IN_PROGRESS</code>.
     * @see BaselineOperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A status message that gives more information about the operation's status, if applicable.
     * </p>
     * 
     * @return A status message that gives more information about the operation's status, if applicable.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(operationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaselineOperation)) {
            return false;
        }
        BaselineOperation other = (BaselineOperation) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(operationIdentifier(), other.operationIdentifier())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BaselineOperation").add("EndTime", endTime()).add("OperationIdentifier", operationIdentifier())
                .add("OperationType", operationTypeAsString()).add("StartTime", startTime()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "operationIdentifier":
            return Optional.ofNullable(clazz.cast(operationIdentifier()));
        case "operationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BaselineOperation, T> g) {
        return obj -> g.apply((BaselineOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BaselineOperation> {
        /**
         * <p>
         * The end time of the operation (if applicable), in ISO 8601 format.
         * </p>
         * 
         * @param endTime
         *        The end time of the operation (if applicable), in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The identifier of the specified operation.
         * </p>
         * 
         * @param operationIdentifier
         *        The identifier of the specified operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationIdentifier(String operationIdentifier);

        /**
         * <p>
         * An enumerated type (<code>enum</code>) with possible values of <code>ENABLE_BASELINE</code>,
         * <code>DISABLE_BASELINE</code>, <code>UPDATE_ENABLED_BASELINE</code>, or <code>RESET_ENABLED_BASELINE</code>.
         * </p>
         * 
         * @param operationType
         *        An enumerated type (<code>enum</code>) with possible values of <code>ENABLE_BASELINE</code>,
         *        <code>DISABLE_BASELINE</code>, <code>UPDATE_ENABLED_BASELINE</code>, or
         *        <code>RESET_ENABLED_BASELINE</code>.
         * @see BaselineOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaselineOperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * An enumerated type (<code>enum</code>) with possible values of <code>ENABLE_BASELINE</code>,
         * <code>DISABLE_BASELINE</code>, <code>UPDATE_ENABLED_BASELINE</code>, or <code>RESET_ENABLED_BASELINE</code>.
         * </p>
         * 
         * @param operationType
         *        An enumerated type (<code>enum</code>) with possible values of <code>ENABLE_BASELINE</code>,
         *        <code>DISABLE_BASELINE</code>, <code>UPDATE_ENABLED_BASELINE</code>, or
         *        <code>RESET_ENABLED_BASELINE</code>.
         * @see BaselineOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaselineOperationType
         */
        Builder operationType(BaselineOperationType operationType);

        /**
         * <p>
         * The start time of the operation, in ISO 8601 format.
         * </p>
         * 
         * @param startTime
         *        The start time of the operation, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * An enumerated type (<code>enum</code>) with possible values of <code>SUCCEEDED</code>, <code>FAILED</code>,
         * or <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param status
         *        An enumerated type (<code>enum</code>) with possible values of <code>SUCCEEDED</code>,
         *        <code>FAILED</code>, or <code>IN_PROGRESS</code>.
         * @see BaselineOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaselineOperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * An enumerated type (<code>enum</code>) with possible values of <code>SUCCEEDED</code>, <code>FAILED</code>,
         * or <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param status
         *        An enumerated type (<code>enum</code>) with possible values of <code>SUCCEEDED</code>,
         *        <code>FAILED</code>, or <code>IN_PROGRESS</code>.
         * @see BaselineOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaselineOperationStatus
         */
        Builder status(BaselineOperationStatus status);

        /**
         * <p>
         * A status message that gives more information about the operation's status, if applicable.
         * </p>
         * 
         * @param statusMessage
         *        A status message that gives more information about the operation's status, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private Instant endTime;

        private String operationIdentifier;

        private String operationType;

        private Instant startTime;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BaselineOperation model) {
            endTime(model.endTime);
            operationIdentifier(model.operationIdentifier);
            operationType(model.operationType);
            startTime(model.startTime);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getOperationIdentifier() {
            return operationIdentifier;
        }

        public final void setOperationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
        }

        @Override
        public final Builder operationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
            return this;
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(BaselineOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BaselineOperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public BaselineOperation build() {
            return new BaselineOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
