/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns a summary of information about an <code>EnabledBaseline</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledBaselineSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnabledBaselineSummary.Builder, EnabledBaselineSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EnabledBaselineSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> BASELINE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baselineIdentifier").getter(getter(EnabledBaselineSummary::baselineIdentifier))
            .setter(setter(Builder::baselineIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineIdentifier").build())
            .build();

    private static final SdkField<String> BASELINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baselineVersion").getter(getter(EnabledBaselineSummary::baselineVersion))
            .setter(setter(Builder::baselineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineVersion").build()).build();

    private static final SdkField<EnablementStatusSummary> STATUS_SUMMARY_FIELD = SdkField
            .<EnablementStatusSummary> builder(MarshallingType.SDK_POJO).memberName("statusSummary")
            .getter(getter(EnabledBaselineSummary::statusSummary)).setter(setter(Builder::statusSummary))
            .constructor(EnablementStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()).build();

    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetIdentifier").getter(getter(EnabledBaselineSummary::targetIdentifier))
            .setter(setter(Builder::targetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            BASELINE_IDENTIFIER_FIELD, BASELINE_VERSION_FIELD, STATUS_SUMMARY_FIELD, TARGET_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String baselineIdentifier;

    private final String baselineVersion;

    private final EnablementStatusSummary statusSummary;

    private final String targetIdentifier;

    private EnabledBaselineSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.baselineIdentifier = builder.baselineIdentifier;
        this.baselineVersion = builder.baselineVersion;
        this.statusSummary = builder.statusSummary;
        this.targetIdentifier = builder.targetIdentifier;
    }

    /**
     * <p>
     * The ARN of the <code>EnabledBaseline</code> resource
     * </p>
     * 
     * @return The ARN of the <code>EnabledBaseline</code> resource
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The specific baseline that is enabled as part of the <code>EnabledBaseline</code> resource.
     * </p>
     * 
     * @return The specific baseline that is enabled as part of the <code>EnabledBaseline</code> resource.
     */
    public final String baselineIdentifier() {
        return baselineIdentifier;
    }

    /**
     * <p>
     * The enabled version of the baseline.
     * </p>
     * 
     * @return The enabled version of the baseline.
     */
    public final String baselineVersion() {
        return baselineVersion;
    }

    /**
     * Returns the value of the StatusSummary property for this object.
     * 
     * @return The value of the StatusSummary property for this object.
     */
    public final EnablementStatusSummary statusSummary() {
        return statusSummary;
    }

    /**
     * <p>
     * The target upon which the baseline is enabled.
     * </p>
     * 
     * @return The target upon which the baseline is enabled.
     */
    public final String targetIdentifier() {
        return targetIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(baselineIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(baselineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(targetIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledBaselineSummary)) {
            return false;
        }
        EnabledBaselineSummary other = (EnabledBaselineSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(baselineIdentifier(), other.baselineIdentifier())
                && Objects.equals(baselineVersion(), other.baselineVersion())
                && Objects.equals(statusSummary(), other.statusSummary())
                && Objects.equals(targetIdentifier(), other.targetIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnabledBaselineSummary").add("Arn", arn()).add("BaselineIdentifier", baselineIdentifier())
                .add("BaselineVersion", baselineVersion()).add("StatusSummary", statusSummary())
                .add("TargetIdentifier", targetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "baselineIdentifier":
            return Optional.ofNullable(clazz.cast(baselineIdentifier()));
        case "baselineVersion":
            return Optional.ofNullable(clazz.cast(baselineVersion()));
        case "statusSummary":
            return Optional.ofNullable(clazz.cast(statusSummary()));
        case "targetIdentifier":
            return Optional.ofNullable(clazz.cast(targetIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnabledBaselineSummary, T> g) {
        return obj -> g.apply((EnabledBaselineSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnabledBaselineSummary> {
        /**
         * <p>
         * The ARN of the <code>EnabledBaseline</code> resource
         * </p>
         * 
         * @param arn
         *        The ARN of the <code>EnabledBaseline</code> resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The specific baseline that is enabled as part of the <code>EnabledBaseline</code> resource.
         * </p>
         * 
         * @param baselineIdentifier
         *        The specific baseline that is enabled as part of the <code>EnabledBaseline</code> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentifier(String baselineIdentifier);

        /**
         * <p>
         * The enabled version of the baseline.
         * </p>
         * 
         * @param baselineVersion
         *        The enabled version of the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineVersion(String baselineVersion);

        /**
         * Sets the value of the StatusSummary property for this object.
         *
         * @param statusSummary
         *        The new value for the StatusSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummary(EnablementStatusSummary statusSummary);

        /**
         * Sets the value of the StatusSummary property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EnablementStatusSummary.Builder} avoiding
         * the need to create one manually via {@link EnablementStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnablementStatusSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #statusSummary(EnablementStatusSummary)}.
         * 
         * @param statusSummary
         *        a consumer that will call methods on {@link EnablementStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusSummary(EnablementStatusSummary)
         */
        default Builder statusSummary(Consumer<EnablementStatusSummary.Builder> statusSummary) {
            return statusSummary(EnablementStatusSummary.builder().applyMutation(statusSummary).build());
        }

        /**
         * <p>
         * The target upon which the baseline is enabled.
         * </p>
         * 
         * @param targetIdentifier
         *        The target upon which the baseline is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifier(String targetIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String baselineIdentifier;

        private String baselineVersion;

        private EnablementStatusSummary statusSummary;

        private String targetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledBaselineSummary model) {
            arn(model.arn);
            baselineIdentifier(model.baselineIdentifier);
            baselineVersion(model.baselineVersion);
            statusSummary(model.statusSummary);
            targetIdentifier(model.targetIdentifier);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBaselineIdentifier() {
            return baselineIdentifier;
        }

        public final void setBaselineIdentifier(String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
        }

        @Override
        public final Builder baselineIdentifier(String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
            return this;
        }

        public final String getBaselineVersion() {
            return baselineVersion;
        }

        public final void setBaselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
        }

        @Override
        public final Builder baselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
            return this;
        }

        public final EnablementStatusSummary.Builder getStatusSummary() {
            return statusSummary != null ? statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(EnablementStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(EnablementStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final String getTargetIdentifier() {
            return targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        @Override
        public EnabledBaselineSummary build() {
            return new EnabledBaselineSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
