/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnabledBaselineRequest extends ControlTowerRequest implements
        ToCopyableBuilder<GetEnabledBaselineRequest.Builder, GetEnabledBaselineRequest> {
    private static final SdkField<String> ENABLED_BASELINE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("enabledBaselineIdentifier").getter(getter(GetEnabledBaselineRequest::enabledBaselineIdentifier))
            .setter(setter(Builder::enabledBaselineIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledBaselineIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENABLED_BASELINE_IDENTIFIER_FIELD));

    private final String enabledBaselineIdentifier;

    private GetEnabledBaselineRequest(BuilderImpl builder) {
        super(builder);
        this.enabledBaselineIdentifier = builder.enabledBaselineIdentifier;
    }

    /**
     * <p>
     * Identifier of the <code>EnabledBaseline</code> resource to be retrieved, in ARN format.
     * </p>
     * 
     * @return Identifier of the <code>EnabledBaseline</code> resource to be retrieved, in ARN format.
     */
    public final String enabledBaselineIdentifier() {
        return enabledBaselineIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enabledBaselineIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnabledBaselineRequest)) {
            return false;
        }
        GetEnabledBaselineRequest other = (GetEnabledBaselineRequest) obj;
        return Objects.equals(enabledBaselineIdentifier(), other.enabledBaselineIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnabledBaselineRequest").add("EnabledBaselineIdentifier", enabledBaselineIdentifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabledBaselineIdentifier":
            return Optional.ofNullable(clazz.cast(enabledBaselineIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnabledBaselineRequest, T> g) {
        return obj -> g.apply((GetEnabledBaselineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetEnabledBaselineRequest> {
        /**
         * <p>
         * Identifier of the <code>EnabledBaseline</code> resource to be retrieved, in ARN format.
         * </p>
         * 
         * @param enabledBaselineIdentifier
         *        Identifier of the <code>EnabledBaseline</code> resource to be retrieved, in ARN format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledBaselineIdentifier(String enabledBaselineIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private String enabledBaselineIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnabledBaselineRequest model) {
            super(model);
            enabledBaselineIdentifier(model.enabledBaselineIdentifier);
        }

        public final String getEnabledBaselineIdentifier() {
            return enabledBaselineIdentifier;
        }

        public final void setEnabledBaselineIdentifier(String enabledBaselineIdentifier) {
            this.enabledBaselineIdentifier = enabledBaselineIdentifier;
        }

        @Override
        public final Builder enabledBaselineIdentifier(String enabledBaselineIdentifier) {
            this.enabledBaselineIdentifier = enabledBaselineIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEnabledBaselineRequest build() {
            return new GetEnabledBaselineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
