/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.controltower.model.CreateLandingZoneRequest;
import software.amazon.awssdk.services.controltower.model.CreateLandingZoneResponse;
import software.amazon.awssdk.services.controltower.model.DeleteLandingZoneRequest;
import software.amazon.awssdk.services.controltower.model.DeleteLandingZoneResponse;
import software.amazon.awssdk.services.controltower.model.DisableBaselineRequest;
import software.amazon.awssdk.services.controltower.model.DisableBaselineResponse;
import software.amazon.awssdk.services.controltower.model.DisableControlRequest;
import software.amazon.awssdk.services.controltower.model.DisableControlResponse;
import software.amazon.awssdk.services.controltower.model.EnableBaselineRequest;
import software.amazon.awssdk.services.controltower.model.EnableBaselineResponse;
import software.amazon.awssdk.services.controltower.model.EnableControlRequest;
import software.amazon.awssdk.services.controltower.model.EnableControlResponse;
import software.amazon.awssdk.services.controltower.model.GetBaselineOperationRequest;
import software.amazon.awssdk.services.controltower.model.GetBaselineOperationResponse;
import software.amazon.awssdk.services.controltower.model.GetBaselineRequest;
import software.amazon.awssdk.services.controltower.model.GetBaselineResponse;
import software.amazon.awssdk.services.controltower.model.GetControlOperationRequest;
import software.amazon.awssdk.services.controltower.model.GetControlOperationResponse;
import software.amazon.awssdk.services.controltower.model.GetEnabledBaselineRequest;
import software.amazon.awssdk.services.controltower.model.GetEnabledBaselineResponse;
import software.amazon.awssdk.services.controltower.model.GetEnabledControlRequest;
import software.amazon.awssdk.services.controltower.model.GetEnabledControlResponse;
import software.amazon.awssdk.services.controltower.model.GetLandingZoneOperationRequest;
import software.amazon.awssdk.services.controltower.model.GetLandingZoneOperationResponse;
import software.amazon.awssdk.services.controltower.model.GetLandingZoneRequest;
import software.amazon.awssdk.services.controltower.model.GetLandingZoneResponse;
import software.amazon.awssdk.services.controltower.model.ListBaselinesRequest;
import software.amazon.awssdk.services.controltower.model.ListBaselinesResponse;
import software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest;
import software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesResponse;
import software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest;
import software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse;
import software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest;
import software.amazon.awssdk.services.controltower.model.ListLandingZonesResponse;
import software.amazon.awssdk.services.controltower.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.controltower.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.controltower.model.ResetEnabledBaselineRequest;
import software.amazon.awssdk.services.controltower.model.ResetEnabledBaselineResponse;
import software.amazon.awssdk.services.controltower.model.ResetLandingZoneRequest;
import software.amazon.awssdk.services.controltower.model.ResetLandingZoneResponse;
import software.amazon.awssdk.services.controltower.model.TagResourceRequest;
import software.amazon.awssdk.services.controltower.model.TagResourceResponse;
import software.amazon.awssdk.services.controltower.model.UntagResourceRequest;
import software.amazon.awssdk.services.controltower.model.UntagResourceResponse;
import software.amazon.awssdk.services.controltower.model.UpdateEnabledBaselineRequest;
import software.amazon.awssdk.services.controltower.model.UpdateEnabledBaselineResponse;
import software.amazon.awssdk.services.controltower.model.UpdateEnabledControlRequest;
import software.amazon.awssdk.services.controltower.model.UpdateEnabledControlResponse;
import software.amazon.awssdk.services.controltower.model.UpdateLandingZoneRequest;
import software.amazon.awssdk.services.controltower.model.UpdateLandingZoneResponse;
import software.amazon.awssdk.services.controltower.paginators.ListBaselinesPublisher;
import software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesPublisher;
import software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsPublisher;
import software.amazon.awssdk.services.controltower.paginators.ListLandingZonesPublisher;

/**
 * Service client for accessing AWS Control Tower asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * These interfaces allow you to apply the Amazon Web Services library of pre-defined <i>controls</i> to your
 * organizational units, programmatically. In Amazon Web Services Control Tower, the terms "control" and "guardrail" are
 * synonyms.
 * </p>
 * <p>
 * To call these APIs, you'll need to know:
 * </p>
 * <ul>
 * <li>
 * <p>
 * the <code>controlIdentifier</code> for the control--or guardrail--you are targeting.
 * </p>
 * </li>
 * <li>
 * <p>
 * the ARN associated with the target organizational unit (OU), which we call the <code>targetIdentifier</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * the ARN associated with a resource that you wish to tag or untag.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>To get the <code>controlIdentifier</code> for your Amazon Web Services Control Tower control:</b>
 * </p>
 * <p>
 * The <code>controlIdentifier</code> is an ARN that is specified for each control. You can view the
 * <code>controlIdentifier</code> in the console on the <b>Control details</b> page, as well as in the documentation.
 * </p>
 * <p>
 * The <code>controlIdentifier</code> is unique in each Amazon Web Services Region for each control. You can find the
 * <code>controlIdentifier</code> for each Region and control in the <a
 * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-metadata-tables.html">Tables of control
 * metadata</a> in the <i>Amazon Web Services Control Tower User Guide.</i>
 * </p>
 * <p>
 * A quick-reference list of control identifers for the Amazon Web Services Control Tower legacy <i>Strongly
 * recommended</i> and <i>Elective</i> controls is given in <a
 * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-identifiers.html.html">Resource identifiers
 * for APIs and controls</a> in the <a
 * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-identifiers.html">Controls reference guide
 * section</a> of the <i>Amazon Web Services Control Tower User Guide</i>. Remember that <i>Mandatory</i> controls
 * cannot be added or removed.
 * </p>
 * <note>
 * <p>
 * <b>ARN format:</b> <code>arn:aws:controltower:{REGION}::control/{CONTROL_NAME}</code>
 * </p>
 * <p>
 * <b>Example:</b>
 * </p>
 * <p>
 * <code>arn:aws:controltower:us-west-2::control/AWS-GR_AUTOSCALING_LAUNCH_CONFIG_PUBLIC_IP_DISABLED</code>
 * </p>
 * </note>
 * <p>
 * <b>To get the <code>targetIdentifier</code>:</b>
 * </p>
 * <p>
 * The <code>targetIdentifier</code> is the ARN for an OU.
 * </p>
 * <p>
 * In the Amazon Web Services Organizations console, you can find the ARN for the OU on the <b>Organizational unit
 * details</b> page associated with that OU.
 * </p>
 * <note>
 * <p>
 * <b>OU ARN format:</b>
 * </p>
 * <p>
 * <code>arn:${Partition}:organizations::${MasterAccountId}:ou/o-${OrganizationId}/ou-${OrganizationalUnitId}</code>
 * </p>
 * </note>
 * <p class="title">
 * <b>Details and examples</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html">Control API input
 * and output examples with CLI</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/enable-controls.html">Enable controls with
 * CloudFormation</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/control-metadata-tables.html">Control metadata
 * tables</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/control-identifiers.html">List of identifiers for
 * legacy controls</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/controls.html">Controls reference guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/controls-reference.html">Controls library
 * groupings</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/creating-resources-with-cloudformation.html">
 * Creating Amazon Web Services Control Tower resources with Amazon Web Services CloudFormation</a>
 * </p>
 * </li>
 * </ul>
 * <p>
 * To view the open source resource repository on GitHub, see <a
 * href="https://github.com/aws-cloudformation/aws-cloudformation-resource-providers-controltower"
 * >aws-cloudformation/aws-cloudformation-resource-providers-controltower</a>
 * </p>
 * <p>
 * <b>Recording API Requests</b>
 * </p>
 * <p>
 * Amazon Web Services Control Tower supports Amazon Web Services CloudTrail, a service that records Amazon Web Services
 * API calls for your Amazon Web Services account and delivers log files to an Amazon S3 bucket. By using information
 * collected by CloudTrail, you can determine which requests the Amazon Web Services Control Tower service received, who
 * made the request and when, and so on. For more about Amazon Web Services Control Tower and its support for
 * CloudTrail, see <a
 * href="https://docs.aws.amazon.com/controltower/latest/userguide/logging-using-cloudtrail.html">Logging Amazon Web
 * Services Control Tower Actions with Amazon Web Services CloudTrail</a> in the Amazon Web Services Control Tower User
 * Guide. To learn more about CloudTrail, including how to turn it on and find your log files, see the Amazon Web
 * Services CloudTrail User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ControlTowerAsyncClient extends AwsClient {
    String SERVICE_NAME = "controltower";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "controltower";

    /**
     * <p>
     * Creates a new landing zone. This API call starts an asynchronous operation that creates and configures a landing
     * zone, based on the parameters specified in the manifest JSON file.
     * </p>
     *
     * @param createLandingZoneRequest
     * @return A Java Future containing the result of the CreateLandingZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.CreateLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/CreateLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLandingZoneResponse> createLandingZone(CreateLandingZoneRequest createLandingZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new landing zone. This API call starts an asynchronous operation that creates and configures a landing
     * zone, based on the parameters specified in the manifest JSON file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLandingZoneRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLandingZoneRequest#builder()}
     * </p>
     *
     * @param createLandingZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.CreateLandingZoneRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLandingZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.CreateLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/CreateLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLandingZoneResponse> createLandingZone(
            Consumer<CreateLandingZoneRequest.Builder> createLandingZoneRequest) {
        return createLandingZone(CreateLandingZoneRequest.builder().applyMutation(createLandingZoneRequest).build());
    }

    /**
     * <p>
     * Decommissions a landing zone. This API call starts an asynchronous operation that deletes Amazon Web Services
     * Control Tower resources deployed in accounts managed by Amazon Web Services Control Tower.
     * </p>
     *
     * @param deleteLandingZoneRequest
     * @return A Java Future containing the result of the DeleteLandingZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.DeleteLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DeleteLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLandingZoneResponse> deleteLandingZone(DeleteLandingZoneRequest deleteLandingZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Decommissions a landing zone. This API call starts an asynchronous operation that deletes Amazon Web Services
     * Control Tower resources deployed in accounts managed by Amazon Web Services Control Tower.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLandingZoneRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLandingZoneRequest#builder()}
     * </p>
     *
     * @param deleteLandingZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.DeleteLandingZoneRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLandingZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.DeleteLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DeleteLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLandingZoneResponse> deleteLandingZone(
            Consumer<DeleteLandingZoneRequest.Builder> deleteLandingZoneRequest) {
        return deleteLandingZone(DeleteLandingZoneRequest.builder().applyMutation(deleteLandingZoneRequest).build());
    }

    /**
     * <p>
     * Disable an <code>EnabledBaseline</code> resource on the specified Target. This API starts an asynchronous
     * operation to remove all resources deployed as part of the baseline enablement. The resource will vary depending
     * on the enabled baseline.
     * </p>
     *
     * @param disableBaselineRequest
     * @return A Java Future containing the result of the DisableBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.DisableBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DisableBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableBaselineResponse> disableBaseline(DisableBaselineRequest disableBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disable an <code>EnabledBaseline</code> resource on the specified Target. This API starts an asynchronous
     * operation to remove all resources deployed as part of the baseline enablement. The resource will vary depending
     * on the enabled baseline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableBaselineRequest.Builder} avoiding the need
     * to create one manually via {@link DisableBaselineRequest#builder()}
     * </p>
     *
     * @param disableBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.DisableBaselineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisableBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.DisableBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DisableBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableBaselineResponse> disableBaseline(
            Consumer<DisableBaselineRequest.Builder> disableBaselineRequest) {
        return disableBaseline(DisableBaselineRequest.builder().applyMutation(disableBaselineRequest).build());
    }

    /**
     * <p>
     * This API call turns off a control. It starts an asynchronous operation that deletes AWS resources on the
     * specified organizational unit and the accounts it contains. The resources will vary according to the control that
     * you specify. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param disableControlRequest
     * @return A Java Future containing the result of the DisableControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.DisableControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DisableControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableControlResponse> disableControl(DisableControlRequest disableControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API call turns off a control. It starts an asynchronous operation that deletes AWS resources on the
     * specified organizational unit and the accounts it contains. The resources will vary according to the control that
     * you specify. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableControlRequest.Builder} avoiding the need to
     * create one manually via {@link DisableControlRequest#builder()}
     * </p>
     *
     * @param disableControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.DisableControlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisableControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.DisableControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DisableControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableControlResponse> disableControl(Consumer<DisableControlRequest.Builder> disableControlRequest) {
        return disableControl(DisableControlRequest.builder().applyMutation(disableControlRequest).build());
    }

    /**
     * <p>
     * Enable (apply) a <code>Baseline</code> to a Target. This API starts an asynchronous operation to deploy resources
     * specified by the <code>Baseline</code> to the specified Target.
     * </p>
     *
     * @param enableBaselineRequest
     * @return A Java Future containing the result of the EnableBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.EnableBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/EnableBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableBaselineResponse> enableBaseline(EnableBaselineRequest enableBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable (apply) a <code>Baseline</code> to a Target. This API starts an asynchronous operation to deploy resources
     * specified by the <code>Baseline</code> to the specified Target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableBaselineRequest.Builder} avoiding the need to
     * create one manually via {@link EnableBaselineRequest#builder()}
     * </p>
     *
     * @param enableBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.EnableBaselineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the EnableBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.EnableBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/EnableBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableBaselineResponse> enableBaseline(Consumer<EnableBaselineRequest.Builder> enableBaselineRequest) {
        return enableBaseline(EnableBaselineRequest.builder().applyMutation(enableBaselineRequest).build());
    }

    /**
     * <p>
     * This API call activates a control. It starts an asynchronous operation that creates Amazon Web Services resources
     * on the specified organizational unit and the accounts it contains. The resources created will vary according to
     * the control that you specify. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param enableControlRequest
     * @return A Java Future containing the result of the EnableControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.EnableControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/EnableControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableControlResponse> enableControl(EnableControlRequest enableControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API call activates a control. It starts an asynchronous operation that creates Amazon Web Services resources
     * on the specified organizational unit and the accounts it contains. The resources created will vary according to
     * the control that you specify. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableControlRequest.Builder} avoiding the need to
     * create one manually via {@link EnableControlRequest#builder()}
     * </p>
     *
     * @param enableControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.EnableControlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the EnableControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.EnableControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/EnableControl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableControlResponse> enableControl(Consumer<EnableControlRequest.Builder> enableControlRequest) {
        return enableControl(EnableControlRequest.builder().applyMutation(enableControlRequest).build());
    }

    /**
     * <p>
     * Retrieve details about an existing <code>Baseline</code> resource by specifying its identifier.
     * </p>
     *
     * @param getBaselineRequest
     * @return A Java Future containing the result of the GetBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBaselineResponse> getBaseline(GetBaselineRequest getBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve details about an existing <code>Baseline</code> resource by specifying its identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBaselineRequest.Builder} avoiding the need to
     * create one manually via {@link GetBaselineRequest#builder()}
     * </p>
     *
     * @param getBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetBaselineRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBaselineResponse> getBaseline(Consumer<GetBaselineRequest.Builder> getBaselineRequest) {
        return getBaseline(GetBaselineRequest.builder().applyMutation(getBaselineRequest).build());
    }

    /**
     * <p>
     * Returns the details of an asynchronous baseline operation, as initiated by any of these APIs:
     * <code>EnableBaseline</code>, <code>DisableBaseline</code>, <code>UpdateEnabledBaseline</code>,
     * <code>ResetEnabledBaseline</code>. A status message is displayed in case of operation failure.
     * </p>
     *
     * @param getBaselineOperationRequest
     * @return A Java Future containing the result of the GetBaselineOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetBaselineOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetBaselineOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBaselineOperationResponse> getBaselineOperation(
            GetBaselineOperationRequest getBaselineOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of an asynchronous baseline operation, as initiated by any of these APIs:
     * <code>EnableBaseline</code>, <code>DisableBaseline</code>, <code>UpdateEnabledBaseline</code>,
     * <code>ResetEnabledBaseline</code>. A status message is displayed in case of operation failure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBaselineOperationRequest.Builder} avoiding the
     * need to create one manually via {@link GetBaselineOperationRequest#builder()}
     * </p>
     *
     * @param getBaselineOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetBaselineOperationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBaselineOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetBaselineOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetBaselineOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBaselineOperationResponse> getBaselineOperation(
            Consumer<GetBaselineOperationRequest.Builder> getBaselineOperationRequest) {
        return getBaselineOperation(GetBaselineOperationRequest.builder().applyMutation(getBaselineOperationRequest).build());
    }

    /**
     * <p>
     * Returns the status of a particular <code>EnableControl</code> or <code>DisableControl</code> operation. Displays
     * a message in case of error. Details for an operation are available for 90 days. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param getControlOperationRequest
     * @return A Java Future containing the result of the GetControlOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetControlOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetControlOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetControlOperationResponse> getControlOperation(
            GetControlOperationRequest getControlOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of a particular <code>EnableControl</code> or <code>DisableControl</code> operation. Displays
     * a message in case of error. Details for an operation are available for 90 days. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetControlOperationRequest.Builder} avoiding the
     * need to create one manually via {@link GetControlOperationRequest#builder()}
     * </p>
     *
     * @param getControlOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetControlOperationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetControlOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetControlOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetControlOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetControlOperationResponse> getControlOperation(
            Consumer<GetControlOperationRequest.Builder> getControlOperationRequest) {
        return getControlOperation(GetControlOperationRequest.builder().applyMutation(getControlOperationRequest).build());
    }

    /**
     * <p>
     * Retrieve details of an <code>EnabledBaseline</code> resource by specifying its identifier.
     * </p>
     *
     * @param getEnabledBaselineRequest
     * @return A Java Future containing the result of the GetEnabledBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnabledBaselineResponse> getEnabledBaseline(GetEnabledBaselineRequest getEnabledBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve details of an <code>EnabledBaseline</code> resource by specifying its identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnabledBaselineRequest#builder()}
     * </p>
     *
     * @param getEnabledBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetEnabledBaselineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnabledBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnabledBaselineResponse> getEnabledBaseline(
            Consumer<GetEnabledBaselineRequest.Builder> getEnabledBaselineRequest) {
        return getEnabledBaseline(GetEnabledBaselineRequest.builder().applyMutation(getEnabledBaselineRequest).build());
    }

    /**
     * <p>
     * Retrieves details about an enabled control. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param getEnabledControlRequest
     * @return A Java Future containing the result of the GetEnabledControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetEnabledControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetEnabledControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnabledControlResponse> getEnabledControl(GetEnabledControlRequest getEnabledControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an enabled control. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledControlRequest.Builder} avoiding the need
     * to create one manually via {@link GetEnabledControlRequest#builder()}
     * </p>
     *
     * @param getEnabledControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetEnabledControlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnabledControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetEnabledControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetEnabledControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnabledControlResponse> getEnabledControl(
            Consumer<GetEnabledControlRequest.Builder> getEnabledControlRequest) {
        return getEnabledControl(GetEnabledControlRequest.builder().applyMutation(getEnabledControlRequest).build());
    }

    /**
     * <p>
     * Returns details about the landing zone. Displays a message in case of error.
     * </p>
     *
     * @param getLandingZoneRequest
     * @return A Java Future containing the result of the GetLandingZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetLandingZone" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLandingZoneResponse> getLandingZone(GetLandingZoneRequest getLandingZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the landing zone. Displays a message in case of error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLandingZoneRequest.Builder} avoiding the need to
     * create one manually via {@link GetLandingZoneRequest#builder()}
     * </p>
     *
     * @param getLandingZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetLandingZoneRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLandingZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetLandingZone" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLandingZoneResponse> getLandingZone(Consumer<GetLandingZoneRequest.Builder> getLandingZoneRequest) {
        return getLandingZone(GetLandingZoneRequest.builder().applyMutation(getLandingZoneRequest).build());
    }

    /**
     * <p>
     * Returns the status of the specified landing zone operation. Details for an operation are available for 60 days.
     * </p>
     *
     * @param getLandingZoneOperationRequest
     * @return A Java Future containing the result of the GetLandingZoneOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetLandingZoneOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetLandingZoneOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLandingZoneOperationResponse> getLandingZoneOperation(
            GetLandingZoneOperationRequest getLandingZoneOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of the specified landing zone operation. Details for an operation are available for 60 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLandingZoneOperationRequest.Builder} avoiding
     * the need to create one manually via {@link GetLandingZoneOperationRequest#builder()}
     * </p>
     *
     * @param getLandingZoneOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetLandingZoneOperationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetLandingZoneOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.GetLandingZoneOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetLandingZoneOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLandingZoneOperationResponse> getLandingZoneOperation(
            Consumer<GetLandingZoneOperationRequest.Builder> getLandingZoneOperationRequest) {
        return getLandingZoneOperation(GetLandingZoneOperationRequest.builder().applyMutation(getLandingZoneOperationRequest)
                .build());
    }

    /**
     * <p>
     * Returns a summary list of all available baselines.
     * </p>
     *
     * @param listBaselinesRequest
     * @return A Java Future containing the result of the ListBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBaselinesResponse> listBaselines(ListBaselinesRequest listBaselinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a summary list of all available baselines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBaselinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBaselinesRequest#builder()}
     * </p>
     *
     * @param listBaselinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListBaselinesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBaselinesResponse> listBaselines(Consumer<ListBaselinesRequest.Builder> listBaselinesRequest) {
        return listBaselines(ListBaselinesRequest.builder().applyMutation(listBaselinesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBaselines(software.amazon.awssdk.services.controltower.model.ListBaselinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListBaselinesPublisher publisher = client.listBaselinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListBaselinesPublisher publisher = client.listBaselinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.controltower.model.ListBaselinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.controltower.model.ListBaselinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBaselines(software.amazon.awssdk.services.controltower.model.ListBaselinesRequest)} operation.</b>
     * </p>
     *
     * @param listBaselinesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBaselinesPublisher listBaselinesPaginator(ListBaselinesRequest listBaselinesRequest) {
        return new ListBaselinesPublisher(this, listBaselinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBaselines(software.amazon.awssdk.services.controltower.model.ListBaselinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListBaselinesPublisher publisher = client.listBaselinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListBaselinesPublisher publisher = client.listBaselinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.controltower.model.ListBaselinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.controltower.model.ListBaselinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBaselines(software.amazon.awssdk.services.controltower.model.ListBaselinesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBaselinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBaselinesRequest#builder()}
     * </p>
     *
     * @param listBaselinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListBaselinesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBaselinesPublisher listBaselinesPaginator(Consumer<ListBaselinesRequest.Builder> listBaselinesRequest) {
        return listBaselinesPaginator(ListBaselinesRequest.builder().applyMutation(listBaselinesRequest).build());
    }

    /**
     * <p>
     * Returns a list of summaries describing <code>EnabledBaseline</code> resources. You can filter the list by the
     * corresponding <code>Baseline</code> or <code>Target</code> of the <code>EnabledBaseline</code> resources.
     * </p>
     *
     * @param listEnabledBaselinesRequest
     * @return A Java Future containing the result of the ListEnabledBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListEnabledBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledBaselines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnabledBaselinesResponse> listEnabledBaselines(
            ListEnabledBaselinesRequest listEnabledBaselinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of summaries describing <code>EnabledBaseline</code> resources. You can filter the list by the
     * corresponding <code>Baseline</code> or <code>Target</code> of the <code>EnabledBaseline</code> resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledBaselinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnabledBaselinesRequest#builder()}
     * </p>
     *
     * @param listEnabledBaselinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEnabledBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListEnabledBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledBaselines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnabledBaselinesResponse> listEnabledBaselines(
            Consumer<ListEnabledBaselinesRequest.Builder> listEnabledBaselinesRequest) {
        return listEnabledBaselines(ListEnabledBaselinesRequest.builder().applyMutation(listEnabledBaselinesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledBaselines(software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesPublisher publisher = client.listEnabledBaselinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesPublisher publisher = client.listEnabledBaselinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledBaselines(software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnabledBaselinesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListEnabledBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledBaselines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledBaselinesPublisher listEnabledBaselinesPaginator(ListEnabledBaselinesRequest listEnabledBaselinesRequest) {
        return new ListEnabledBaselinesPublisher(this, listEnabledBaselinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledBaselines(software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesPublisher publisher = client.listEnabledBaselinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesPublisher publisher = client.listEnabledBaselinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledBaselines(software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledBaselinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnabledBaselinesRequest#builder()}
     * </p>
     *
     * @param listEnabledBaselinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListEnabledBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledBaselines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledBaselinesPublisher listEnabledBaselinesPaginator(
            Consumer<ListEnabledBaselinesRequest.Builder> listEnabledBaselinesRequest) {
        return listEnabledBaselinesPaginator(ListEnabledBaselinesRequest.builder().applyMutation(listEnabledBaselinesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the controls enabled by Amazon Web Services Control Tower on the specified organizational unit and the
     * accounts it contains. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param listEnabledControlsRequest
     * @return A Java Future containing the result of the ListEnabledControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListEnabledControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledControls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnabledControlsResponse> listEnabledControls(
            ListEnabledControlsRequest listEnabledControlsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the controls enabled by Amazon Web Services Control Tower on the specified organizational unit and the
     * accounts it contains. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledControlsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnabledControlsRequest#builder()}
     * </p>
     *
     * @param listEnabledControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEnabledControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListEnabledControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledControls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnabledControlsResponse> listEnabledControls(
            Consumer<ListEnabledControlsRequest.Builder> listEnabledControlsRequest) {
        return listEnabledControls(ListEnabledControlsRequest.builder().applyMutation(listEnabledControlsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledControls(software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsPublisher publisher = client.listEnabledControlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsPublisher publisher = client.listEnabledControlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledControls(software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnabledControlsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListEnabledControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledControlsPublisher listEnabledControlsPaginator(ListEnabledControlsRequest listEnabledControlsRequest) {
        return new ListEnabledControlsPublisher(this, listEnabledControlsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledControls(software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsPublisher publisher = client.listEnabledControlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsPublisher publisher = client.listEnabledControlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledControls(software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledControlsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnabledControlsRequest#builder()}
     * </p>
     *
     * @param listEnabledControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListEnabledControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledControlsPublisher listEnabledControlsPaginator(
            Consumer<ListEnabledControlsRequest.Builder> listEnabledControlsRequest) {
        return listEnabledControlsPaginator(ListEnabledControlsRequest.builder().applyMutation(listEnabledControlsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the landing zone ARN for the landing zone deployed in your managed account. This API also creates an ARN
     * for existing accounts that do not yet have a landing zone ARN.
     * </p>
     * <p>
     * Returns one landing zone ARN.
     * </p>
     *
     * @param listLandingZonesRequest
     * @return A Java Future containing the result of the ListLandingZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListLandingZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZones" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLandingZonesResponse> listLandingZones(ListLandingZonesRequest listLandingZonesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the landing zone ARN for the landing zone deployed in your managed account. This API also creates an ARN
     * for existing accounts that do not yet have a landing zone ARN.
     * </p>
     * <p>
     * Returns one landing zone ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLandingZonesRequest.Builder} avoiding the need
     * to create one manually via {@link ListLandingZonesRequest#builder()}
     * </p>
     *
     * @param listLandingZonesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLandingZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListLandingZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZones" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLandingZonesResponse> listLandingZones(
            Consumer<ListLandingZonesRequest.Builder> listLandingZonesRequest) {
        return listLandingZones(ListLandingZonesRequest.builder().applyMutation(listLandingZonesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLandingZones(software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZonesPublisher publisher = client.listLandingZonesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZonesPublisher publisher = client.listLandingZonesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.controltower.model.ListLandingZonesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.controltower.model.ListLandingZonesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLandingZones(software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLandingZonesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListLandingZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZones" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLandingZonesPublisher listLandingZonesPaginator(ListLandingZonesRequest listLandingZonesRequest) {
        return new ListLandingZonesPublisher(this, listLandingZonesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLandingZones(software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZonesPublisher publisher = client.listLandingZonesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZonesPublisher publisher = client.listLandingZonesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.controltower.model.ListLandingZonesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.controltower.model.ListLandingZonesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLandingZones(software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLandingZonesRequest.Builder} avoiding the need
     * to create one manually via {@link ListLandingZonesRequest#builder()}
     * </p>
     *
     * @param listLandingZonesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListLandingZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZones" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLandingZonesPublisher listLandingZonesPaginator(Consumer<ListLandingZonesRequest.Builder> listLandingZonesRequest) {
        return listLandingZonesPaginator(ListLandingZonesRequest.builder().applyMutation(listLandingZonesRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags associated with the resource. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags associated with the resource. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Re-enables an <code>EnabledBaseline</code> resource. For example, this API can re-apply the existing
     * <code>Baseline</code> after a new member account is moved to the target OU.
     * </p>
     *
     * @param resetEnabledBaselineRequest
     * @return A Java Future containing the result of the ResetEnabledBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ResetEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ResetEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetEnabledBaselineResponse> resetEnabledBaseline(
            ResetEnabledBaselineRequest resetEnabledBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Re-enables an <code>EnabledBaseline</code> resource. For example, this API can re-apply the existing
     * <code>Baseline</code> after a new member account is moved to the target OU.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetEnabledBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link ResetEnabledBaselineRequest#builder()}
     * </p>
     *
     * @param resetEnabledBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ResetEnabledBaselineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResetEnabledBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ResetEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ResetEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetEnabledBaselineResponse> resetEnabledBaseline(
            Consumer<ResetEnabledBaselineRequest.Builder> resetEnabledBaselineRequest) {
        return resetEnabledBaseline(ResetEnabledBaselineRequest.builder().applyMutation(resetEnabledBaselineRequest).build());
    }

    /**
     * <p>
     * This API call resets a landing zone. It starts an asynchronous operation that resets the landing zone to the
     * parameters specified in its original configuration.
     * </p>
     *
     * @param resetLandingZoneRequest
     * @return A Java Future containing the result of the ResetLandingZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ResetLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ResetLandingZone" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetLandingZoneResponse> resetLandingZone(ResetLandingZoneRequest resetLandingZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API call resets a landing zone. It starts an asynchronous operation that resets the landing zone to the
     * parameters specified in its original configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetLandingZoneRequest.Builder} avoiding the need
     * to create one manually via {@link ResetLandingZoneRequest#builder()}
     * </p>
     *
     * @param resetLandingZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ResetLandingZoneRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResetLandingZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.ResetLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ResetLandingZone" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetLandingZoneResponse> resetLandingZone(
            Consumer<ResetLandingZoneRequest.Builder> resetLandingZoneRequest) {
        return resetLandingZone(ResetLandingZoneRequest.builder().applyMutation(resetLandingZoneRequest).build());
    }

    /**
     * <p>
     * Applies tags to a resource. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies tags to a resource. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an <code>EnabledBaseline</code> resource's applied parameters or version.
     * </p>
     *
     * @param updateEnabledBaselineRequest
     * @return A Java Future containing the result of the UpdateEnabledBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.UpdateEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnabledBaselineResponse> updateEnabledBaseline(
            UpdateEnabledBaselineRequest updateEnabledBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an <code>EnabledBaseline</code> resource's applied parameters or version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnabledBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEnabledBaselineRequest#builder()}
     * </p>
     *
     * @param updateEnabledBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.UpdateEnabledBaselineRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateEnabledBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.UpdateEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnabledBaselineResponse> updateEnabledBaseline(
            Consumer<UpdateEnabledBaselineRequest.Builder> updateEnabledBaselineRequest) {
        return updateEnabledBaseline(UpdateEnabledBaselineRequest.builder().applyMutation(updateEnabledBaselineRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an already enabled control.
     * </p>
     * <p>
     * If the enabled control shows an <code>EnablementStatus</code> of SUCCEEDED, supply parameters that are different
     * from the currently configured parameters. Otherwise, Amazon Web Services Control Tower will not accept the
     * request.
     * </p>
     * <p>
     * If the enabled control shows an <code>EnablementStatus</code> of FAILED, Amazon Web Services Control Tower will
     * update the control to match any valid parameters that you supply.
     * </p>
     * <p>
     * If the <code>DriftSummary</code> status for the control shows as DRIFTED, you cannot call this API. Instead, you
     * can update the control by calling <code>DisableControl</code> and again calling <code>EnableControl</code>, or
     * you can run an extending governance operation. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>
     * </p>
     *
     * @param updateEnabledControlRequest
     * @return A Java Future containing the result of the UpdateEnabledControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.UpdateEnabledControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateEnabledControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnabledControlResponse> updateEnabledControl(
            UpdateEnabledControlRequest updateEnabledControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an already enabled control.
     * </p>
     * <p>
     * If the enabled control shows an <code>EnablementStatus</code> of SUCCEEDED, supply parameters that are different
     * from the currently configured parameters. Otherwise, Amazon Web Services Control Tower will not accept the
     * request.
     * </p>
     * <p>
     * If the enabled control shows an <code>EnablementStatus</code> of FAILED, Amazon Web Services Control Tower will
     * update the control to match any valid parameters that you supply.
     * </p>
     * <p>
     * If the <code>DriftSummary</code> status for the control shows as DRIFTED, you cannot call this API. Instead, you
     * can update the control by calling <code>DisableControl</code> and again calling <code>EnableControl</code>, or
     * you can run an extending governance operation. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html"> <i>the Amazon
     * Web Services Control Tower User Guide</i> </a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnabledControlRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEnabledControlRequest#builder()}
     * </p>
     *
     * @param updateEnabledControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.UpdateEnabledControlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEnabledControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded. The limit is 10
     *         concurrent operations.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.UpdateEnabledControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateEnabledControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnabledControlResponse> updateEnabledControl(
            Consumer<UpdateEnabledControlRequest.Builder> updateEnabledControlRequest) {
        return updateEnabledControl(UpdateEnabledControlRequest.builder().applyMutation(updateEnabledControlRequest).build());
    }

    /**
     * <p>
     * This API call updates the landing zone. It starts an asynchronous operation that updates the landing zone based
     * on the new landing zone version, or on the changed parameters specified in the updated manifest file.
     * </p>
     *
     * @param updateLandingZoneRequest
     * @return A Java Future containing the result of the UpdateLandingZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.UpdateLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLandingZoneResponse> updateLandingZone(UpdateLandingZoneRequest updateLandingZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API call updates the landing zone. It starts an asynchronous operation that updates the landing zone based
     * on the new landing zone version, or on the changed parameters specified in the updated manifest file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLandingZoneRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLandingZoneRequest#builder()}
     * </p>
     *
     * @param updateLandingZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.UpdateLandingZoneRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLandingZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException Updating or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred during processing of a request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ControlTowerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ControlTowerAsyncClient.UpdateLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLandingZoneResponse> updateLandingZone(
            Consumer<UpdateLandingZoneRequest.Builder> updateLandingZoneRequest) {
        return updateLandingZone(UpdateLandingZoneRequest.builder().applyMutation(updateLandingZoneRequest).build());
    }

    @Override
    default ControlTowerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ControlTowerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ControlTowerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ControlTowerAsyncClient}.
     */
    static ControlTowerAsyncClientBuilder builder() {
        return new DefaultControlTowerAsyncClientBuilder();
    }
}
