/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnabledBaselineRequest extends ControlTowerRequest implements
        ToCopyableBuilder<UpdateEnabledBaselineRequest.Builder, UpdateEnabledBaselineRequest> {
    private static final SdkField<String> BASELINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baselineVersion").getter(getter(UpdateEnabledBaselineRequest::baselineVersion))
            .setter(setter(Builder::baselineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineVersion").build()).build();

    private static final SdkField<String> ENABLED_BASELINE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("enabledBaselineIdentifier").getter(getter(UpdateEnabledBaselineRequest::enabledBaselineIdentifier))
            .setter(setter(Builder::enabledBaselineIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledBaselineIdentifier").build())
            .build();

    private static final SdkField<List<EnabledBaselineParameter>> PARAMETERS_FIELD = SdkField
            .<List<EnabledBaselineParameter>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(UpdateEnabledBaselineRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnabledBaselineParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnabledBaselineParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_VERSION_FIELD,
            ENABLED_BASELINE_IDENTIFIER_FIELD, PARAMETERS_FIELD));

    private final String baselineVersion;

    private final String enabledBaselineIdentifier;

    private final List<EnabledBaselineParameter> parameters;

    private UpdateEnabledBaselineRequest(BuilderImpl builder) {
        super(builder);
        this.baselineVersion = builder.baselineVersion;
        this.enabledBaselineIdentifier = builder.enabledBaselineIdentifier;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * Specifies the new <code>Baseline</code> version, to which the <code>EnabledBaseline</code> should be updated.
     * </p>
     * 
     * @return Specifies the new <code>Baseline</code> version, to which the <code>EnabledBaseline</code> should be
     *         updated.
     */
    public final String baselineVersion() {
        return baselineVersion;
    }

    /**
     * <p>
     * Specifies the <code>EnabledBaseline</code> resource to be updated.
     * </p>
     * 
     * @return Specifies the <code>EnabledBaseline</code> resource to be updated.
     */
    public final String enabledBaselineIdentifier() {
        return enabledBaselineIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Parameters to apply when making an update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Parameters to apply when making an update.
     */
    public final List<EnabledBaselineParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baselineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(enabledBaselineIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnabledBaselineRequest)) {
            return false;
        }
        UpdateEnabledBaselineRequest other = (UpdateEnabledBaselineRequest) obj;
        return Objects.equals(baselineVersion(), other.baselineVersion())
                && Objects.equals(enabledBaselineIdentifier(), other.enabledBaselineIdentifier())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEnabledBaselineRequest").add("BaselineVersion", baselineVersion())
                .add("EnabledBaselineIdentifier", enabledBaselineIdentifier())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baselineVersion":
            return Optional.ofNullable(clazz.cast(baselineVersion()));
        case "enabledBaselineIdentifier":
            return Optional.ofNullable(clazz.cast(enabledBaselineIdentifier()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnabledBaselineRequest, T> g) {
        return obj -> g.apply((UpdateEnabledBaselineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEnabledBaselineRequest> {
        /**
         * <p>
         * Specifies the new <code>Baseline</code> version, to which the <code>EnabledBaseline</code> should be updated.
         * </p>
         * 
         * @param baselineVersion
         *        Specifies the new <code>Baseline</code> version, to which the <code>EnabledBaseline</code> should be
         *        updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineVersion(String baselineVersion);

        /**
         * <p>
         * Specifies the <code>EnabledBaseline</code> resource to be updated.
         * </p>
         * 
         * @param enabledBaselineIdentifier
         *        Specifies the <code>EnabledBaseline</code> resource to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledBaselineIdentifier(String enabledBaselineIdentifier);

        /**
         * <p>
         * Parameters to apply when making an update.
         * </p>
         * 
         * @param parameters
         *        Parameters to apply when making an update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<EnabledBaselineParameter> parameters);

        /**
         * <p>
         * Parameters to apply when making an update.
         * </p>
         * 
         * @param parameters
         *        Parameters to apply when making an update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(EnabledBaselineParameter... parameters);

        /**
         * <p>
         * Parameters to apply when making an update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineParameter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<EnabledBaselineParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<EnabledBaselineParameter>)
         */
        Builder parameters(Consumer<EnabledBaselineParameter.Builder>... parameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private String baselineVersion;

        private String enabledBaselineIdentifier;

        private List<EnabledBaselineParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnabledBaselineRequest model) {
            super(model);
            baselineVersion(model.baselineVersion);
            enabledBaselineIdentifier(model.enabledBaselineIdentifier);
            parameters(model.parameters);
        }

        public final String getBaselineVersion() {
            return baselineVersion;
        }

        public final void setBaselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
        }

        @Override
        public final Builder baselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
            return this;
        }

        public final String getEnabledBaselineIdentifier() {
            return enabledBaselineIdentifier;
        }

        public final void setEnabledBaselineIdentifier(String enabledBaselineIdentifier) {
            this.enabledBaselineIdentifier = enabledBaselineIdentifier;
        }

        @Override
        public final Builder enabledBaselineIdentifier(String enabledBaselineIdentifier) {
            this.enabledBaselineIdentifier = enabledBaselineIdentifier;
            return this;
        }

        public final List<EnabledBaselineParameter.Builder> getParameters() {
            List<EnabledBaselineParameter.Builder> result = EnabledBaselineParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<EnabledBaselineParameter.BuilderImpl> parameters) {
            this.parameters = EnabledBaselineParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<EnabledBaselineParameter> parameters) {
            this.parameters = EnabledBaselineParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(EnabledBaselineParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<EnabledBaselineParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> EnabledBaselineParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnabledBaselineRequest build() {
            return new UpdateEnabledBaselineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
