/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The deployment summary of an <code>EnabledControl</code> or <code>EnabledBaseline</code> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnablementStatusSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnablementStatusSummary.Builder, EnablementStatusSummary> {
    private static final SdkField<String> LAST_OPERATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastOperationIdentifier").getter(getter(EnablementStatusSummary::lastOperationIdentifier))
            .setter(setter(Builder::lastOperationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastOperationIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EnablementStatusSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAST_OPERATION_IDENTIFIER_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lastOperationIdentifier;

    private final String status;

    private EnablementStatusSummary(BuilderImpl builder) {
        this.lastOperationIdentifier = builder.lastOperationIdentifier;
        this.status = builder.status;
    }

    /**
     * <p>
     * The last operation identifier for the enabled resource.
     * </p>
     * 
     * @return The last operation identifier for the enabled resource.
     */
    public final String lastOperationIdentifier() {
        return lastOperationIdentifier;
    }

    /**
     * <p>
     * The deployment status of the enabled resource.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration was
     * deployed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNDER_CHANGE</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration is
     * changing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration failed to
     * deploy.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnablementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The deployment status of the enabled resource.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration was
     *         deployed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNDER_CHANGE</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration
     *         is changing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration failed
     *         to deploy.
     *         </p>
     *         </li>
     * @see EnablementStatus
     */
    public final EnablementStatus status() {
        return EnablementStatus.fromValue(status);
    }

    /**
     * <p>
     * The deployment status of the enabled resource.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration was
     * deployed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNDER_CHANGE</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration is
     * changing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration failed to
     * deploy.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnablementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The deployment status of the enabled resource.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration was
     *         deployed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNDER_CHANGE</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration
     *         is changing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration failed
     *         to deploy.
     *         </p>
     *         </li>
     * @see EnablementStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastOperationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnablementStatusSummary)) {
            return false;
        }
        EnablementStatusSummary other = (EnablementStatusSummary) obj;
        return Objects.equals(lastOperationIdentifier(), other.lastOperationIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnablementStatusSummary").add("LastOperationIdentifier", lastOperationIdentifier())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastOperationIdentifier":
            return Optional.ofNullable(clazz.cast(lastOperationIdentifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnablementStatusSummary, T> g) {
        return obj -> g.apply((EnablementStatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnablementStatusSummary> {
        /**
         * <p>
         * The last operation identifier for the enabled resource.
         * </p>
         * 
         * @param lastOperationIdentifier
         *        The last operation identifier for the enabled resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastOperationIdentifier(String lastOperationIdentifier);

        /**
         * <p>
         * The deployment status of the enabled resource.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration was
         * deployed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNDER_CHANGE</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration is
         * changing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration failed to
         * deploy.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The deployment status of the enabled resource.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration
         *        was deployed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNDER_CHANGE</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code>
         *        configuration is changing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration
         *        failed to deploy.
         *        </p>
         *        </li>
         * @see EnablementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnablementStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The deployment status of the enabled resource.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration was
         * deployed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNDER_CHANGE</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration is
         * changing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration failed to
         * deploy.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The deployment status of the enabled resource.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration
         *        was deployed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNDER_CHANGE</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code>
         *        configuration is changing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The <code>EnabledControl</code> or <code>EnabledBaseline</code> configuration
         *        failed to deploy.
         *        </p>
         *        </li>
         * @see EnablementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnablementStatus
         */
        Builder status(EnablementStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String lastOperationIdentifier;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EnablementStatusSummary model) {
            lastOperationIdentifier(model.lastOperationIdentifier);
            status(model.status);
        }

        public final String getLastOperationIdentifier() {
            return lastOperationIdentifier;
        }

        public final void setLastOperationIdentifier(String lastOperationIdentifier) {
            this.lastOperationIdentifier = lastOperationIdentifier;
        }

        @Override
        public final Builder lastOperationIdentifier(String lastOperationIdentifier) {
            this.lastOperationIdentifier = lastOperationIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnablementStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public EnablementStatusSummary build() {
            return new EnablementStatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
