/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListControlOperationsResponse extends ControlTowerResponse implements
        ToCopyableBuilder<ListControlOperationsResponse.Builder, ListControlOperationsResponse> {
    private static final SdkField<List<ControlOperationSummary>> CONTROL_OPERATIONS_FIELD = SdkField
            .<List<ControlOperationSummary>> builder(MarshallingType.LIST)
            .memberName("controlOperations")
            .getter(getter(ListControlOperationsResponse::controlOperations))
            .setter(setter(Builder::controlOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlOperationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlOperationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListControlOperationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_OPERATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ControlOperationSummary> controlOperations;

    private final String nextToken;

    private ListControlOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.controlOperations = builder.controlOperations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlOperations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasControlOperations() {
        return controlOperations != null && !(controlOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of output from control operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlOperations} method.
     * </p>
     * 
     * @return Returns a list of output from control operations.
     */
    public final List<ControlOperationSummary> controlOperations() {
        return controlOperations;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasControlOperations() ? controlOperations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlOperationsResponse)) {
            return false;
        }
        ListControlOperationsResponse other = (ListControlOperationsResponse) obj;
        return hasControlOperations() == other.hasControlOperations()
                && Objects.equals(controlOperations(), other.controlOperations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListControlOperationsResponse")
                .add("ControlOperations", hasControlOperations() ? controlOperations() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlOperations":
            return Optional.ofNullable(clazz.cast(controlOperations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListControlOperationsResponse, T> g) {
        return obj -> g.apply((ListControlOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListControlOperationsResponse> {
        /**
         * <p>
         * Returns a list of output from control operations.
         * </p>
         * 
         * @param controlOperations
         *        Returns a list of output from control operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlOperations(Collection<ControlOperationSummary> controlOperations);

        /**
         * <p>
         * Returns a list of output from control operations.
         * </p>
         * 
         * @param controlOperations
         *        Returns a list of output from control operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlOperations(ControlOperationSummary... controlOperations);

        /**
         * <p>
         * Returns a list of output from control operations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.controltower.model.ControlOperationSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.controltower.model.ControlOperationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.controltower.model.ControlOperationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #controlOperations(List<ControlOperationSummary>)}.
         * 
         * @param controlOperations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.controltower.model.ControlOperationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlOperations(java.util.Collection<ControlOperationSummary>)
         */
        Builder controlOperations(Consumer<ControlOperationSummary.Builder>... controlOperations);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ControlTowerResponse.BuilderImpl implements Builder {
        private List<ControlOperationSummary> controlOperations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlOperationsResponse model) {
            super(model);
            controlOperations(model.controlOperations);
            nextToken(model.nextToken);
        }

        public final List<ControlOperationSummary.Builder> getControlOperations() {
            List<ControlOperationSummary.Builder> result = ControlOperationsCopier.copyToBuilder(this.controlOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlOperations(Collection<ControlOperationSummary.BuilderImpl> controlOperations) {
            this.controlOperations = ControlOperationsCopier.copyFromBuilder(controlOperations);
        }

        @Override
        public final Builder controlOperations(Collection<ControlOperationSummary> controlOperations) {
            this.controlOperations = ControlOperationsCopier.copy(controlOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlOperations(ControlOperationSummary... controlOperations) {
            controlOperations(Arrays.asList(controlOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlOperations(Consumer<ControlOperationSummary.Builder>... controlOperations) {
            controlOperations(Stream.of(controlOperations).map(c -> ControlOperationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListControlOperationsResponse build() {
            return new ListControlOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
