/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnabledControlsRequest extends ControlTowerRequest implements
        ToCopyableBuilder<ListEnabledControlsRequest.Builder, ListEnabledControlsRequest> {
    private static final SdkField<EnabledControlFilter> FILTER_FIELD = SdkField
            .<EnabledControlFilter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListEnabledControlsRequest::filter)).setter(setter(Builder::filter))
            .constructor(EnabledControlFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEnabledControlsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnabledControlsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetIdentifier").getter(getter(ListEnabledControlsRequest::targetIdentifier))
            .setter(setter(Builder::targetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TARGET_IDENTIFIER_FIELD));

    private final EnabledControlFilter filter;

    private final Integer maxResults;

    private final String nextToken;

    private final String targetIdentifier;

    private ListEnabledControlsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.targetIdentifier = builder.targetIdentifier;
    }

    /**
     * <p>
     * An input filter for the <code>ListEnabledControls</code> API that lets you select the types of control operations
     * to view.
     * </p>
     * 
     * @return An input filter for the <code>ListEnabledControls</code> API that lets you select the types of control
     *         operations to view.
     */
    public final EnabledControlFilter filter() {
        return filter;
    }

    /**
     * <p>
     * How many results to return per API call.
     * </p>
     * 
     * @return How many results to return per API call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to continue the list from a previous API call with the same parameters.
     * </p>
     * 
     * @return The token to continue the list from a previous API call with the same parameters.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
     * </p>
     * 
     * @return The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see
     *         <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
     *         page</a>.
     */
    public final String targetIdentifier() {
        return targetIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(targetIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnabledControlsRequest)) {
            return false;
        }
        ListEnabledControlsRequest other = (ListEnabledControlsRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(targetIdentifier(), other.targetIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnabledControlsRequest").add("Filter", filter()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("TargetIdentifier", targetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "targetIdentifier":
            return Optional.ofNullable(clazz.cast(targetIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnabledControlsRequest, T> g) {
        return obj -> g.apply((ListEnabledControlsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEnabledControlsRequest> {
        /**
         * <p>
         * An input filter for the <code>ListEnabledControls</code> API that lets you select the types of control
         * operations to view.
         * </p>
         * 
         * @param filter
         *        An input filter for the <code>ListEnabledControls</code> API that lets you select the types of control
         *        operations to view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(EnabledControlFilter filter);

        /**
         * <p>
         * An input filter for the <code>ListEnabledControls</code> API that lets you select the types of control
         * operations to view.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnabledControlFilter.Builder} avoiding
         * the need to create one manually via {@link EnabledControlFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnabledControlFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #filter(EnabledControlFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link EnabledControlFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(EnabledControlFilter)
         */
        default Builder filter(Consumer<EnabledControlFilter.Builder> filter) {
            return filter(EnabledControlFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * How many results to return per API call.
         * </p>
         * 
         * @param maxResults
         *        How many results to return per API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to continue the list from a previous API call with the same parameters.
         * </p>
         * 
         * @param nextToken
         *        The token to continue the list from a previous API call with the same parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see <a
         * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
         * </p>
         * 
         * @param targetIdentifier
         *        The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>,
         *        see <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
         *        page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifier(String targetIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private EnabledControlFilter filter;

        private Integer maxResults;

        private String nextToken;

        private String targetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnabledControlsRequest model) {
            super(model);
            filter(model.filter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            targetIdentifier(model.targetIdentifier);
        }

        public final EnabledControlFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(EnabledControlFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(EnabledControlFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTargetIdentifier() {
            return targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnabledControlsRequest build() {
            return new ListEnabledControlsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
