/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter object that lets you call <code>ListControlOperations</code> with a specific filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlOperationFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ControlOperationFilter.Builder, ControlOperationFilter> {
    private static final SdkField<List<String>> CONTROL_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("controlIdentifiers")
            .getter(getter(ControlOperationFilter::controlIdentifiers))
            .setter(setter(Builder::controlIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONTROL_OPERATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("controlOperationTypes")
            .getter(getter(ControlOperationFilter::controlOperationTypesAsStrings))
            .setter(setter(Builder::controlOperationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlOperationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENABLED_CONTROL_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("enabledControlIdentifiers")
            .getter(getter(ControlOperationFilter::enabledControlIdentifiers))
            .setter(setter(Builder::enabledControlIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledControlIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statuses")
            .getter(getter(ControlOperationFilter::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targetIdentifiers")
            .getter(getter(ControlOperationFilter::targetIdentifiers))
            .setter(setter(Builder::targetIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_IDENTIFIERS_FIELD,
            CONTROL_OPERATION_TYPES_FIELD, ENABLED_CONTROL_IDENTIFIERS_FIELD, STATUSES_FIELD, TARGET_IDENTIFIERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> controlIdentifiers;

    private final List<String> controlOperationTypes;

    private final List<String> enabledControlIdentifiers;

    private final List<String> statuses;

    private final List<String> targetIdentifiers;

    private ControlOperationFilter(BuilderImpl builder) {
        this.controlIdentifiers = builder.controlIdentifiers;
        this.controlOperationTypes = builder.controlOperationTypes;
        this.enabledControlIdentifiers = builder.enabledControlIdentifiers;
        this.statuses = builder.statuses;
        this.targetIdentifiers = builder.targetIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasControlIdentifiers() {
        return controlIdentifiers != null && !(controlIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of <code>controlIdentifier</code> returned by the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlIdentifiers} method.
     * </p>
     * 
     * @return The set of <code>controlIdentifier</code> returned by the filter.
     */
    public final List<String> controlIdentifiers() {
        return controlIdentifiers;
    }

    /**
     * <p>
     * The set of <code>ControlOperation</code> objects returned by the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlOperationTypes} method.
     * </p>
     * 
     * @return The set of <code>ControlOperation</code> objects returned by the filter.
     */
    public final List<ControlOperationType> controlOperationTypes() {
        return ControlOperationTypesCopier.copyStringToEnum(controlOperationTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlOperationTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasControlOperationTypes() {
        return controlOperationTypes != null && !(controlOperationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of <code>ControlOperation</code> objects returned by the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlOperationTypes} method.
     * </p>
     * 
     * @return The set of <code>ControlOperation</code> objects returned by the filter.
     */
    public final List<String> controlOperationTypesAsStrings() {
        return controlOperationTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledControlIdentifiers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledControlIdentifiers() {
        return enabledControlIdentifiers != null && !(enabledControlIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set <code>controlIdentifier</code> of enabled controls selected by the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledControlIdentifiers} method.
     * </p>
     * 
     * @return The set <code>controlIdentifier</code> of enabled controls selected by the filter.
     */
    public final List<String> enabledControlIdentifiers() {
        return enabledControlIdentifiers;
    }

    /**
     * <p>
     * Lists the status of control operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return Lists the status of control operations.
     */
    public final List<ControlOperationStatus> statuses() {
        return ControlOperationStatusesCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the status of control operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return Lists the status of control operations.
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetIdentifiers() {
        return targetIdentifiers != null && !(targetIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of <code>targetIdentifier</code> objects returned by the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetIdentifiers} method.
     * </p>
     * 
     * @return The set of <code>targetIdentifier</code> objects returned by the filter.
     */
    public final List<String> targetIdentifiers() {
        return targetIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasControlIdentifiers() ? controlIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasControlOperationTypes() ? controlOperationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledControlIdentifiers() ? enabledControlIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetIdentifiers() ? targetIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlOperationFilter)) {
            return false;
        }
        ControlOperationFilter other = (ControlOperationFilter) obj;
        return hasControlIdentifiers() == other.hasControlIdentifiers()
                && Objects.equals(controlIdentifiers(), other.controlIdentifiers())
                && hasControlOperationTypes() == other.hasControlOperationTypes()
                && Objects.equals(controlOperationTypesAsStrings(), other.controlOperationTypesAsStrings())
                && hasEnabledControlIdentifiers() == other.hasEnabledControlIdentifiers()
                && Objects.equals(enabledControlIdentifiers(), other.enabledControlIdentifiers())
                && hasStatuses() == other.hasStatuses() && Objects.equals(statusesAsStrings(), other.statusesAsStrings())
                && hasTargetIdentifiers() == other.hasTargetIdentifiers()
                && Objects.equals(targetIdentifiers(), other.targetIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlOperationFilter")
                .add("ControlIdentifiers", hasControlIdentifiers() ? controlIdentifiers() : null)
                .add("ControlOperationTypes", hasControlOperationTypes() ? controlOperationTypesAsStrings() : null)
                .add("EnabledControlIdentifiers", hasEnabledControlIdentifiers() ? enabledControlIdentifiers() : null)
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null)
                .add("TargetIdentifiers", hasTargetIdentifiers() ? targetIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlIdentifiers":
            return Optional.ofNullable(clazz.cast(controlIdentifiers()));
        case "controlOperationTypes":
            return Optional.ofNullable(clazz.cast(controlOperationTypesAsStrings()));
        case "enabledControlIdentifiers":
            return Optional.ofNullable(clazz.cast(enabledControlIdentifiers()));
        case "statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        case "targetIdentifiers":
            return Optional.ofNullable(clazz.cast(targetIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlOperationFilter, T> g) {
        return obj -> g.apply((ControlOperationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlOperationFilter> {
        /**
         * <p>
         * The set of <code>controlIdentifier</code> returned by the filter.
         * </p>
         * 
         * @param controlIdentifiers
         *        The set of <code>controlIdentifier</code> returned by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlIdentifiers(Collection<String> controlIdentifiers);

        /**
         * <p>
         * The set of <code>controlIdentifier</code> returned by the filter.
         * </p>
         * 
         * @param controlIdentifiers
         *        The set of <code>controlIdentifier</code> returned by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlIdentifiers(String... controlIdentifiers);

        /**
         * <p>
         * The set of <code>ControlOperation</code> objects returned by the filter.
         * </p>
         * 
         * @param controlOperationTypes
         *        The set of <code>ControlOperation</code> objects returned by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlOperationTypesWithStrings(Collection<String> controlOperationTypes);

        /**
         * <p>
         * The set of <code>ControlOperation</code> objects returned by the filter.
         * </p>
         * 
         * @param controlOperationTypes
         *        The set of <code>ControlOperation</code> objects returned by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlOperationTypesWithStrings(String... controlOperationTypes);

        /**
         * <p>
         * The set of <code>ControlOperation</code> objects returned by the filter.
         * </p>
         * 
         * @param controlOperationTypes
         *        The set of <code>ControlOperation</code> objects returned by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlOperationTypes(Collection<ControlOperationType> controlOperationTypes);

        /**
         * <p>
         * The set of <code>ControlOperation</code> objects returned by the filter.
         * </p>
         * 
         * @param controlOperationTypes
         *        The set of <code>ControlOperation</code> objects returned by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlOperationTypes(ControlOperationType... controlOperationTypes);

        /**
         * <p>
         * The set <code>controlIdentifier</code> of enabled controls selected by the filter.
         * </p>
         * 
         * @param enabledControlIdentifiers
         *        The set <code>controlIdentifier</code> of enabled controls selected by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledControlIdentifiers(Collection<String> enabledControlIdentifiers);

        /**
         * <p>
         * The set <code>controlIdentifier</code> of enabled controls selected by the filter.
         * </p>
         * 
         * @param enabledControlIdentifiers
         *        The set <code>controlIdentifier</code> of enabled controls selected by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledControlIdentifiers(String... enabledControlIdentifiers);

        /**
         * <p>
         * Lists the status of control operations.
         * </p>
         * 
         * @param statuses
         *        Lists the status of control operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * Lists the status of control operations.
         * </p>
         * 
         * @param statuses
         *        Lists the status of control operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * Lists the status of control operations.
         * </p>
         * 
         * @param statuses
         *        Lists the status of control operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<ControlOperationStatus> statuses);

        /**
         * <p>
         * Lists the status of control operations.
         * </p>
         * 
         * @param statuses
         *        Lists the status of control operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(ControlOperationStatus... statuses);

        /**
         * <p>
         * The set of <code>targetIdentifier</code> objects returned by the filter.
         * </p>
         * 
         * @param targetIdentifiers
         *        The set of <code>targetIdentifier</code> objects returned by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifiers(Collection<String> targetIdentifiers);

        /**
         * <p>
         * The set of <code>targetIdentifier</code> objects returned by the filter.
         * </p>
         * 
         * @param targetIdentifiers
         *        The set of <code>targetIdentifier</code> objects returned by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifiers(String... targetIdentifiers);
    }

    static final class BuilderImpl implements Builder {
        private List<String> controlIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> controlOperationTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> enabledControlIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ControlOperationFilter model) {
            controlIdentifiers(model.controlIdentifiers);
            controlOperationTypesWithStrings(model.controlOperationTypes);
            enabledControlIdentifiers(model.enabledControlIdentifiers);
            statusesWithStrings(model.statuses);
            targetIdentifiers(model.targetIdentifiers);
        }

        public final Collection<String> getControlIdentifiers() {
            if (controlIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return controlIdentifiers;
        }

        public final void setControlIdentifiers(Collection<String> controlIdentifiers) {
            this.controlIdentifiers = ControlIdentifiersCopier.copy(controlIdentifiers);
        }

        @Override
        public final Builder controlIdentifiers(Collection<String> controlIdentifiers) {
            this.controlIdentifiers = ControlIdentifiersCopier.copy(controlIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlIdentifiers(String... controlIdentifiers) {
            controlIdentifiers(Arrays.asList(controlIdentifiers));
            return this;
        }

        public final Collection<String> getControlOperationTypes() {
            if (controlOperationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return controlOperationTypes;
        }

        public final void setControlOperationTypes(Collection<String> controlOperationTypes) {
            this.controlOperationTypes = ControlOperationTypesCopier.copy(controlOperationTypes);
        }

        @Override
        public final Builder controlOperationTypesWithStrings(Collection<String> controlOperationTypes) {
            this.controlOperationTypes = ControlOperationTypesCopier.copy(controlOperationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlOperationTypesWithStrings(String... controlOperationTypes) {
            controlOperationTypesWithStrings(Arrays.asList(controlOperationTypes));
            return this;
        }

        @Override
        public final Builder controlOperationTypes(Collection<ControlOperationType> controlOperationTypes) {
            this.controlOperationTypes = ControlOperationTypesCopier.copyEnumToString(controlOperationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlOperationTypes(ControlOperationType... controlOperationTypes) {
            controlOperationTypes(Arrays.asList(controlOperationTypes));
            return this;
        }

        public final Collection<String> getEnabledControlIdentifiers() {
            if (enabledControlIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledControlIdentifiers;
        }

        public final void setEnabledControlIdentifiers(Collection<String> enabledControlIdentifiers) {
            this.enabledControlIdentifiers = EnabledControlIdentifiersCopier.copy(enabledControlIdentifiers);
        }

        @Override
        public final Builder enabledControlIdentifiers(Collection<String> enabledControlIdentifiers) {
            this.enabledControlIdentifiers = EnabledControlIdentifiersCopier.copy(enabledControlIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledControlIdentifiers(String... enabledControlIdentifiers) {
            enabledControlIdentifiers(Arrays.asList(enabledControlIdentifiers));
            return this;
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = ControlOperationStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = ControlOperationStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<ControlOperationStatus> statuses) {
            this.statuses = ControlOperationStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(ControlOperationStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        public final Collection<String> getTargetIdentifiers() {
            if (targetIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return targetIdentifiers;
        }

        public final void setTargetIdentifiers(Collection<String> targetIdentifiers) {
            this.targetIdentifiers = TargetIdentifiersCopier.copy(targetIdentifiers);
        }

        @Override
        public final Builder targetIdentifiers(Collection<String> targetIdentifiers) {
            this.targetIdentifiers = TargetIdentifiersCopier.copy(targetIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIdentifiers(String... targetIdentifiers) {
            targetIdentifiers(Arrays.asList(targetIdentifiers));
            return this;
        }

        @Override
        public ControlOperationFilter build() {
            return new ControlOperationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
