/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about the specified control operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlOperationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ControlOperationSummary.Builder, ControlOperationSummary> {
    private static final SdkField<String> CONTROL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlIdentifier").getter(getter(ControlOperationSummary::controlIdentifier))
            .setter(setter(Builder::controlIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifier").build()).build();

    private static final SdkField<String> ENABLED_CONTROL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("enabledControlIdentifier").getter(getter(ControlOperationSummary::enabledControlIdentifier))
            .setter(setter(Builder::enabledControlIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledControlIdentifier").build())
            .build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(ControlOperationSummary::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> OPERATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationIdentifier").getter(getter(ControlOperationSummary::operationIdentifier))
            .setter(setter(Builder::operationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationIdentifier").build())
            .build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationType").getter(getter(ControlOperationSummary::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(ControlOperationSummary::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ControlOperationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ControlOperationSummary::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetIdentifier").getter(getter(ControlOperationSummary::targetIdentifier))
            .setter(setter(Builder::targetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_IDENTIFIER_FIELD,
            ENABLED_CONTROL_IDENTIFIER_FIELD, END_TIME_FIELD, OPERATION_IDENTIFIER_FIELD, OPERATION_TYPE_FIELD, START_TIME_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, TARGET_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String controlIdentifier;

    private final String enabledControlIdentifier;

    private final Instant endTime;

    private final String operationIdentifier;

    private final String operationType;

    private final Instant startTime;

    private final String status;

    private final String statusMessage;

    private final String targetIdentifier;

    private ControlOperationSummary(BuilderImpl builder) {
        this.controlIdentifier = builder.controlIdentifier;
        this.enabledControlIdentifier = builder.enabledControlIdentifier;
        this.endTime = builder.endTime;
        this.operationIdentifier = builder.operationIdentifier;
        this.operationType = builder.operationType;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.targetIdentifier = builder.targetIdentifier;
    }

    /**
     * <p>
     * The <code>controlIdentifier</code> of a control.
     * </p>
     * 
     * @return The <code>controlIdentifier</code> of a control.
     */
    public final String controlIdentifier() {
        return controlIdentifier;
    }

    /**
     * <p>
     * The <code>controlIdentifier</code> of an enabled control.
     * </p>
     * 
     * @return The <code>controlIdentifier</code> of an enabled control.
     */
    public final String enabledControlIdentifier() {
        return enabledControlIdentifier;
    }

    /**
     * <p>
     * The time at which the control operation was completed.
     * </p>
     * 
     * @return The time at which the control operation was completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The unique identifier of a control operation.
     * </p>
     * 
     * @return The unique identifier of a control operation.
     */
    public final String operationIdentifier() {
        return operationIdentifier;
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link ControlOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The type of operation.
     * @see ControlOperationType
     */
    public final ControlOperationType operationType() {
        return ControlOperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link ControlOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The type of operation.
     * @see ControlOperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The time at which a control operation began.
     * </p>
     * 
     * @return The time at which a control operation began.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of the specified control operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ControlOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the specified control operation.
     * @see ControlOperationStatus
     */
    public final ControlOperationStatus status() {
        return ControlOperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the specified control operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ControlOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the specified control operation.
     * @see ControlOperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A speficic message displayed as part of the control status.
     * </p>
     * 
     * @return A speficic message displayed as part of the control status.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The unique identifier of the target of a control operation.
     * </p>
     * 
     * @return The unique identifier of the target of a control operation.
     */
    public final String targetIdentifier() {
        return targetIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(controlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(enabledControlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(operationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(targetIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlOperationSummary)) {
            return false;
        }
        ControlOperationSummary other = (ControlOperationSummary) obj;
        return Objects.equals(controlIdentifier(), other.controlIdentifier())
                && Objects.equals(enabledControlIdentifier(), other.enabledControlIdentifier())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(operationIdentifier(), other.operationIdentifier())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(targetIdentifier(), other.targetIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlOperationSummary").add("ControlIdentifier", controlIdentifier())
                .add("EnabledControlIdentifier", enabledControlIdentifier()).add("EndTime", endTime())
                .add("OperationIdentifier", operationIdentifier()).add("OperationType", operationTypeAsString())
                .add("StartTime", startTime()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("TargetIdentifier", targetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlIdentifier":
            return Optional.ofNullable(clazz.cast(controlIdentifier()));
        case "enabledControlIdentifier":
            return Optional.ofNullable(clazz.cast(enabledControlIdentifier()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "operationIdentifier":
            return Optional.ofNullable(clazz.cast(operationIdentifier()));
        case "operationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "targetIdentifier":
            return Optional.ofNullable(clazz.cast(targetIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlOperationSummary, T> g) {
        return obj -> g.apply((ControlOperationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlOperationSummary> {
        /**
         * <p>
         * The <code>controlIdentifier</code> of a control.
         * </p>
         * 
         * @param controlIdentifier
         *        The <code>controlIdentifier</code> of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlIdentifier(String controlIdentifier);

        /**
         * <p>
         * The <code>controlIdentifier</code> of an enabled control.
         * </p>
         * 
         * @param enabledControlIdentifier
         *        The <code>controlIdentifier</code> of an enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledControlIdentifier(String enabledControlIdentifier);

        /**
         * <p>
         * The time at which the control operation was completed.
         * </p>
         * 
         * @param endTime
         *        The time at which the control operation was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The unique identifier of a control operation.
         * </p>
         * 
         * @param operationIdentifier
         *        The unique identifier of a control operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationIdentifier(String operationIdentifier);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param operationType
         *        The type of operation.
         * @see ControlOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlOperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param operationType
         *        The type of operation.
         * @see ControlOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlOperationType
         */
        Builder operationType(ControlOperationType operationType);

        /**
         * <p>
         * The time at which a control operation began.
         * </p>
         * 
         * @param startTime
         *        The time at which a control operation began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of the specified control operation.
         * </p>
         * 
         * @param status
         *        The status of the specified control operation.
         * @see ControlOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlOperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the specified control operation.
         * </p>
         * 
         * @param status
         *        The status of the specified control operation.
         * @see ControlOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlOperationStatus
         */
        Builder status(ControlOperationStatus status);

        /**
         * <p>
         * A speficic message displayed as part of the control status.
         * </p>
         * 
         * @param statusMessage
         *        A speficic message displayed as part of the control status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The unique identifier of the target of a control operation.
         * </p>
         * 
         * @param targetIdentifier
         *        The unique identifier of the target of a control operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifier(String targetIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String controlIdentifier;

        private String enabledControlIdentifier;

        private Instant endTime;

        private String operationIdentifier;

        private String operationType;

        private Instant startTime;

        private String status;

        private String statusMessage;

        private String targetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlOperationSummary model) {
            controlIdentifier(model.controlIdentifier);
            enabledControlIdentifier(model.enabledControlIdentifier);
            endTime(model.endTime);
            operationIdentifier(model.operationIdentifier);
            operationType(model.operationType);
            startTime(model.startTime);
            status(model.status);
            statusMessage(model.statusMessage);
            targetIdentifier(model.targetIdentifier);
        }

        public final String getControlIdentifier() {
            return controlIdentifier;
        }

        public final void setControlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
        }

        @Override
        public final Builder controlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
            return this;
        }

        public final String getEnabledControlIdentifier() {
            return enabledControlIdentifier;
        }

        public final void setEnabledControlIdentifier(String enabledControlIdentifier) {
            this.enabledControlIdentifier = enabledControlIdentifier;
        }

        @Override
        public final Builder enabledControlIdentifier(String enabledControlIdentifier) {
            this.enabledControlIdentifier = enabledControlIdentifier;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getOperationIdentifier() {
            return operationIdentifier;
        }

        public final void setOperationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
        }

        @Override
        public final Builder operationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
            return this;
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(ControlOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ControlOperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getTargetIdentifier() {
            return targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        @Override
        public ControlOperationSummary build() {
            return new ControlOperationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
