/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the <code>EnabledBaseline</code> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledBaselineDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EnabledBaselineDetails.Builder, EnabledBaselineDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EnabledBaselineDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> BASELINE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baselineIdentifier").getter(getter(EnabledBaselineDetails::baselineIdentifier))
            .setter(setter(Builder::baselineIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineIdentifier").build())
            .build();

    private static final SdkField<String> BASELINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baselineVersion").getter(getter(EnabledBaselineDetails::baselineVersion))
            .setter(setter(Builder::baselineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineVersion").build()).build();

    private static final SdkField<List<EnabledBaselineParameterSummary>> PARAMETERS_FIELD = SdkField
            .<List<EnabledBaselineParameterSummary>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(EnabledBaselineDetails::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnabledBaselineParameterSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnabledBaselineParameterSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EnablementStatusSummary> STATUS_SUMMARY_FIELD = SdkField
            .<EnablementStatusSummary> builder(MarshallingType.SDK_POJO).memberName("statusSummary")
            .getter(getter(EnabledBaselineDetails::statusSummary)).setter(setter(Builder::statusSummary))
            .constructor(EnablementStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()).build();

    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetIdentifier").getter(getter(EnabledBaselineDetails::targetIdentifier))
            .setter(setter(Builder::targetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            BASELINE_IDENTIFIER_FIELD, BASELINE_VERSION_FIELD, PARAMETERS_FIELD, STATUS_SUMMARY_FIELD, TARGET_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String baselineIdentifier;

    private final String baselineVersion;

    private final List<EnabledBaselineParameterSummary> parameters;

    private final EnablementStatusSummary statusSummary;

    private final String targetIdentifier;

    private EnabledBaselineDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.baselineIdentifier = builder.baselineIdentifier;
        this.baselineVersion = builder.baselineVersion;
        this.parameters = builder.parameters;
        this.statusSummary = builder.statusSummary;
        this.targetIdentifier = builder.targetIdentifier;
    }

    /**
     * <p>
     * The ARN of the <code>EnabledBaseline</code> resource.
     * </p>
     * 
     * @return The ARN of the <code>EnabledBaseline</code> resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The specific <code>Baseline</code> enabled as part of the <code>EnabledBaseline</code> resource.
     * </p>
     * 
     * @return The specific <code>Baseline</code> enabled as part of the <code>EnabledBaseline</code> resource.
     */
    public final String baselineIdentifier() {
        return baselineIdentifier;
    }

    /**
     * <p>
     * The enabled version of the <code>Baseline</code>.
     * </p>
     * 
     * @return The enabled version of the <code>Baseline</code>.
     */
    public final String baselineVersion() {
        return baselineVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Shows the parameters that are applied when enabling this <code>Baseline</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Shows the parameters that are applied when enabling this <code>Baseline</code>.
     */
    public final List<EnabledBaselineParameterSummary> parameters() {
        return parameters;
    }

    /**
     * Returns the value of the StatusSummary property for this object.
     * 
     * @return The value of the StatusSummary property for this object.
     */
    public final EnablementStatusSummary statusSummary() {
        return statusSummary;
    }

    /**
     * <p>
     * The target on which to enable the <code>Baseline</code>.
     * </p>
     * 
     * @return The target on which to enable the <code>Baseline</code>.
     */
    public final String targetIdentifier() {
        return targetIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(baselineIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(baselineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(targetIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledBaselineDetails)) {
            return false;
        }
        EnabledBaselineDetails other = (EnabledBaselineDetails) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(baselineIdentifier(), other.baselineIdentifier())
                && Objects.equals(baselineVersion(), other.baselineVersion()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(statusSummary(), other.statusSummary())
                && Objects.equals(targetIdentifier(), other.targetIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnabledBaselineDetails").add("Arn", arn()).add("BaselineIdentifier", baselineIdentifier())
                .add("BaselineVersion", baselineVersion()).add("Parameters", hasParameters() ? parameters() : null)
                .add("StatusSummary", statusSummary()).add("TargetIdentifier", targetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "baselineIdentifier":
            return Optional.ofNullable(clazz.cast(baselineIdentifier()));
        case "baselineVersion":
            return Optional.ofNullable(clazz.cast(baselineVersion()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "statusSummary":
            return Optional.ofNullable(clazz.cast(statusSummary()));
        case "targetIdentifier":
            return Optional.ofNullable(clazz.cast(targetIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnabledBaselineDetails, T> g) {
        return obj -> g.apply((EnabledBaselineDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnabledBaselineDetails> {
        /**
         * <p>
         * The ARN of the <code>EnabledBaseline</code> resource.
         * </p>
         * 
         * @param arn
         *        The ARN of the <code>EnabledBaseline</code> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The specific <code>Baseline</code> enabled as part of the <code>EnabledBaseline</code> resource.
         * </p>
         * 
         * @param baselineIdentifier
         *        The specific <code>Baseline</code> enabled as part of the <code>EnabledBaseline</code> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentifier(String baselineIdentifier);

        /**
         * <p>
         * The enabled version of the <code>Baseline</code>.
         * </p>
         * 
         * @param baselineVersion
         *        The enabled version of the <code>Baseline</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineVersion(String baselineVersion);

        /**
         * <p>
         * Shows the parameters that are applied when enabling this <code>Baseline</code>.
         * </p>
         * 
         * @param parameters
         *        Shows the parameters that are applied when enabling this <code>Baseline</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<EnabledBaselineParameterSummary> parameters);

        /**
         * <p>
         * Shows the parameters that are applied when enabling this <code>Baseline</code>.
         * </p>
         * 
         * @param parameters
         *        Shows the parameters that are applied when enabling this <code>Baseline</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(EnabledBaselineParameterSummary... parameters);

        /**
         * <p>
         * Shows the parameters that are applied when enabling this <code>Baseline</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineParameterSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineParameterSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineParameterSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #parameters(List<EnabledBaselineParameterSummary>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineParameterSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<EnabledBaselineParameterSummary>)
         */
        Builder parameters(Consumer<EnabledBaselineParameterSummary.Builder>... parameters);

        /**
         * Sets the value of the StatusSummary property for this object.
         *
         * @param statusSummary
         *        The new value for the StatusSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummary(EnablementStatusSummary statusSummary);

        /**
         * Sets the value of the StatusSummary property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EnablementStatusSummary.Builder} avoiding
         * the need to create one manually via {@link EnablementStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnablementStatusSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #statusSummary(EnablementStatusSummary)}.
         * 
         * @param statusSummary
         *        a consumer that will call methods on {@link EnablementStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusSummary(EnablementStatusSummary)
         */
        default Builder statusSummary(Consumer<EnablementStatusSummary.Builder> statusSummary) {
            return statusSummary(EnablementStatusSummary.builder().applyMutation(statusSummary).build());
        }

        /**
         * <p>
         * The target on which to enable the <code>Baseline</code>.
         * </p>
         * 
         * @param targetIdentifier
         *        The target on which to enable the <code>Baseline</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifier(String targetIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String baselineIdentifier;

        private String baselineVersion;

        private List<EnabledBaselineParameterSummary> parameters = DefaultSdkAutoConstructList.getInstance();

        private EnablementStatusSummary statusSummary;

        private String targetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledBaselineDetails model) {
            arn(model.arn);
            baselineIdentifier(model.baselineIdentifier);
            baselineVersion(model.baselineVersion);
            parameters(model.parameters);
            statusSummary(model.statusSummary);
            targetIdentifier(model.targetIdentifier);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBaselineIdentifier() {
            return baselineIdentifier;
        }

        public final void setBaselineIdentifier(String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
        }

        @Override
        public final Builder baselineIdentifier(String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
            return this;
        }

        public final String getBaselineVersion() {
            return baselineVersion;
        }

        public final void setBaselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
        }

        @Override
        public final Builder baselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
            return this;
        }

        public final List<EnabledBaselineParameterSummary.Builder> getParameters() {
            List<EnabledBaselineParameterSummary.Builder> result = EnabledBaselineParameterSummariesCopier
                    .copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<EnabledBaselineParameterSummary.BuilderImpl> parameters) {
            this.parameters = EnabledBaselineParameterSummariesCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<EnabledBaselineParameterSummary> parameters) {
            this.parameters = EnabledBaselineParameterSummariesCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(EnabledBaselineParameterSummary... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<EnabledBaselineParameterSummary.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> EnabledBaselineParameterSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final EnablementStatusSummary.Builder getStatusSummary() {
            return statusSummary != null ? statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(EnablementStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(EnablementStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final String getTargetIdentifier() {
            return targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        @Override
        public EnabledBaselineDetails build() {
            return new EnabledBaselineDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
