/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.LandingZoneDriftStatusSummary;
import software.amazon.awssdk.services.controltower.model.LandingZoneStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LandingZoneDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LandingZoneDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LandingZoneDetail.getter(LandingZoneDetail::arn)).setter(LandingZoneDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<LandingZoneDriftStatusSummary> DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("driftStatus").getter(LandingZoneDetail.getter(LandingZoneDetail::driftStatus)).setter(LandingZoneDetail.setter(Builder::driftStatus)).constructor(LandingZoneDriftStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatus").build()}).build();
    private static final SdkField<String> LATEST_AVAILABLE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestAvailableVersion").getter(LandingZoneDetail.getter(LandingZoneDetail::latestAvailableVersion)).setter(LandingZoneDetail.setter(Builder::latestAvailableVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAvailableVersion").build()}).build();
    private static final SdkField<Document> MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("manifest").getter(LandingZoneDetail.getter(LandingZoneDetail::manifest)).setter(LandingZoneDetail.setter(Builder::manifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifest").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LandingZoneDetail.getter(LandingZoneDetail::statusAsString)).setter(LandingZoneDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(LandingZoneDetail.getter(LandingZoneDetail::version)).setter(LandingZoneDetail.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DRIFT_STATUS_FIELD, LATEST_AVAILABLE_VERSION_FIELD, MANIFEST_FIELD, STATUS_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LandingZoneDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final LandingZoneDriftStatusSummary driftStatus;
    private final String latestAvailableVersion;
    private final Document manifest;
    private final String status;
    private final String version;

    private LandingZoneDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.driftStatus = builder.driftStatus;
        this.latestAvailableVersion = builder.latestAvailableVersion;
        this.manifest = builder.manifest;
        this.status = builder.status;
        this.version = builder.version;
    }

    public final String arn() {
        return this.arn;
    }

    public final LandingZoneDriftStatusSummary driftStatus() {
        return this.driftStatus;
    }

    public final String latestAvailableVersion() {
        return this.latestAvailableVersion;
    }

    public final Document manifest() {
        return this.manifest;
    }

    public final LandingZoneStatus status() {
        return LandingZoneStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAvailableVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LandingZoneDetail)) {
            return false;
        }
        LandingZoneDetail other = (LandingZoneDetail)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.driftStatus(), other.driftStatus()) && Objects.equals(this.latestAvailableVersion(), other.latestAvailableVersion()) && Objects.equals(this.manifest(), other.manifest()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"LandingZoneDetail").add("Arn", (Object)this.arn()).add("DriftStatus", (Object)this.driftStatus()).add("LatestAvailableVersion", (Object)this.latestAvailableVersion()).add("Manifest", (Object)this.manifest()).add("Status", (Object)this.statusAsString()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "driftStatus": {
                return Optional.ofNullable(clazz.cast(this.driftStatus()));
            }
            case "latestAvailableVersion": {
                return Optional.ofNullable(clazz.cast(this.latestAvailableVersion()));
            }
            case "manifest": {
                return Optional.ofNullable(clazz.cast(this.manifest()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("driftStatus", DRIFT_STATUS_FIELD);
        map.put("latestAvailableVersion", LATEST_AVAILABLE_VERSION_FIELD);
        map.put("manifest", MANIFEST_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LandingZoneDetail, T> g) {
        return obj -> g.apply((LandingZoneDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private LandingZoneDriftStatusSummary driftStatus;
        private String latestAvailableVersion;
        private Document manifest;
        private String status;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(LandingZoneDetail model) {
            this.arn(model.arn);
            this.driftStatus(model.driftStatus);
            this.latestAvailableVersion(model.latestAvailableVersion);
            this.manifest(model.manifest);
            this.status(model.status);
            this.version(model.version);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final LandingZoneDriftStatusSummary.Builder getDriftStatus() {
            return this.driftStatus != null ? this.driftStatus.toBuilder() : null;
        }

        public final void setDriftStatus(LandingZoneDriftStatusSummary.BuilderImpl driftStatus) {
            this.driftStatus = driftStatus != null ? driftStatus.build() : null;
        }

        @Override
        public final Builder driftStatus(LandingZoneDriftStatusSummary driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        public final String getLatestAvailableVersion() {
            return this.latestAvailableVersion;
        }

        public final void setLatestAvailableVersion(String latestAvailableVersion) {
            this.latestAvailableVersion = latestAvailableVersion;
        }

        @Override
        public final Builder latestAvailableVersion(String latestAvailableVersion) {
            this.latestAvailableVersion = latestAvailableVersion;
            return this;
        }

        public final Document getManifest() {
            return this.manifest;
        }

        public final void setManifest(Document manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(Document manifest) {
            this.manifest = manifest;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LandingZoneStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public LandingZoneDetail build() {
            return new LandingZoneDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LandingZoneDetail> {
        public Builder arn(String var1);

        public Builder driftStatus(LandingZoneDriftStatusSummary var1);

        default public Builder driftStatus(Consumer<LandingZoneDriftStatusSummary.Builder> driftStatus) {
            return this.driftStatus((LandingZoneDriftStatusSummary)((LandingZoneDriftStatusSummary.Builder)LandingZoneDriftStatusSummary.builder().applyMutation(driftStatus)).build());
        }

        public Builder latestAvailableVersion(String var1);

        public Builder manifest(Document var1);

        public Builder status(String var1);

        public Builder status(LandingZoneStatus var1);

        public Builder version(String var1);
    }
}

