/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter applied on the <code>ListEnabledBaseline</code> operation. Allowed filters are
 * <code>baselineIdentifiers</code> and <code>targetIdentifiers</code>. The filter can be applied for either, or both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledBaselineFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<EnabledBaselineFilter.Builder, EnabledBaselineFilter> {
    private static final SdkField<List<String>> BASELINE_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("baselineIdentifiers")
            .getter(getter(EnabledBaselineFilter::baselineIdentifiers))
            .setter(setter(Builder::baselineIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PARENT_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("parentIdentifiers")
            .getter(getter(EnabledBaselineFilter::parentIdentifiers))
            .setter(setter(Builder::parentIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targetIdentifiers")
            .getter(getter(EnabledBaselineFilter::targetIdentifiers))
            .setter(setter(Builder::targetIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_IDENTIFIERS_FIELD,
            PARENT_IDENTIFIERS_FIELD, TARGET_IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> baselineIdentifiers;

    private final List<String> parentIdentifiers;

    private final List<String> targetIdentifiers;

    private EnabledBaselineFilter(BuilderImpl builder) {
        this.baselineIdentifiers = builder.baselineIdentifiers;
        this.parentIdentifiers = builder.parentIdentifiers;
        this.targetIdentifiers = builder.targetIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the BaselineIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBaselineIdentifiers() {
        return baselineIdentifiers != null && !(baselineIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifiers for the <code>Baseline</code> objects returned as part of the filter operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBaselineIdentifiers} method.
     * </p>
     * 
     * @return Identifiers for the <code>Baseline</code> objects returned as part of the filter operation.
     */
    public final List<String> baselineIdentifiers() {
        return baselineIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParentIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParentIdentifiers() {
        return parentIdentifiers != null && !(parentIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional filter that sets up a list of <code>parentIdentifiers</code> to filter the results of the
     * <code>ListEnabledBaseline</code> output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParentIdentifiers} method.
     * </p>
     * 
     * @return An optional filter that sets up a list of <code>parentIdentifiers</code> to filter the results of the
     *         <code>ListEnabledBaseline</code> output.
     */
    public final List<String> parentIdentifiers() {
        return parentIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetIdentifiers() {
        return targetIdentifiers != null && !(targetIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifiers for the targets of the <code>Baseline</code> filter operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetIdentifiers} method.
     * </p>
     * 
     * @return Identifiers for the targets of the <code>Baseline</code> filter operation.
     */
    public final List<String> targetIdentifiers() {
        return targetIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBaselineIdentifiers() ? baselineIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParentIdentifiers() ? parentIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetIdentifiers() ? targetIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledBaselineFilter)) {
            return false;
        }
        EnabledBaselineFilter other = (EnabledBaselineFilter) obj;
        return hasBaselineIdentifiers() == other.hasBaselineIdentifiers()
                && Objects.equals(baselineIdentifiers(), other.baselineIdentifiers())
                && hasParentIdentifiers() == other.hasParentIdentifiers()
                && Objects.equals(parentIdentifiers(), other.parentIdentifiers())
                && hasTargetIdentifiers() == other.hasTargetIdentifiers()
                && Objects.equals(targetIdentifiers(), other.targetIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnabledBaselineFilter")
                .add("BaselineIdentifiers", hasBaselineIdentifiers() ? baselineIdentifiers() : null)
                .add("ParentIdentifiers", hasParentIdentifiers() ? parentIdentifiers() : null)
                .add("TargetIdentifiers", hasTargetIdentifiers() ? targetIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baselineIdentifiers":
            return Optional.ofNullable(clazz.cast(baselineIdentifiers()));
        case "parentIdentifiers":
            return Optional.ofNullable(clazz.cast(parentIdentifiers()));
        case "targetIdentifiers":
            return Optional.ofNullable(clazz.cast(targetIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("baselineIdentifiers", BASELINE_IDENTIFIERS_FIELD);
        map.put("parentIdentifiers", PARENT_IDENTIFIERS_FIELD);
        map.put("targetIdentifiers", TARGET_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnabledBaselineFilter, T> g) {
        return obj -> g.apply((EnabledBaselineFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnabledBaselineFilter> {
        /**
         * <p>
         * Identifiers for the <code>Baseline</code> objects returned as part of the filter operation.
         * </p>
         * 
         * @param baselineIdentifiers
         *        Identifiers for the <code>Baseline</code> objects returned as part of the filter operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentifiers(Collection<String> baselineIdentifiers);

        /**
         * <p>
         * Identifiers for the <code>Baseline</code> objects returned as part of the filter operation.
         * </p>
         * 
         * @param baselineIdentifiers
         *        Identifiers for the <code>Baseline</code> objects returned as part of the filter operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentifiers(String... baselineIdentifiers);

        /**
         * <p>
         * An optional filter that sets up a list of <code>parentIdentifiers</code> to filter the results of the
         * <code>ListEnabledBaseline</code> output.
         * </p>
         * 
         * @param parentIdentifiers
         *        An optional filter that sets up a list of <code>parentIdentifiers</code> to filter the results of the
         *        <code>ListEnabledBaseline</code> output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIdentifiers(Collection<String> parentIdentifiers);

        /**
         * <p>
         * An optional filter that sets up a list of <code>parentIdentifiers</code> to filter the results of the
         * <code>ListEnabledBaseline</code> output.
         * </p>
         * 
         * @param parentIdentifiers
         *        An optional filter that sets up a list of <code>parentIdentifiers</code> to filter the results of the
         *        <code>ListEnabledBaseline</code> output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIdentifiers(String... parentIdentifiers);

        /**
         * <p>
         * Identifiers for the targets of the <code>Baseline</code> filter operation.
         * </p>
         * 
         * @param targetIdentifiers
         *        Identifiers for the targets of the <code>Baseline</code> filter operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifiers(Collection<String> targetIdentifiers);

        /**
         * <p>
         * Identifiers for the targets of the <code>Baseline</code> filter operation.
         * </p>
         * 
         * @param targetIdentifiers
         *        Identifiers for the targets of the <code>Baseline</code> filter operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifiers(String... targetIdentifiers);
    }

    static final class BuilderImpl implements Builder {
        private List<String> baselineIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> parentIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledBaselineFilter model) {
            baselineIdentifiers(model.baselineIdentifiers);
            parentIdentifiers(model.parentIdentifiers);
            targetIdentifiers(model.targetIdentifiers);
        }

        public final Collection<String> getBaselineIdentifiers() {
            if (baselineIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return baselineIdentifiers;
        }

        public final void setBaselineIdentifiers(Collection<String> baselineIdentifiers) {
            this.baselineIdentifiers = EnabledBaselineBaselineIdentifiersCopier.copy(baselineIdentifiers);
        }

        @Override
        public final Builder baselineIdentifiers(Collection<String> baselineIdentifiers) {
            this.baselineIdentifiers = EnabledBaselineBaselineIdentifiersCopier.copy(baselineIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentifiers(String... baselineIdentifiers) {
            baselineIdentifiers(Arrays.asList(baselineIdentifiers));
            return this;
        }

        public final Collection<String> getParentIdentifiers() {
            if (parentIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return parentIdentifiers;
        }

        public final void setParentIdentifiers(Collection<String> parentIdentifiers) {
            this.parentIdentifiers = EnabledBaselineParentIdentifiersCopier.copy(parentIdentifiers);
        }

        @Override
        public final Builder parentIdentifiers(Collection<String> parentIdentifiers) {
            this.parentIdentifiers = EnabledBaselineParentIdentifiersCopier.copy(parentIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentIdentifiers(String... parentIdentifiers) {
            parentIdentifiers(Arrays.asList(parentIdentifiers));
            return this;
        }

        public final Collection<String> getTargetIdentifiers() {
            if (targetIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return targetIdentifiers;
        }

        public final void setTargetIdentifiers(Collection<String> targetIdentifiers) {
            this.targetIdentifiers = EnabledBaselineTargetIdentifiersCopier.copy(targetIdentifiers);
        }

        @Override
        public final Builder targetIdentifiers(Collection<String> targetIdentifiers) {
            this.targetIdentifiers = EnabledBaselineTargetIdentifiersCopier.copy(targetIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIdentifiers(String... targetIdentifiers) {
            targetIdentifiers(Arrays.asList(targetIdentifiers));
            return this;
        }

        @Override
        public EnabledBaselineFilter build() {
            return new EnabledBaselineFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
