/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the enabled control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledControlDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EnabledControlDetails.Builder, EnabledControlDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EnabledControlDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONTROL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlIdentifier").getter(getter(EnabledControlDetails::controlIdentifier))
            .setter(setter(Builder::controlIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifier").build()).build();

    private static final SdkField<DriftStatusSummary> DRIFT_STATUS_SUMMARY_FIELD = SdkField
            .<DriftStatusSummary> builder(MarshallingType.SDK_POJO).memberName("driftStatusSummary")
            .getter(getter(EnabledControlDetails::driftStatusSummary)).setter(setter(Builder::driftStatusSummary))
            .constructor(DriftStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatusSummary").build())
            .build();

    private static final SdkField<List<EnabledControlParameterSummary>> PARAMETERS_FIELD = SdkField
            .<List<EnabledControlParameterSummary>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(EnabledControlDetails::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnabledControlParameterSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnabledControlParameterSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EnablementStatusSummary> STATUS_SUMMARY_FIELD = SdkField
            .<EnablementStatusSummary> builder(MarshallingType.SDK_POJO).memberName("statusSummary")
            .getter(getter(EnabledControlDetails::statusSummary)).setter(setter(Builder::statusSummary))
            .constructor(EnablementStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()).build();

    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetIdentifier").getter(getter(EnabledControlDetails::targetIdentifier))
            .setter(setter(Builder::targetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()).build();

    private static final SdkField<List<Region>> TARGET_REGIONS_FIELD = SdkField
            .<List<Region>> builder(MarshallingType.LIST)
            .memberName("targetRegions")
            .getter(getter(EnabledControlDetails::targetRegions))
            .setter(setter(Builder::targetRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Region> builder(MarshallingType.SDK_POJO)
                                            .constructor(Region::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONTROL_IDENTIFIER_FIELD, DRIFT_STATUS_SUMMARY_FIELD, PARAMETERS_FIELD, STATUS_SUMMARY_FIELD,
            TARGET_IDENTIFIER_FIELD, TARGET_REGIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String controlIdentifier;

    private final DriftStatusSummary driftStatusSummary;

    private final List<EnabledControlParameterSummary> parameters;

    private final EnablementStatusSummary statusSummary;

    private final String targetIdentifier;

    private final List<Region> targetRegions;

    private EnabledControlDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.controlIdentifier = builder.controlIdentifier;
        this.driftStatusSummary = builder.driftStatusSummary;
        this.parameters = builder.parameters;
        this.statusSummary = builder.statusSummary;
        this.targetIdentifier = builder.targetIdentifier;
        this.targetRegions = builder.targetRegions;
    }

    /**
     * <p>
     * The ARN of the enabled control.
     * </p>
     * 
     * @return The ARN of the enabled control.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The control identifier of the enabled control. For information on how to find the <code>controlIdentifier</code>,
     * see <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
     * </p>
     * 
     * @return The control identifier of the enabled control. For information on how to find the
     *         <code>controlIdentifier</code>, see <a
     *         href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
     */
    public final String controlIdentifier() {
        return controlIdentifier;
    }

    /**
     * <p>
     * The drift status of the enabled control.
     * </p>
     * 
     * @return The drift status of the enabled control.
     */
    public final DriftStatusSummary driftStatusSummary() {
        return driftStatusSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of <code>EnabledControlParameter</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Array of <code>EnabledControlParameter</code> objects.
     */
    public final List<EnabledControlParameterSummary> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The deployment summary of the enabled control.
     * </p>
     * 
     * @return The deployment summary of the enabled control.
     */
    public final EnablementStatusSummary statusSummary() {
        return statusSummary;
    }

    /**
     * <p>
     * The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
     * </p>
     * 
     * @return The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see
     *         <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
     *         page</a>.
     */
    public final String targetIdentifier() {
        return targetIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetRegions() {
        return targetRegions != null && !(targetRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Target Amazon Web Services Regions for the enabled control.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetRegions} method.
     * </p>
     * 
     * @return Target Amazon Web Services Regions for the enabled control.
     */
    public final List<Region> targetRegions() {
        return targetRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(controlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(driftStatusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(targetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetRegions() ? targetRegions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledControlDetails)) {
            return false;
        }
        EnabledControlDetails other = (EnabledControlDetails) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(controlIdentifier(), other.controlIdentifier())
                && Objects.equals(driftStatusSummary(), other.driftStatusSummary()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(statusSummary(), other.statusSummary())
                && Objects.equals(targetIdentifier(), other.targetIdentifier()) && hasTargetRegions() == other.hasTargetRegions()
                && Objects.equals(targetRegions(), other.targetRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnabledControlDetails").add("Arn", arn()).add("ControlIdentifier", controlIdentifier())
                .add("DriftStatusSummary", driftStatusSummary()).add("Parameters", hasParameters() ? parameters() : null)
                .add("StatusSummary", statusSummary()).add("TargetIdentifier", targetIdentifier())
                .add("TargetRegions", hasTargetRegions() ? targetRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "controlIdentifier":
            return Optional.ofNullable(clazz.cast(controlIdentifier()));
        case "driftStatusSummary":
            return Optional.ofNullable(clazz.cast(driftStatusSummary()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "statusSummary":
            return Optional.ofNullable(clazz.cast(statusSummary()));
        case "targetIdentifier":
            return Optional.ofNullable(clazz.cast(targetIdentifier()));
        case "targetRegions":
            return Optional.ofNullable(clazz.cast(targetRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("controlIdentifier", CONTROL_IDENTIFIER_FIELD);
        map.put("driftStatusSummary", DRIFT_STATUS_SUMMARY_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("statusSummary", STATUS_SUMMARY_FIELD);
        map.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        map.put("targetRegions", TARGET_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnabledControlDetails, T> g) {
        return obj -> g.apply((EnabledControlDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnabledControlDetails> {
        /**
         * <p>
         * The ARN of the enabled control.
         * </p>
         * 
         * @param arn
         *        The ARN of the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The control identifier of the enabled control. For information on how to find the
         * <code>controlIdentifier</code>, see <a
         * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
         * </p>
         * 
         * @param controlIdentifier
         *        The control identifier of the enabled control. For information on how to find the
         *        <code>controlIdentifier</code>, see <a
         *        href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
         *        page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlIdentifier(String controlIdentifier);

        /**
         * <p>
         * The drift status of the enabled control.
         * </p>
         * 
         * @param driftStatusSummary
         *        The drift status of the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftStatusSummary(DriftStatusSummary driftStatusSummary);

        /**
         * <p>
         * The drift status of the enabled control.
         * </p>
         * This is a convenience method that creates an instance of the {@link DriftStatusSummary.Builder} avoiding the
         * need to create one manually via {@link DriftStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DriftStatusSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #driftStatusSummary(DriftStatusSummary)}.
         * 
         * @param driftStatusSummary
         *        a consumer that will call methods on {@link DriftStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driftStatusSummary(DriftStatusSummary)
         */
        default Builder driftStatusSummary(Consumer<DriftStatusSummary.Builder> driftStatusSummary) {
            return driftStatusSummary(DriftStatusSummary.builder().applyMutation(driftStatusSummary).build());
        }

        /**
         * <p>
         * Array of <code>EnabledControlParameter</code> objects.
         * </p>
         * 
         * @param parameters
         *        Array of <code>EnabledControlParameter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<EnabledControlParameterSummary> parameters);

        /**
         * <p>
         * Array of <code>EnabledControlParameter</code> objects.
         * </p>
         * 
         * @param parameters
         *        Array of <code>EnabledControlParameter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(EnabledControlParameterSummary... parameters);

        /**
         * <p>
         * Array of <code>EnabledControlParameter</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.controltower.model.EnabledControlParameterSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.controltower.model.EnabledControlParameterSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.controltower.model.EnabledControlParameterSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #parameters(List<EnabledControlParameterSummary>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.controltower.model.EnabledControlParameterSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<EnabledControlParameterSummary>)
         */
        Builder parameters(Consumer<EnabledControlParameterSummary.Builder>... parameters);

        /**
         * <p>
         * The deployment summary of the enabled control.
         * </p>
         * 
         * @param statusSummary
         *        The deployment summary of the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummary(EnablementStatusSummary statusSummary);

        /**
         * <p>
         * The deployment summary of the enabled control.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnablementStatusSummary.Builder} avoiding
         * the need to create one manually via {@link EnablementStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnablementStatusSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #statusSummary(EnablementStatusSummary)}.
         * 
         * @param statusSummary
         *        a consumer that will call methods on {@link EnablementStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusSummary(EnablementStatusSummary)
         */
        default Builder statusSummary(Consumer<EnablementStatusSummary.Builder> statusSummary) {
            return statusSummary(EnablementStatusSummary.builder().applyMutation(statusSummary).build());
        }

        /**
         * <p>
         * The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see <a
         * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
         * </p>
         * 
         * @param targetIdentifier
         *        The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>,
         *        see <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
         *        page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifier(String targetIdentifier);

        /**
         * <p>
         * Target Amazon Web Services Regions for the enabled control.
         * </p>
         * 
         * @param targetRegions
         *        Target Amazon Web Services Regions for the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRegions(Collection<Region> targetRegions);

        /**
         * <p>
         * Target Amazon Web Services Regions for the enabled control.
         * </p>
         * 
         * @param targetRegions
         *        Target Amazon Web Services Regions for the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRegions(Region... targetRegions);

        /**
         * <p>
         * Target Amazon Web Services Regions for the enabled control.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.controltower.model.Region.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.controltower.model.Region#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.controltower.model.Region.Builder#build()} is called immediately and
         * its result is passed to {@link #targetRegions(List<Region>)}.
         * 
         * @param targetRegions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.controltower.model.Region.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetRegions(java.util.Collection<Region>)
         */
        Builder targetRegions(Consumer<Region.Builder>... targetRegions);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String controlIdentifier;

        private DriftStatusSummary driftStatusSummary;

        private List<EnabledControlParameterSummary> parameters = DefaultSdkAutoConstructList.getInstance();

        private EnablementStatusSummary statusSummary;

        private String targetIdentifier;

        private List<Region> targetRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledControlDetails model) {
            arn(model.arn);
            controlIdentifier(model.controlIdentifier);
            driftStatusSummary(model.driftStatusSummary);
            parameters(model.parameters);
            statusSummary(model.statusSummary);
            targetIdentifier(model.targetIdentifier);
            targetRegions(model.targetRegions);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getControlIdentifier() {
            return controlIdentifier;
        }

        public final void setControlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
        }

        @Override
        public final Builder controlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
            return this;
        }

        public final DriftStatusSummary.Builder getDriftStatusSummary() {
            return driftStatusSummary != null ? driftStatusSummary.toBuilder() : null;
        }

        public final void setDriftStatusSummary(DriftStatusSummary.BuilderImpl driftStatusSummary) {
            this.driftStatusSummary = driftStatusSummary != null ? driftStatusSummary.build() : null;
        }

        @Override
        public final Builder driftStatusSummary(DriftStatusSummary driftStatusSummary) {
            this.driftStatusSummary = driftStatusSummary;
            return this;
        }

        public final List<EnabledControlParameterSummary.Builder> getParameters() {
            List<EnabledControlParameterSummary.Builder> result = EnabledControlParameterSummariesCopier
                    .copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<EnabledControlParameterSummary.BuilderImpl> parameters) {
            this.parameters = EnabledControlParameterSummariesCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<EnabledControlParameterSummary> parameters) {
            this.parameters = EnabledControlParameterSummariesCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(EnabledControlParameterSummary... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<EnabledControlParameterSummary.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> EnabledControlParameterSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final EnablementStatusSummary.Builder getStatusSummary() {
            return statusSummary != null ? statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(EnablementStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(EnablementStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final String getTargetIdentifier() {
            return targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public final List<Region.Builder> getTargetRegions() {
            List<Region.Builder> result = TargetRegionsCopier.copyToBuilder(this.targetRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetRegions(Collection<Region.BuilderImpl> targetRegions) {
            this.targetRegions = TargetRegionsCopier.copyFromBuilder(targetRegions);
        }

        @Override
        public final Builder targetRegions(Collection<Region> targetRegions) {
            this.targetRegions = TargetRegionsCopier.copy(targetRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetRegions(Region... targetRegions) {
            targetRegions(Arrays.asList(targetRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetRegions(Consumer<Region.Builder>... targetRegions) {
            targetRegions(Stream.of(targetRegions).map(c -> Region.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EnabledControlDetails build() {
            return new EnabledControlDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
