/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that returns a set of control identifiers, the control status for each control in the set, and the drift
 * status for each control in the set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledControlFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<EnabledControlFilter.Builder, EnabledControlFilter> {
    private static final SdkField<List<String>> CONTROL_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("controlIdentifiers")
            .getter(getter(EnabledControlFilter::controlIdentifiers))
            .setter(setter(Builder::controlIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DRIFT_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("driftStatuses")
            .getter(getter(EnabledControlFilter::driftStatusesAsStrings))
            .setter(setter(Builder::driftStatusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statuses")
            .getter(getter(EnabledControlFilter::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_IDENTIFIERS_FIELD,
            DRIFT_STATUSES_FIELD, STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> controlIdentifiers;

    private final List<String> driftStatuses;

    private final List<String> statuses;

    private EnabledControlFilter(BuilderImpl builder) {
        this.controlIdentifiers = builder.controlIdentifiers;
        this.driftStatuses = builder.driftStatuses;
        this.statuses = builder.statuses;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasControlIdentifiers() {
        return controlIdentifiers != null && !(controlIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of <code>controlIdentifier</code> returned by the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlIdentifiers} method.
     * </p>
     * 
     * @return The set of <code>controlIdentifier</code> returned by the filter.
     */
    public final List<String> controlIdentifiers() {
        return controlIdentifiers;
    }

    /**
     * <p>
     * A list of <code>DriftStatus</code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDriftStatuses} method.
     * </p>
     * 
     * @return A list of <code>DriftStatus</code> items.
     */
    public final List<DriftStatus> driftStatuses() {
        return DriftStatusesCopier.copyStringToEnum(driftStatuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the DriftStatuses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDriftStatuses() {
        return driftStatuses != null && !(driftStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DriftStatus</code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDriftStatuses} method.
     * </p>
     * 
     * @return A list of <code>DriftStatus</code> items.
     */
    public final List<String> driftStatusesAsStrings() {
        return driftStatuses;
    }

    /**
     * <p>
     * A list of <code>EnablementStatus</code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return A list of <code>EnablementStatus</code> items.
     */
    public final List<EnablementStatus> statuses() {
        return EnablementStatusesCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>EnablementStatus</code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return A list of <code>EnablementStatus</code> items.
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasControlIdentifiers() ? controlIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDriftStatuses() ? driftStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledControlFilter)) {
            return false;
        }
        EnabledControlFilter other = (EnabledControlFilter) obj;
        return hasControlIdentifiers() == other.hasControlIdentifiers()
                && Objects.equals(controlIdentifiers(), other.controlIdentifiers())
                && hasDriftStatuses() == other.hasDriftStatuses()
                && Objects.equals(driftStatusesAsStrings(), other.driftStatusesAsStrings())
                && hasStatuses() == other.hasStatuses() && Objects.equals(statusesAsStrings(), other.statusesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnabledControlFilter")
                .add("ControlIdentifiers", hasControlIdentifiers() ? controlIdentifiers() : null)
                .add("DriftStatuses", hasDriftStatuses() ? driftStatusesAsStrings() : null)
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlIdentifiers":
            return Optional.ofNullable(clazz.cast(controlIdentifiers()));
        case "driftStatuses":
            return Optional.ofNullable(clazz.cast(driftStatusesAsStrings()));
        case "statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("controlIdentifiers", CONTROL_IDENTIFIERS_FIELD);
        map.put("driftStatuses", DRIFT_STATUSES_FIELD);
        map.put("statuses", STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnabledControlFilter, T> g) {
        return obj -> g.apply((EnabledControlFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnabledControlFilter> {
        /**
         * <p>
         * The set of <code>controlIdentifier</code> returned by the filter.
         * </p>
         * 
         * @param controlIdentifiers
         *        The set of <code>controlIdentifier</code> returned by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlIdentifiers(Collection<String> controlIdentifiers);

        /**
         * <p>
         * The set of <code>controlIdentifier</code> returned by the filter.
         * </p>
         * 
         * @param controlIdentifiers
         *        The set of <code>controlIdentifier</code> returned by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlIdentifiers(String... controlIdentifiers);

        /**
         * <p>
         * A list of <code>DriftStatus</code> items.
         * </p>
         * 
         * @param driftStatuses
         *        A list of <code>DriftStatus</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftStatusesWithStrings(Collection<String> driftStatuses);

        /**
         * <p>
         * A list of <code>DriftStatus</code> items.
         * </p>
         * 
         * @param driftStatuses
         *        A list of <code>DriftStatus</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftStatusesWithStrings(String... driftStatuses);

        /**
         * <p>
         * A list of <code>DriftStatus</code> items.
         * </p>
         * 
         * @param driftStatuses
         *        A list of <code>DriftStatus</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftStatuses(Collection<DriftStatus> driftStatuses);

        /**
         * <p>
         * A list of <code>DriftStatus</code> items.
         * </p>
         * 
         * @param driftStatuses
         *        A list of <code>DriftStatus</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftStatuses(DriftStatus... driftStatuses);

        /**
         * <p>
         * A list of <code>EnablementStatus</code> items.
         * </p>
         * 
         * @param statuses
         *        A list of <code>EnablementStatus</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * A list of <code>EnablementStatus</code> items.
         * </p>
         * 
         * @param statuses
         *        A list of <code>EnablementStatus</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * A list of <code>EnablementStatus</code> items.
         * </p>
         * 
         * @param statuses
         *        A list of <code>EnablementStatus</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<EnablementStatus> statuses);

        /**
         * <p>
         * A list of <code>EnablementStatus</code> items.
         * </p>
         * 
         * @param statuses
         *        A list of <code>EnablementStatus</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(EnablementStatus... statuses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> controlIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> driftStatuses = DefaultSdkAutoConstructList.getInstance();

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledControlFilter model) {
            controlIdentifiers(model.controlIdentifiers);
            driftStatusesWithStrings(model.driftStatuses);
            statusesWithStrings(model.statuses);
        }

        public final Collection<String> getControlIdentifiers() {
            if (controlIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return controlIdentifiers;
        }

        public final void setControlIdentifiers(Collection<String> controlIdentifiers) {
            this.controlIdentifiers = ControlIdentifiersCopier.copy(controlIdentifiers);
        }

        @Override
        public final Builder controlIdentifiers(Collection<String> controlIdentifiers) {
            this.controlIdentifiers = ControlIdentifiersCopier.copy(controlIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlIdentifiers(String... controlIdentifiers) {
            controlIdentifiers(Arrays.asList(controlIdentifiers));
            return this;
        }

        public final Collection<String> getDriftStatuses() {
            if (driftStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return driftStatuses;
        }

        public final void setDriftStatuses(Collection<String> driftStatuses) {
            this.driftStatuses = DriftStatusesCopier.copy(driftStatuses);
        }

        @Override
        public final Builder driftStatusesWithStrings(Collection<String> driftStatuses) {
            this.driftStatuses = DriftStatusesCopier.copy(driftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder driftStatusesWithStrings(String... driftStatuses) {
            driftStatusesWithStrings(Arrays.asList(driftStatuses));
            return this;
        }

        @Override
        public final Builder driftStatuses(Collection<DriftStatus> driftStatuses) {
            this.driftStatuses = DriftStatusesCopier.copyEnumToString(driftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder driftStatuses(DriftStatus... driftStatuses) {
            driftStatuses(Arrays.asList(driftStatuses));
            return this;
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = EnablementStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = EnablementStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<EnablementStatus> statuses) {
            this.statuses = EnablementStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(EnablementStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        public EnabledControlFilter build() {
            return new EnabledControlFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
