/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBaselineOperationResponse extends ControlTowerResponse implements
        ToCopyableBuilder<GetBaselineOperationResponse.Builder, GetBaselineOperationResponse> {
    private static final SdkField<BaselineOperation> BASELINE_OPERATION_FIELD = SdkField
            .<BaselineOperation> builder(MarshallingType.SDK_POJO).memberName("baselineOperation")
            .getter(getter(GetBaselineOperationResponse::baselineOperation)).setter(setter(Builder::baselineOperation))
            .constructor(BaselineOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineOperation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final BaselineOperation baselineOperation;

    private GetBaselineOperationResponse(BuilderImpl builder) {
        super(builder);
        this.baselineOperation = builder.baselineOperation;
    }

    /**
     * <p>
     * A <code>baselineOperation</code> object that shows information about the specified operation ID.
     * </p>
     * 
     * @return A <code>baselineOperation</code> object that shows information about the specified operation ID.
     */
    public final BaselineOperation baselineOperation() {
        return baselineOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baselineOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBaselineOperationResponse)) {
            return false;
        }
        GetBaselineOperationResponse other = (GetBaselineOperationResponse) obj;
        return Objects.equals(baselineOperation(), other.baselineOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBaselineOperationResponse").add("BaselineOperation", baselineOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baselineOperation":
            return Optional.ofNullable(clazz.cast(baselineOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("baselineOperation", BASELINE_OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBaselineOperationResponse, T> g) {
        return obj -> g.apply((GetBaselineOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBaselineOperationResponse> {
        /**
         * <p>
         * A <code>baselineOperation</code> object that shows information about the specified operation ID.
         * </p>
         * 
         * @param baselineOperation
         *        A <code>baselineOperation</code> object that shows information about the specified operation ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineOperation(BaselineOperation baselineOperation);

        /**
         * <p>
         * A <code>baselineOperation</code> object that shows information about the specified operation ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link BaselineOperation.Builder} avoiding the
         * need to create one manually via {@link BaselineOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BaselineOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #baselineOperation(BaselineOperation)}.
         * 
         * @param baselineOperation
         *        a consumer that will call methods on {@link BaselineOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baselineOperation(BaselineOperation)
         */
        default Builder baselineOperation(Consumer<BaselineOperation.Builder> baselineOperation) {
            return baselineOperation(BaselineOperation.builder().applyMutation(baselineOperation).build());
        }
    }

    static final class BuilderImpl extends ControlTowerResponse.BuilderImpl implements Builder {
        private BaselineOperation baselineOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBaselineOperationResponse model) {
            super(model);
            baselineOperation(model.baselineOperation);
        }

        public final BaselineOperation.Builder getBaselineOperation() {
            return baselineOperation != null ? baselineOperation.toBuilder() : null;
        }

        public final void setBaselineOperation(BaselineOperation.BuilderImpl baselineOperation) {
            this.baselineOperation = baselineOperation != null ? baselineOperation.build() : null;
        }

        @Override
        public final Builder baselineOperation(BaselineOperation baselineOperation) {
            this.baselineOperation = baselineOperation;
            return this;
        }

        @Override
        public GetBaselineOperationResponse build() {
            return new GetBaselineOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
