/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnabledControlResponse extends ControlTowerResponse implements
        ToCopyableBuilder<GetEnabledControlResponse.Builder, GetEnabledControlResponse> {
    private static final SdkField<EnabledControlDetails> ENABLED_CONTROL_DETAILS_FIELD = SdkField
            .<EnabledControlDetails> builder(MarshallingType.SDK_POJO).memberName("enabledControlDetails")
            .getter(getter(GetEnabledControlResponse::enabledControlDetails)).setter(setter(Builder::enabledControlDetails))
            .constructor(EnabledControlDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledControlDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ENABLED_CONTROL_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EnabledControlDetails enabledControlDetails;

    private GetEnabledControlResponse(BuilderImpl builder) {
        super(builder);
        this.enabledControlDetails = builder.enabledControlDetails;
    }

    /**
     * <p>
     * Information about the enabled control.
     * </p>
     * 
     * @return Information about the enabled control.
     */
    public final EnabledControlDetails enabledControlDetails() {
        return enabledControlDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enabledControlDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnabledControlResponse)) {
            return false;
        }
        GetEnabledControlResponse other = (GetEnabledControlResponse) obj;
        return Objects.equals(enabledControlDetails(), other.enabledControlDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnabledControlResponse").add("EnabledControlDetails", enabledControlDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabledControlDetails":
            return Optional.ofNullable(clazz.cast(enabledControlDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabledControlDetails", ENABLED_CONTROL_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEnabledControlResponse, T> g) {
        return obj -> g.apply((GetEnabledControlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEnabledControlResponse> {
        /**
         * <p>
         * Information about the enabled control.
         * </p>
         * 
         * @param enabledControlDetails
         *        Information about the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledControlDetails(EnabledControlDetails enabledControlDetails);

        /**
         * <p>
         * Information about the enabled control.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnabledControlDetails.Builder} avoiding
         * the need to create one manually via {@link EnabledControlDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnabledControlDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #enabledControlDetails(EnabledControlDetails)}.
         * 
         * @param enabledControlDetails
         *        a consumer that will call methods on {@link EnabledControlDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enabledControlDetails(EnabledControlDetails)
         */
        default Builder enabledControlDetails(Consumer<EnabledControlDetails.Builder> enabledControlDetails) {
            return enabledControlDetails(EnabledControlDetails.builder().applyMutation(enabledControlDetails).build());
        }
    }

    static final class BuilderImpl extends ControlTowerResponse.BuilderImpl implements Builder {
        private EnabledControlDetails enabledControlDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnabledControlResponse model) {
            super(model);
            enabledControlDetails(model.enabledControlDetails);
        }

        public final EnabledControlDetails.Builder getEnabledControlDetails() {
            return enabledControlDetails != null ? enabledControlDetails.toBuilder() : null;
        }

        public final void setEnabledControlDetails(EnabledControlDetails.BuilderImpl enabledControlDetails) {
            this.enabledControlDetails = enabledControlDetails != null ? enabledControlDetails.build() : null;
        }

        @Override
        public final Builder enabledControlDetails(EnabledControlDetails enabledControlDetails) {
            this.enabledControlDetails = enabledControlDetails;
            return this;
        }

        @Override
        public GetEnabledControlResponse build() {
            return new GetEnabledControlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
