/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns a summary of information about a landing zone operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LandingZoneOperationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LandingZoneOperationSummary.Builder, LandingZoneOperationSummary> {
    private static final SdkField<String> OPERATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationIdentifier").getter(getter(LandingZoneOperationSummary::operationIdentifier))
            .setter(setter(Builder::operationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationIdentifier").build())
            .build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationType").getter(getter(LandingZoneOperationSummary::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(LandingZoneOperationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_IDENTIFIER_FIELD,
            OPERATION_TYPE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String operationIdentifier;

    private final String operationType;

    private final String status;

    private LandingZoneOperationSummary(BuilderImpl builder) {
        this.operationIdentifier = builder.operationIdentifier;
        this.operationType = builder.operationType;
        this.status = builder.status;
    }

    /**
     * <p>
     * The <code>operationIdentifier</code> of the landing zone operation.
     * </p>
     * 
     * @return The <code>operationIdentifier</code> of the landing zone operation.
     */
    public final String operationIdentifier() {
        return operationIdentifier;
    }

    /**
     * <p>
     * The type of the landing zone operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link LandingZoneOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The type of the landing zone operation.
     * @see LandingZoneOperationType
     */
    public final LandingZoneOperationType operationType() {
        return LandingZoneOperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The type of the landing zone operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link LandingZoneOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The type of the landing zone operation.
     * @see LandingZoneOperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The status of the landing zone operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LandingZoneOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the landing zone operation.
     * @see LandingZoneOperationStatus
     */
    public final LandingZoneOperationStatus status() {
        return LandingZoneOperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the landing zone operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LandingZoneOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the landing zone operation.
     * @see LandingZoneOperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LandingZoneOperationSummary)) {
            return false;
        }
        LandingZoneOperationSummary other = (LandingZoneOperationSummary) obj;
        return Objects.equals(operationIdentifier(), other.operationIdentifier())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LandingZoneOperationSummary").add("OperationIdentifier", operationIdentifier())
                .add("OperationType", operationTypeAsString()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operationIdentifier":
            return Optional.ofNullable(clazz.cast(operationIdentifier()));
        case "operationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("operationIdentifier", OPERATION_IDENTIFIER_FIELD);
        map.put("operationType", OPERATION_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LandingZoneOperationSummary, T> g) {
        return obj -> g.apply((LandingZoneOperationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LandingZoneOperationSummary> {
        /**
         * <p>
         * The <code>operationIdentifier</code> of the landing zone operation.
         * </p>
         * 
         * @param operationIdentifier
         *        The <code>operationIdentifier</code> of the landing zone operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationIdentifier(String operationIdentifier);

        /**
         * <p>
         * The type of the landing zone operation.
         * </p>
         * 
         * @param operationType
         *        The type of the landing zone operation.
         * @see LandingZoneOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneOperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The type of the landing zone operation.
         * </p>
         * 
         * @param operationType
         *        The type of the landing zone operation.
         * @see LandingZoneOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneOperationType
         */
        Builder operationType(LandingZoneOperationType operationType);

        /**
         * <p>
         * The status of the landing zone operation.
         * </p>
         * 
         * @param status
         *        The status of the landing zone operation.
         * @see LandingZoneOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneOperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the landing zone operation.
         * </p>
         * 
         * @param status
         *        The status of the landing zone operation.
         * @see LandingZoneOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneOperationStatus
         */
        Builder status(LandingZoneOperationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String operationIdentifier;

        private String operationType;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LandingZoneOperationSummary model) {
            operationIdentifier(model.operationIdentifier);
            operationType(model.operationType);
            status(model.status);
        }

        public final String getOperationIdentifier() {
            return operationIdentifier;
        }

        public final void setOperationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
        }

        @Override
        public final Builder operationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
            return this;
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(LandingZoneOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LandingZoneOperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public LandingZoneOperationSummary build() {
            return new LandingZoneOperationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
