/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListControlOperationsRequest extends ControlTowerRequest implements
        ToCopyableBuilder<ListControlOperationsRequest.Builder, ListControlOperationsRequest> {
    private static final SdkField<ControlOperationFilter> FILTER_FIELD = SdkField
            .<ControlOperationFilter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListControlOperationsRequest::filter)).setter(setter(Builder::filter))
            .constructor(ControlOperationFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListControlOperationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListControlOperationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ControlOperationFilter filter;

    private final Integer maxResults;

    private final String nextToken;

    private ListControlOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An input filter for the <code>ListControlOperations</code> API that lets you select the types of control
     * operations to view.
     * </p>
     * 
     * @return An input filter for the <code>ListControlOperations</code> API that lets you select the types of control
     *         operations to view.
     */
    public final ControlOperationFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The maximum number of results to be shown.
     * </p>
     * 
     * @return The maximum number of results to be shown.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlOperationsRequest)) {
            return false;
        }
        ListControlOperationsRequest other = (ListControlOperationsRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListControlOperationsRequest").add("Filter", filter()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filter", FILTER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListControlOperationsRequest, T> g) {
        return obj -> g.apply((ListControlOperationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListControlOperationsRequest> {
        /**
         * <p>
         * An input filter for the <code>ListControlOperations</code> API that lets you select the types of control
         * operations to view.
         * </p>
         * 
         * @param filter
         *        An input filter for the <code>ListControlOperations</code> API that lets you select the types of
         *        control operations to view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ControlOperationFilter filter);

        /**
         * <p>
         * An input filter for the <code>ListControlOperations</code> API that lets you select the types of control
         * operations to view.
         * </p>
         * This is a convenience method that creates an instance of the {@link ControlOperationFilter.Builder} avoiding
         * the need to create one manually via {@link ControlOperationFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ControlOperationFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #filter(ControlOperationFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ControlOperationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ControlOperationFilter)
         */
        default Builder filter(Consumer<ControlOperationFilter.Builder> filter) {
            return filter(ControlOperationFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The maximum number of results to be shown.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be shown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private ControlOperationFilter filter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlOperationsRequest model) {
            super(model);
            filter(model.filter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final ControlOperationFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(ControlOperationFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ControlOperationFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListControlOperationsRequest build() {
            return new ListControlOperationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
