/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnabledBaselinesRequest extends ControlTowerRequest implements
        ToCopyableBuilder<ListEnabledBaselinesRequest.Builder, ListEnabledBaselinesRequest> {
    private static final SdkField<EnabledBaselineFilter> FILTER_FIELD = SdkField
            .<EnabledBaselineFilter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListEnabledBaselinesRequest::filter)).setter(setter(Builder::filter))
            .constructor(EnabledBaselineFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Boolean> INCLUDE_CHILDREN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeChildren").getter(getter(ListEnabledBaselinesRequest::includeChildren))
            .setter(setter(Builder::includeChildren))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeChildren").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEnabledBaselinesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnabledBaselinesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            INCLUDE_CHILDREN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EnabledBaselineFilter filter;

    private final Boolean includeChildren;

    private final Integer maxResults;

    private final String nextToken;

    private ListEnabledBaselinesRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.includeChildren = builder.includeChildren;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A filter applied on the <code>ListEnabledBaseline</code> operation. Allowed filters are
     * <code>baselineIdentifiers</code> and <code>targetIdentifiers</code>. The filter can be applied for either, or
     * both.
     * </p>
     * 
     * @return A filter applied on the <code>ListEnabledBaseline</code> operation. Allowed filters are
     *         <code>baselineIdentifiers</code> and <code>targetIdentifiers</code>. The filter can be applied for
     *         either, or both.
     */
    public final EnabledBaselineFilter filter() {
        return filter;
    }

    /**
     * <p>
     * A value that can be set to include the child enabled baselines in responses. The default value is false.
     * </p>
     * 
     * @return A value that can be set to include the child enabled baselines in responses. The default value is false.
     */
    public final Boolean includeChildren() {
        return includeChildren;
    }

    /**
     * <p>
     * The maximum number of results to be shown.
     * </p>
     * 
     * @return The maximum number of results to be shown.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(includeChildren());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnabledBaselinesRequest)) {
            return false;
        }
        ListEnabledBaselinesRequest other = (ListEnabledBaselinesRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(includeChildren(), other.includeChildren())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnabledBaselinesRequest").add("Filter", filter()).add("IncludeChildren", includeChildren())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "includeChildren":
            return Optional.ofNullable(clazz.cast(includeChildren()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filter", FILTER_FIELD);
        map.put("includeChildren", INCLUDE_CHILDREN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnabledBaselinesRequest, T> g) {
        return obj -> g.apply((ListEnabledBaselinesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEnabledBaselinesRequest> {
        /**
         * <p>
         * A filter applied on the <code>ListEnabledBaseline</code> operation. Allowed filters are
         * <code>baselineIdentifiers</code> and <code>targetIdentifiers</code>. The filter can be applied for either, or
         * both.
         * </p>
         * 
         * @param filter
         *        A filter applied on the <code>ListEnabledBaseline</code> operation. Allowed filters are
         *        <code>baselineIdentifiers</code> and <code>targetIdentifiers</code>. The filter can be applied for
         *        either, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(EnabledBaselineFilter filter);

        /**
         * <p>
         * A filter applied on the <code>ListEnabledBaseline</code> operation. Allowed filters are
         * <code>baselineIdentifiers</code> and <code>targetIdentifiers</code>. The filter can be applied for either, or
         * both.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnabledBaselineFilter.Builder} avoiding
         * the need to create one manually via {@link EnabledBaselineFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnabledBaselineFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #filter(EnabledBaselineFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link EnabledBaselineFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(EnabledBaselineFilter)
         */
        default Builder filter(Consumer<EnabledBaselineFilter.Builder> filter) {
            return filter(EnabledBaselineFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * A value that can be set to include the child enabled baselines in responses. The default value is false.
         * </p>
         * 
         * @param includeChildren
         *        A value that can be set to include the child enabled baselines in responses. The default value is
         *        false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeChildren(Boolean includeChildren);

        /**
         * <p>
         * The maximum number of results to be shown.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be shown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private EnabledBaselineFilter filter;

        private Boolean includeChildren;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnabledBaselinesRequest model) {
            super(model);
            filter(model.filter);
            includeChildren(model.includeChildren);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final EnabledBaselineFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(EnabledBaselineFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(EnabledBaselineFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Boolean getIncludeChildren() {
            return includeChildren;
        }

        public final void setIncludeChildren(Boolean includeChildren) {
            this.includeChildren = includeChildren;
        }

        @Override
        public final Builder includeChildren(Boolean includeChildren) {
            this.includeChildren = includeChildren;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnabledBaselinesRequest build() {
            return new ListEnabledBaselinesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
