/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLandingZoneOperationsRequest extends ControlTowerRequest implements
        ToCopyableBuilder<ListLandingZoneOperationsRequest.Builder, ListLandingZoneOperationsRequest> {
    private static final SdkField<LandingZoneOperationFilter> FILTER_FIELD = SdkField
            .<LandingZoneOperationFilter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListLandingZoneOperationsRequest::filter)).setter(setter(Builder::filter))
            .constructor(LandingZoneOperationFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListLandingZoneOperationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLandingZoneOperationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LandingZoneOperationFilter filter;

    private final Integer maxResults;

    private final String nextToken;

    private ListLandingZoneOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An input filter for the <code>ListLandingZoneOperations</code> API that lets you select the types of landing zone
     * operations to view.
     * </p>
     * 
     * @return An input filter for the <code>ListLandingZoneOperations</code> API that lets you select the types of
     *         landing zone operations to view.
     */
    public final LandingZoneOperationFilter filter() {
        return filter;
    }

    /**
     * <p>
     * How many results to return per API call.
     * </p>
     * 
     * @return How many results to return per API call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to continue the list from a previous API call with the same parameters.
     * </p>
     * 
     * @return The token to continue the list from a previous API call with the same parameters.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLandingZoneOperationsRequest)) {
            return false;
        }
        ListLandingZoneOperationsRequest other = (ListLandingZoneOperationsRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLandingZoneOperationsRequest").add("Filter", filter()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filter", FILTER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLandingZoneOperationsRequest, T> g) {
        return obj -> g.apply((ListLandingZoneOperationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLandingZoneOperationsRequest> {
        /**
         * <p>
         * An input filter for the <code>ListLandingZoneOperations</code> API that lets you select the types of landing
         * zone operations to view.
         * </p>
         * 
         * @param filter
         *        An input filter for the <code>ListLandingZoneOperations</code> API that lets you select the types of
         *        landing zone operations to view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(LandingZoneOperationFilter filter);

        /**
         * <p>
         * An input filter for the <code>ListLandingZoneOperations</code> API that lets you select the types of landing
         * zone operations to view.
         * </p>
         * This is a convenience method that creates an instance of the {@link LandingZoneOperationFilter.Builder}
         * avoiding the need to create one manually via {@link LandingZoneOperationFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LandingZoneOperationFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #filter(LandingZoneOperationFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link LandingZoneOperationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(LandingZoneOperationFilter)
         */
        default Builder filter(Consumer<LandingZoneOperationFilter.Builder> filter) {
            return filter(LandingZoneOperationFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * How many results to return per API call.
         * </p>
         * 
         * @param maxResults
         *        How many results to return per API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to continue the list from a previous API call with the same parameters.
         * </p>
         * 
         * @param nextToken
         *        The token to continue the list from a previous API call with the same parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private LandingZoneOperationFilter filter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLandingZoneOperationsRequest model) {
            super(model);
            filter(model.filter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final LandingZoneOperationFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(LandingZoneOperationFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(LandingZoneOperationFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLandingZoneOperationsRequest build() {
            return new ListLandingZoneOperationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
