/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetEnabledBaselineResponse extends ControlTowerResponse implements
        ToCopyableBuilder<ResetEnabledBaselineResponse.Builder, ResetEnabledBaselineResponse> {
    private static final SdkField<String> OPERATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationIdentifier").getter(getter(ResetEnabledBaselineResponse::operationIdentifier))
            .setter(setter(Builder::operationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String operationIdentifier;

    private ResetEnabledBaselineResponse(BuilderImpl builder) {
        super(builder);
        this.operationIdentifier = builder.operationIdentifier;
    }

    /**
     * <p>
     * The ID (in UUID format) of the asynchronous <code>ResetEnabledBaseline</code> operation. This
     * <code>operationIdentifier</code> is used to track status through calls to the <code>GetBaselineOperation</code>
     * API.
     * </p>
     * 
     * @return The ID (in UUID format) of the asynchronous <code>ResetEnabledBaseline</code> operation. This
     *         <code>operationIdentifier</code> is used to track status through calls to the
     *         <code>GetBaselineOperation</code> API.
     */
    public final String operationIdentifier() {
        return operationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(operationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetEnabledBaselineResponse)) {
            return false;
        }
        ResetEnabledBaselineResponse other = (ResetEnabledBaselineResponse) obj;
        return Objects.equals(operationIdentifier(), other.operationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResetEnabledBaselineResponse").add("OperationIdentifier", operationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operationIdentifier":
            return Optional.ofNullable(clazz.cast(operationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("operationIdentifier", OPERATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResetEnabledBaselineResponse, T> g) {
        return obj -> g.apply((ResetEnabledBaselineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ResetEnabledBaselineResponse> {
        /**
         * <p>
         * The ID (in UUID format) of the asynchronous <code>ResetEnabledBaseline</code> operation. This
         * <code>operationIdentifier</code> is used to track status through calls to the
         * <code>GetBaselineOperation</code> API.
         * </p>
         * 
         * @param operationIdentifier
         *        The ID (in UUID format) of the asynchronous <code>ResetEnabledBaseline</code> operation. This
         *        <code>operationIdentifier</code> is used to track status through calls to the
         *        <code>GetBaselineOperation</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationIdentifier(String operationIdentifier);
    }

    static final class BuilderImpl extends ControlTowerResponse.BuilderImpl implements Builder {
        private String operationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetEnabledBaselineResponse model) {
            super(model);
            operationIdentifier(model.operationIdentifier);
        }

        public final String getOperationIdentifier() {
            return operationIdentifier;
        }

        public final void setOperationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
        }

        @Override
        public final Builder operationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
            return this;
        }

        @Override
        public ResetEnabledBaselineResponse build() {
            return new ResetEnabledBaselineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
