/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLandingZoneRequest extends ControlTowerRequest implements
        ToCopyableBuilder<UpdateLandingZoneRequest.Builder, UpdateLandingZoneRequest> {
    private static final SdkField<String> LANDING_ZONE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("landingZoneIdentifier").getter(getter(UpdateLandingZoneRequest::landingZoneIdentifier))
            .setter(setter(Builder::landingZoneIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("landingZoneIdentifier").build())
            .build();

    private static final SdkField<Document> MANIFEST_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("manifest").getter(getter(UpdateLandingZoneRequest::manifest)).setter(setter(Builder::manifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifest").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(UpdateLandingZoneRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANDING_ZONE_IDENTIFIER_FIELD,
            MANIFEST_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String landingZoneIdentifier;

    private final Document manifest;

    private final String version;

    private UpdateLandingZoneRequest(BuilderImpl builder) {
        super(builder);
        this.landingZoneIdentifier = builder.landingZoneIdentifier;
        this.manifest = builder.manifest;
        this.version = builder.version;
    }

    /**
     * <p>
     * The unique identifier of the landing zone.
     * </p>
     * 
     * @return The unique identifier of the landing zone.
     */
    public final String landingZoneIdentifier() {
        return landingZoneIdentifier;
    }

    /**
     * <p>
     * The manifest file (JSON) is a text file that describes your Amazon Web Services resources. For an example, review
     * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch your landing zone</a>.
     * The example manifest file contains each of the available parameters. The schema for the landing zone's JSON
     * manifest file is not published, by design.
     * </p>
     * 
     * @return The manifest file (JSON) is a text file that describes your Amazon Web Services resources. For an
     *         example, review <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch
     *         your landing zone</a>. The example manifest file contains each of the available parameters. The schema
     *         for the landing zone's JSON manifest file is not published, by design.
     */
    public final Document manifest() {
        return manifest;
    }

    /**
     * <p>
     * The landing zone version, for example, 3.2.
     * </p>
     * 
     * @return The landing zone version, for example, 3.2.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(landingZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(manifest());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLandingZoneRequest)) {
            return false;
        }
        UpdateLandingZoneRequest other = (UpdateLandingZoneRequest) obj;
        return Objects.equals(landingZoneIdentifier(), other.landingZoneIdentifier())
                && Objects.equals(manifest(), other.manifest()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLandingZoneRequest").add("LandingZoneIdentifier", landingZoneIdentifier())
                .add("Manifest", manifest()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "landingZoneIdentifier":
            return Optional.ofNullable(clazz.cast(landingZoneIdentifier()));
        case "manifest":
            return Optional.ofNullable(clazz.cast(manifest()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("landingZoneIdentifier", LANDING_ZONE_IDENTIFIER_FIELD);
        map.put("manifest", MANIFEST_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLandingZoneRequest, T> g) {
        return obj -> g.apply((UpdateLandingZoneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLandingZoneRequest> {
        /**
         * <p>
         * The unique identifier of the landing zone.
         * </p>
         * 
         * @param landingZoneIdentifier
         *        The unique identifier of the landing zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landingZoneIdentifier(String landingZoneIdentifier);

        /**
         * <p>
         * The manifest file (JSON) is a text file that describes your Amazon Web Services resources. For an example,
         * review <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch your landing
         * zone</a>. The example manifest file contains each of the available parameters. The schema for the landing
         * zone's JSON manifest file is not published, by design.
         * </p>
         * 
         * @param manifest
         *        The manifest file (JSON) is a text file that describes your Amazon Web Services resources. For an
         *        example, review <a
         *        href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch your landing
         *        zone</a>. The example manifest file contains each of the available parameters. The schema for the
         *        landing zone's JSON manifest file is not published, by design.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifest(Document manifest);

        /**
         * <p>
         * The landing zone version, for example, 3.2.
         * </p>
         * 
         * @param version
         *        The landing zone version, for example, 3.2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private String landingZoneIdentifier;

        private Document manifest;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLandingZoneRequest model) {
            super(model);
            landingZoneIdentifier(model.landingZoneIdentifier);
            manifest(model.manifest);
            version(model.version);
        }

        public final String getLandingZoneIdentifier() {
            return landingZoneIdentifier;
        }

        public final void setLandingZoneIdentifier(String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
        }

        @Override
        public final Builder landingZoneIdentifier(String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
            return this;
        }

        public final Document getManifest() {
            return manifest;
        }

        public final void setManifest(Document manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(Document manifest) {
            this.manifest = manifest;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLandingZoneRequest build() {
            return new UpdateLandingZoneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
