/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.ControlTowerRequest;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnabledBaselinesRequest
extends ControlTowerRequest
implements ToCopyableBuilder<Builder, ListEnabledBaselinesRequest> {
    private static final SdkField<EnabledBaselineFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(ListEnabledBaselinesRequest.getter(ListEnabledBaselinesRequest::filter)).setter(ListEnabledBaselinesRequest.setter(Builder::filter)).constructor(EnabledBaselineFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CHILDREN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeChildren").getter(ListEnabledBaselinesRequest.getter(ListEnabledBaselinesRequest::includeChildren)).setter(ListEnabledBaselinesRequest.setter(Builder::includeChildren)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeChildren").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListEnabledBaselinesRequest.getter(ListEnabledBaselinesRequest::maxResults)).setter(ListEnabledBaselinesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEnabledBaselinesRequest.getter(ListEnabledBaselinesRequest::nextToken)).setter(ListEnabledBaselinesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, INCLUDE_CHILDREN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnabledBaselinesRequest.memberNameToFieldInitializer();
    private final EnabledBaselineFilter filter;
    private final Boolean includeChildren;
    private final Integer maxResults;
    private final String nextToken;

    private ListEnabledBaselinesRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.includeChildren = builder.includeChildren;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final EnabledBaselineFilter filter() {
        return this.filter;
    }

    public final Boolean includeChildren() {
        return this.includeChildren;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeChildren());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnabledBaselinesRequest)) {
            return false;
        }
        ListEnabledBaselinesRequest other = (ListEnabledBaselinesRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.includeChildren(), other.includeChildren()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnabledBaselinesRequest").add("Filter", (Object)this.filter()).add("IncludeChildren", (Object)this.includeChildren()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "includeChildren": {
                return Optional.ofNullable(clazz.cast(this.includeChildren()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filter", FILTER_FIELD);
        map.put("includeChildren", INCLUDE_CHILDREN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnabledBaselinesRequest, T> g) {
        return obj -> g.apply((ListEnabledBaselinesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerRequest.BuilderImpl
    implements Builder {
        private EnabledBaselineFilter filter;
        private Boolean includeChildren;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnabledBaselinesRequest model) {
            super(model);
            this.filter(model.filter);
            this.includeChildren(model.includeChildren);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final EnabledBaselineFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(EnabledBaselineFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(EnabledBaselineFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Boolean getIncludeChildren() {
            return this.includeChildren;
        }

        public final void setIncludeChildren(Boolean includeChildren) {
            this.includeChildren = includeChildren;
        }

        @Override
        public final Builder includeChildren(Boolean includeChildren) {
            this.includeChildren = includeChildren;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnabledBaselinesRequest build() {
            return new ListEnabledBaselinesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ControlTowerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnabledBaselinesRequest> {
        public Builder filter(EnabledBaselineFilter var1);

        default public Builder filter(Consumer<EnabledBaselineFilter.Builder> filter) {
            return this.filter((EnabledBaselineFilter)((EnabledBaselineFilter.Builder)EnabledBaselineFilter.builder().applyMutation(filter)).build());
        }

        public Builder includeChildren(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

