/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.DriftStatusSummary;
import software.amazon.awssdk.services.controltower.model.EnabledControlParameterSummariesCopier;
import software.amazon.awssdk.services.controltower.model.EnabledControlParameterSummary;
import software.amazon.awssdk.services.controltower.model.EnablementStatusSummary;
import software.amazon.awssdk.services.controltower.model.Region;
import software.amazon.awssdk.services.controltower.model.TargetRegionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnabledControlDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnabledControlDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EnabledControlDetails.getter(EnabledControlDetails::arn)).setter(EnabledControlDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CONTROL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlIdentifier").getter(EnabledControlDetails.getter(EnabledControlDetails::controlIdentifier)).setter(EnabledControlDetails.setter(Builder::controlIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifier").build()}).build();
    private static final SdkField<DriftStatusSummary> DRIFT_STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("driftStatusSummary").getter(EnabledControlDetails.getter(EnabledControlDetails::driftStatusSummary)).setter(EnabledControlDetails.setter(Builder::driftStatusSummary)).constructor(DriftStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatusSummary").build()}).build();
    private static final SdkField<List<EnabledControlParameterSummary>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(EnabledControlDetails.getter(EnabledControlDetails::parameters)).setter(EnabledControlDetails.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnabledControlParameterSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EnablementStatusSummary> STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusSummary").getter(EnabledControlDetails.getter(EnabledControlDetails::statusSummary)).setter(EnabledControlDetails.setter(Builder::statusSummary)).constructor(EnablementStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()}).build();
    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetIdentifier").getter(EnabledControlDetails.getter(EnabledControlDetails::targetIdentifier)).setter(EnabledControlDetails.setter(Builder::targetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()}).build();
    private static final SdkField<List<Region>> TARGET_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetRegions").getter(EnabledControlDetails.getter(EnabledControlDetails::targetRegions)).setter(EnabledControlDetails.setter(Builder::targetRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Region::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONTROL_IDENTIFIER_FIELD, DRIFT_STATUS_SUMMARY_FIELD, PARAMETERS_FIELD, STATUS_SUMMARY_FIELD, TARGET_IDENTIFIER_FIELD, TARGET_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnabledControlDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String controlIdentifier;
    private final DriftStatusSummary driftStatusSummary;
    private final List<EnabledControlParameterSummary> parameters;
    private final EnablementStatusSummary statusSummary;
    private final String targetIdentifier;
    private final List<Region> targetRegions;

    private EnabledControlDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.controlIdentifier = builder.controlIdentifier;
        this.driftStatusSummary = builder.driftStatusSummary;
        this.parameters = builder.parameters;
        this.statusSummary = builder.statusSummary;
        this.targetIdentifier = builder.targetIdentifier;
        this.targetRegions = builder.targetRegions;
    }

    public final String arn() {
        return this.arn;
    }

    public final String controlIdentifier() {
        return this.controlIdentifier;
    }

    public final DriftStatusSummary driftStatusSummary() {
        return this.driftStatusSummary;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<EnabledControlParameterSummary> parameters() {
        return this.parameters;
    }

    public final EnablementStatusSummary statusSummary() {
        return this.statusSummary;
    }

    public final String targetIdentifier() {
        return this.targetIdentifier;
    }

    public final boolean hasTargetRegions() {
        return this.targetRegions != null && !(this.targetRegions instanceof SdkAutoConstructList);
    }

    public final List<Region> targetRegions() {
        return this.targetRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftStatusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetRegions() ? this.targetRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledControlDetails)) {
            return false;
        }
        EnabledControlDetails other = (EnabledControlDetails)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.controlIdentifier(), other.controlIdentifier()) && Objects.equals(this.driftStatusSummary(), other.driftStatusSummary()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.statusSummary(), other.statusSummary()) && Objects.equals(this.targetIdentifier(), other.targetIdentifier()) && this.hasTargetRegions() == other.hasTargetRegions() && Objects.equals(this.targetRegions(), other.targetRegions());
    }

    public final String toString() {
        return ToString.builder((String)"EnabledControlDetails").add("Arn", (Object)this.arn()).add("ControlIdentifier", (Object)this.controlIdentifier()).add("DriftStatusSummary", (Object)this.driftStatusSummary()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("StatusSummary", (Object)this.statusSummary()).add("TargetIdentifier", (Object)this.targetIdentifier()).add("TargetRegions", this.hasTargetRegions() ? this.targetRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "controlIdentifier": {
                return Optional.ofNullable(clazz.cast(this.controlIdentifier()));
            }
            case "driftStatusSummary": {
                return Optional.ofNullable(clazz.cast(this.driftStatusSummary()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "statusSummary": {
                return Optional.ofNullable(clazz.cast(this.statusSummary()));
            }
            case "targetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetIdentifier()));
            }
            case "targetRegions": {
                return Optional.ofNullable(clazz.cast(this.targetRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("controlIdentifier", CONTROL_IDENTIFIER_FIELD);
        map.put("driftStatusSummary", DRIFT_STATUS_SUMMARY_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("statusSummary", STATUS_SUMMARY_FIELD);
        map.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        map.put("targetRegions", TARGET_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnabledControlDetails, T> g) {
        return obj -> g.apply((EnabledControlDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String controlIdentifier;
        private DriftStatusSummary driftStatusSummary;
        private List<EnabledControlParameterSummary> parameters = DefaultSdkAutoConstructList.getInstance();
        private EnablementStatusSummary statusSummary;
        private String targetIdentifier;
        private List<Region> targetRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledControlDetails model) {
            this.arn(model.arn);
            this.controlIdentifier(model.controlIdentifier);
            this.driftStatusSummary(model.driftStatusSummary);
            this.parameters(model.parameters);
            this.statusSummary(model.statusSummary);
            this.targetIdentifier(model.targetIdentifier);
            this.targetRegions(model.targetRegions);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getControlIdentifier() {
            return this.controlIdentifier;
        }

        public final void setControlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
        }

        @Override
        public final Builder controlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
            return this;
        }

        public final DriftStatusSummary.Builder getDriftStatusSummary() {
            return this.driftStatusSummary != null ? this.driftStatusSummary.toBuilder() : null;
        }

        public final void setDriftStatusSummary(DriftStatusSummary.BuilderImpl driftStatusSummary) {
            this.driftStatusSummary = driftStatusSummary != null ? driftStatusSummary.build() : null;
        }

        @Override
        public final Builder driftStatusSummary(DriftStatusSummary driftStatusSummary) {
            this.driftStatusSummary = driftStatusSummary;
            return this;
        }

        public final List<EnabledControlParameterSummary.Builder> getParameters() {
            List<EnabledControlParameterSummary.Builder> result = EnabledControlParameterSummariesCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<EnabledControlParameterSummary.BuilderImpl> parameters) {
            this.parameters = EnabledControlParameterSummariesCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<EnabledControlParameterSummary> parameters) {
            this.parameters = EnabledControlParameterSummariesCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(EnabledControlParameterSummary ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<EnabledControlParameterSummary.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (EnabledControlParameterSummary)((EnabledControlParameterSummary.Builder)EnabledControlParameterSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EnablementStatusSummary.Builder getStatusSummary() {
            return this.statusSummary != null ? this.statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(EnablementStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(EnablementStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final String getTargetIdentifier() {
            return this.targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public final List<Region.Builder> getTargetRegions() {
            List<Region.Builder> result = TargetRegionsCopier.copyToBuilder(this.targetRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetRegions(Collection<Region.BuilderImpl> targetRegions) {
            this.targetRegions = TargetRegionsCopier.copyFromBuilder(targetRegions);
        }

        @Override
        public final Builder targetRegions(Collection<Region> targetRegions) {
            this.targetRegions = TargetRegionsCopier.copy(targetRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetRegions(Region ... targetRegions) {
            this.targetRegions(Arrays.asList(targetRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetRegions(Consumer<Region.Builder> ... targetRegions) {
            this.targetRegions(Stream.of(targetRegions).map(c -> (Region)((Region.Builder)Region.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EnabledControlDetails build() {
            return new EnabledControlDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnabledControlDetails> {
        public Builder arn(String var1);

        public Builder controlIdentifier(String var1);

        public Builder driftStatusSummary(DriftStatusSummary var1);

        default public Builder driftStatusSummary(Consumer<DriftStatusSummary.Builder> driftStatusSummary) {
            return this.driftStatusSummary((DriftStatusSummary)((DriftStatusSummary.Builder)DriftStatusSummary.builder().applyMutation(driftStatusSummary)).build());
        }

        public Builder parameters(Collection<EnabledControlParameterSummary> var1);

        public Builder parameters(EnabledControlParameterSummary ... var1);

        public Builder parameters(Consumer<EnabledControlParameterSummary.Builder> ... var1);

        public Builder statusSummary(EnablementStatusSummary var1);

        default public Builder statusSummary(Consumer<EnablementStatusSummary.Builder> statusSummary) {
            return this.statusSummary((EnablementStatusSummary)((EnablementStatusSummary.Builder)EnablementStatusSummary.builder().applyMutation(statusSummary)).build());
        }

        public Builder targetIdentifier(String var1);

        public Builder targetRegions(Collection<Region> var1);

        public Builder targetRegions(Region ... var1);

        public Builder targetRegions(Consumer<Region.Builder> ... var1);
    }
}

