/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.controltower.model.AccessDeniedException;
import software.amazon.awssdk.services.controltower.model.ConflictException;
import software.amazon.awssdk.services.controltower.model.ControlTowerException;
import software.amazon.awssdk.services.controltower.model.CreateLandingZoneRequest;
import software.amazon.awssdk.services.controltower.model.CreateLandingZoneResponse;
import software.amazon.awssdk.services.controltower.model.DeleteLandingZoneRequest;
import software.amazon.awssdk.services.controltower.model.DeleteLandingZoneResponse;
import software.amazon.awssdk.services.controltower.model.DisableBaselineRequest;
import software.amazon.awssdk.services.controltower.model.DisableBaselineResponse;
import software.amazon.awssdk.services.controltower.model.DisableControlRequest;
import software.amazon.awssdk.services.controltower.model.DisableControlResponse;
import software.amazon.awssdk.services.controltower.model.EnableBaselineRequest;
import software.amazon.awssdk.services.controltower.model.EnableBaselineResponse;
import software.amazon.awssdk.services.controltower.model.EnableControlRequest;
import software.amazon.awssdk.services.controltower.model.EnableControlResponse;
import software.amazon.awssdk.services.controltower.model.GetBaselineOperationRequest;
import software.amazon.awssdk.services.controltower.model.GetBaselineOperationResponse;
import software.amazon.awssdk.services.controltower.model.GetBaselineRequest;
import software.amazon.awssdk.services.controltower.model.GetBaselineResponse;
import software.amazon.awssdk.services.controltower.model.GetControlOperationRequest;
import software.amazon.awssdk.services.controltower.model.GetControlOperationResponse;
import software.amazon.awssdk.services.controltower.model.GetEnabledBaselineRequest;
import software.amazon.awssdk.services.controltower.model.GetEnabledBaselineResponse;
import software.amazon.awssdk.services.controltower.model.GetEnabledControlRequest;
import software.amazon.awssdk.services.controltower.model.GetEnabledControlResponse;
import software.amazon.awssdk.services.controltower.model.GetLandingZoneOperationRequest;
import software.amazon.awssdk.services.controltower.model.GetLandingZoneOperationResponse;
import software.amazon.awssdk.services.controltower.model.GetLandingZoneRequest;
import software.amazon.awssdk.services.controltower.model.GetLandingZoneResponse;
import software.amazon.awssdk.services.controltower.model.InternalServerException;
import software.amazon.awssdk.services.controltower.model.ListBaselinesRequest;
import software.amazon.awssdk.services.controltower.model.ListBaselinesResponse;
import software.amazon.awssdk.services.controltower.model.ListControlOperationsRequest;
import software.amazon.awssdk.services.controltower.model.ListControlOperationsResponse;
import software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest;
import software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesResponse;
import software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest;
import software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse;
import software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsRequest;
import software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsResponse;
import software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest;
import software.amazon.awssdk.services.controltower.model.ListLandingZonesResponse;
import software.amazon.awssdk.services.controltower.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.controltower.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.controltower.model.ResetEnabledBaselineRequest;
import software.amazon.awssdk.services.controltower.model.ResetEnabledBaselineResponse;
import software.amazon.awssdk.services.controltower.model.ResetEnabledControlRequest;
import software.amazon.awssdk.services.controltower.model.ResetEnabledControlResponse;
import software.amazon.awssdk.services.controltower.model.ResetLandingZoneRequest;
import software.amazon.awssdk.services.controltower.model.ResetLandingZoneResponse;
import software.amazon.awssdk.services.controltower.model.ResourceNotFoundException;
import software.amazon.awssdk.services.controltower.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.controltower.model.TagResourceRequest;
import software.amazon.awssdk.services.controltower.model.TagResourceResponse;
import software.amazon.awssdk.services.controltower.model.ThrottlingException;
import software.amazon.awssdk.services.controltower.model.UntagResourceRequest;
import software.amazon.awssdk.services.controltower.model.UntagResourceResponse;
import software.amazon.awssdk.services.controltower.model.UpdateEnabledBaselineRequest;
import software.amazon.awssdk.services.controltower.model.UpdateEnabledBaselineResponse;
import software.amazon.awssdk.services.controltower.model.UpdateEnabledControlRequest;
import software.amazon.awssdk.services.controltower.model.UpdateEnabledControlResponse;
import software.amazon.awssdk.services.controltower.model.UpdateLandingZoneRequest;
import software.amazon.awssdk.services.controltower.model.UpdateLandingZoneResponse;
import software.amazon.awssdk.services.controltower.model.ValidationException;
import software.amazon.awssdk.services.controltower.paginators.ListBaselinesIterable;
import software.amazon.awssdk.services.controltower.paginators.ListControlOperationsIterable;
import software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesIterable;
import software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsIterable;
import software.amazon.awssdk.services.controltower.paginators.ListLandingZoneOperationsIterable;
import software.amazon.awssdk.services.controltower.paginators.ListLandingZonesIterable;

/**
 * Service client for accessing AWS Control Tower. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services Control Tower offers application programming interface (API) operations that support programmatic
 * interaction with these types of resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/controls.html"> <i>Controls</i> </a>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_DisableControl.html">DisableControl</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html">EnableControl</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetEnabledControl.html">GetEnabledControl</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetControlOperation.html">
 * GetControlOperation</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListControlOperations.html">
 * ListControlOperations</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListEnabledControls.html">
 * ListEnabledControls</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_ResetEnabledControl.html">
 * ResetEnabledControl</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateEnabledControl.html">
 * UpdateEnabledControl</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch.html"> <i>Landing zones</i> </a>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_CreateLandingZone.html">CreateLandingZone</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_DeleteLandingZone.html">DeleteLandingZone</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetLandingZone.html">GetLandingZone</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetLandingZoneOperation.html">
 * GetLandingZoneOperation</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListLandingZones.html">ListLandingZones</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListLandingZoneOperations.html">
 * ListLandingZoneOperations</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_ResetLandingZone.html">ResetLandingZone</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateLandingZone.html">UpdateLandingZone</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/types-of-baselines.html"> <i>Baselines</i> </a>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_DisableBaseline.html">DisableBaseline</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableBaseline.html">EnableBaseline</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetBaseline.html">GetBaseline</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetBaselineOperation.html">
 * GetBaselineOperation</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetEnabledBaseline.html">GetEnabledBaseline<
 * /a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListBaselines.html">ListBaselines</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListEnabledBaselines.html">
 * ListEnabledBaselines</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_ResetEnabledBaseline.html">
 * ResetEnabledBaseline</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateEnabledBaseline.html">
 * UpdateEnabledBaseline</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/controlreference/tagging.html"> <i>Tagging</i> </a>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListTagsForResource.html">
 * ListTagsForResource</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_TagResource.html">TagResource</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_UntagResource.html">UntagResource</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * <p>
 * For more information about these types of resources, see the <a
 * href="https://docs.aws.amazon.com/controltower/latest/userguide/what-is-control-tower.html"> <i>Amazon Web Services
 * Control Tower User Guide</i> </a>.
 * </p>
 * <p>
 * <b>About control APIs</b>
 * </p>
 * <p>
 * These interfaces allow you to apply the Amazon Web Services library of pre-defined <i>controls</i> to your
 * organizational units, programmatically. In Amazon Web Services Control Tower, the terms "control" and "guardrail" are
 * synonyms.
 * </p>
 * <p>
 * To call these APIs, you'll need to know:
 * </p>
 * <ul>
 * <li>
 * <p>
 * the <code>controlIdentifier</code> for the control--or guardrail--you are targeting.
 * </p>
 * </li>
 * <li>
 * <p>
 * the ARN associated with the target organizational unit (OU), which we call the <code>targetIdentifier</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * the ARN associated with a resource that you wish to tag or untag.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>To get the <code>controlIdentifier</code> for your Amazon Web Services Control Tower control:</b>
 * </p>
 * <p>
 * The <code>controlIdentifier</code> is an ARN that is specified for each control. You can view the
 * <code>controlIdentifier</code> in the console on the <b>Control details</b> page, as well as in the documentation.
 * </p>
 * <p>
 * <b>About identifiers for Amazon Web Services Control Tower</b>
 * </p>
 * <p>
 * The Amazon Web Services Control Tower <code>controlIdentifier</code> is unique in each Amazon Web Services Region for
 * each control. You can find the <code>controlIdentifier</code> for each Region and control in the <a
 * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-metadata-tables.html">Tables of
 * control metadata</a> or the <a
 * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-region-tables.html">Control
 * availability by Region tables</a> in the <i>Amazon Web Services Control Tower Controls Reference Guide</i>.
 * </p>
 * <p>
 * A quick-reference list of control identifers for the Amazon Web Services Control Tower legacy <i>Strongly
 * recommended</i> and <i>Elective</i> controls is given in <a
 * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-identifiers.html.html">Resource
 * identifiers for APIs and controls</a> in the <a
 * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-identifiers.html"> <i>Amazon Web
 * Services Control Tower Controls Reference Guide</i> </a>. Remember that <i>Mandatory</i> controls cannot be added or
 * removed.
 * </p>
 * <note>
 * <p>
 * <b>Some controls have two identifiers</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>ARN format for Amazon Web Services Control Tower:</b>
 * <code>arn:aws:controltower:{REGION}::control/{CONTROL_TOWER_OPAQUE_ID}</code>
 * </p>
 * <p>
 * <b>Example:</b>
 * </p>
 * <p>
 * <code>arn:aws:controltower:us-west-2::control/AWS-GR_AUTOSCALING_LAUNCH_CONFIG_PUBLIC_IP_DISABLED</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>ARN format for Amazon Web Services Control Catalog:</b>
 * <code>arn:{PARTITION}:controlcatalog:::control/{CONTROL_CATALOG_OPAQUE_ID}</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can find the <code>{CONTROL_CATALOG_OPAQUE_ID}</code> in the <a
 * href="https://docs.aws.amazon.com/controltower/latest/controlreference/all-global-identifiers.html"> <i>Amazon Web
 * Services Control Tower Controls Reference Guide</i> </a>, or in the Amazon Web Services Control Tower console, on the
 * <b>Control details</b> page.
 * </p>
 * <p>
 * The Amazon Web Services Control Tower APIs for enabled controls, such as <code>GetEnabledControl</code> and
 * <code>ListEnabledControls</code> always return an ARN of the same type given when the control was enabled.
 * </p>
 * </note>
 * <p>
 * <b>To get the <code>targetIdentifier</code>:</b>
 * </p>
 * <p>
 * The <code>targetIdentifier</code> is the ARN for an OU.
 * </p>
 * <p>
 * In the Amazon Web Services Organizations console, you can find the ARN for the OU on the <b>Organizational unit
 * details</b> page associated with that OU.
 * </p>
 * <note>
 * <p>
 * <b>OU ARN format:</b>
 * </p>
 * <p>
 * <code>arn:${Partition}:organizations::${MasterAccountId}:ou/o-${OrganizationId}/ou-${OrganizationalUnitId}</code>
 * </p>
 * </note>
 * <p>
 * <b> About landing zone APIs</b>
 * </p>
 * <p>
 * You can configure and launch an Amazon Web Services Control Tower landing zone with APIs. For an introduction and
 * steps, see <a href="https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-apis.html">Getting
 * started with Amazon Web Services Control Tower using APIs</a>.
 * </p>
 * <p>
 * For an overview of landing zone API operations, see <a
 * href="https://docs.aws.amazon.com/controltower/latest/userguide/2023-all.html#landing-zone-apis"> Amazon Web Services
 * Control Tower supports landing zone APIs</a>. The individual API operations for landing zones are detailed in this
 * document, the <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_Operations.html">API
 * reference manual</a>, in the "Actions" section.
 * </p>
 * <p>
 * <b>About baseline APIs</b>
 * </p>
 * <p>
 * You can apply the <code>AWSControlTowerBaseline</code> baseline to an organizational unit (OU) as a way to register
 * the OU with Amazon Web Services Control Tower, programmatically. For a general overview of this capability, see <a
 * href="https://docs.aws.amazon.com/controltower/latest/userguide/2024-all.html#baseline-apis">Amazon Web Services
 * Control Tower supports APIs for OU registration and configuration with baselines</a>.
 * </p>
 * <p>
 * You can call the baseline API operations to view the baselines that Amazon Web Services Control Tower enables for
 * your landing zone, on your behalf, when setting up the landing zone. These baselines are read-only baselines.
 * </p>
 * <p>
 * The individual API operations for baselines are detailed in this document, the <a
 * href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_Operations.html">API reference manual</a>, in
 * the "Actions" section. For usage examples, see <a
 * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html">Baseline API input and
 * output examples with CLI</a>.
 * </p>
 * <p>
 * <b> About Amazon Web Services Control Catalog identifiers</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * The <code>EnableControl</code> and <code>DisableControl</code> API operations can be called by specifying either the
 * Amazon Web Services Control Tower identifer or the Amazon Web Services Control Catalog identifier. The API response
 * returns the same type of identifier that you specified when calling the API.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you use an Amazon Web Services Control Tower identifier to call the <code>EnableControl</code> API, and then call
 * <code>EnableControl</code> again with an Amazon Web Services Control Catalog identifier, Amazon Web Services Control
 * Tower returns an error message stating that the control is already enabled. Similar behavior applies to the
 * <code>DisableControl</code> API operation.
 * </p>
 * </li>
 * <li>
 * <p>
 * Mandatory controls and the landing-zone-level Region deny control have Amazon Web Services Control Tower identifiers
 * only.
 * </p>
 * </li>
 * </ul>
 * <p class="title">
 * <b>Details and examples</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">Control
 * API input and output examples with CLI</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html">Baseline API input and
 * output examples with CLI</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/controlreference/enable-controls.html">Enable controls with
 * CloudFormation</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-apis-cfn-setup.html">Launch a landing zone with
 * CloudFormation</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-metadata-tables.html">Control
 * metadata tables (large page)</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-region-tables.html">Control
 * availability by Region tables (large page)</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-identifiers.html">List of
 * identifiers for legacy controls</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/controlreference/controls.html">Controls reference guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/controlreference/controls-reference.html">Controls library
 * groupings</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/creating-resources-with-cloudformation.html">
 * Creating Amazon Web Services Control Tower resources with Amazon Web Services CloudFormation</a>
 * </p>
 * </li>
 * </ul>
 * <p>
 * To view the open source resource repository on GitHub, see <a
 * href="https://github.com/aws-cloudformation/aws-cloudformation-resource-providers-controltower"
 * >aws-cloudformation/aws-cloudformation-resource-providers-controltower</a>
 * </p>
 * <p>
 * <b>Recording API Requests</b>
 * </p>
 * <p>
 * Amazon Web Services Control Tower supports Amazon Web Services CloudTrail, a service that records Amazon Web Services
 * API calls for your Amazon Web Services account and delivers log files to an Amazon S3 bucket. By using information
 * collected by CloudTrail, you can determine which requests the Amazon Web Services Control Tower service received, who
 * made the request and when, and so on. For more about Amazon Web Services Control Tower and its support for
 * CloudTrail, see <a
 * href="https://docs.aws.amazon.com/controltower/latest/userguide/logging-using-cloudtrail.html">Logging Amazon Web
 * Services Control Tower Actions with Amazon Web Services CloudTrail</a> in the Amazon Web Services Control Tower User
 * Guide. To learn more about CloudTrail, including how to turn it on and find your log files, see the Amazon Web
 * Services CloudTrail User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ControlTowerClient extends AwsClient {
    String SERVICE_NAME = "controltower";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "controltower";

    /**
     * <p>
     * Creates a new landing zone. This API call starts an asynchronous operation that creates and configures a landing
     * zone, based on the parameters specified in the manifest JSON file.
     * </p>
     *
     * @param createLandingZoneRequest
     * @return Result of the CreateLandingZone operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.CreateLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/CreateLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLandingZoneResponse createLandingZone(CreateLandingZoneRequest createLandingZoneRequest)
            throws ConflictException, ValidationException, InternalServerException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new landing zone. This API call starts an asynchronous operation that creates and configures a landing
     * zone, based on the parameters specified in the manifest JSON file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLandingZoneRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLandingZoneRequest#builder()}
     * </p>
     *
     * @param createLandingZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.CreateLandingZoneRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLandingZone operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.CreateLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/CreateLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLandingZoneResponse createLandingZone(Consumer<CreateLandingZoneRequest.Builder> createLandingZoneRequest)
            throws ConflictException, ValidationException, InternalServerException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, ControlTowerException {
        return createLandingZone(CreateLandingZoneRequest.builder().applyMutation(createLandingZoneRequest).build());
    }

    /**
     * <p>
     * Decommissions a landing zone. This API call starts an asynchronous operation that deletes Amazon Web Services
     * Control Tower resources deployed in accounts managed by Amazon Web Services Control Tower.
     * </p>
     * <p>
     * Decommissioning a landing zone is a process with significant consequences, and it cannot be undone. We strongly
     * recommend that you perform this decommissioning process only if you intend to stop using your landing zone.
     * </p>
     *
     * @param deleteLandingZoneRequest
     * @return Result of the DeleteLandingZone operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.DeleteLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DeleteLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLandingZoneResponse deleteLandingZone(DeleteLandingZoneRequest deleteLandingZoneRequest)
            throws ConflictException, ValidationException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Decommissions a landing zone. This API call starts an asynchronous operation that deletes Amazon Web Services
     * Control Tower resources deployed in accounts managed by Amazon Web Services Control Tower.
     * </p>
     * <p>
     * Decommissioning a landing zone is a process with significant consequences, and it cannot be undone. We strongly
     * recommend that you perform this decommissioning process only if you intend to stop using your landing zone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLandingZoneRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLandingZoneRequest#builder()}
     * </p>
     *
     * @param deleteLandingZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.DeleteLandingZoneRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLandingZone operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.DeleteLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DeleteLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLandingZoneResponse deleteLandingZone(Consumer<DeleteLandingZoneRequest.Builder> deleteLandingZoneRequest)
            throws ConflictException, ValidationException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return deleteLandingZone(DeleteLandingZoneRequest.builder().applyMutation(deleteLandingZoneRequest).build());
    }

    /**
     * <p>
     * Disable an <code>EnabledBaseline</code> resource on the specified Target. This API starts an asynchronous
     * operation to remove all resources deployed as part of the baseline enablement. The resource will vary depending
     * on the enabled baseline. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param disableBaselineRequest
     * @return Result of the DisableBaseline operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.DisableBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DisableBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default DisableBaselineResponse disableBaseline(DisableBaselineRequest disableBaselineRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disable an <code>EnabledBaseline</code> resource on the specified Target. This API starts an asynchronous
     * operation to remove all resources deployed as part of the baseline enablement. The resource will vary depending
     * on the enabled baseline. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableBaselineRequest.Builder} avoiding the need
     * to create one manually via {@link DisableBaselineRequest#builder()}
     * </p>
     *
     * @param disableBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.DisableBaselineRequest.Builder} to create a
     *        request.
     * @return Result of the DisableBaseline operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.DisableBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DisableBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default DisableBaselineResponse disableBaseline(Consumer<DisableBaselineRequest.Builder> disableBaselineRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return disableBaseline(DisableBaselineRequest.builder().applyMutation(disableBaselineRequest).build());
    }

    /**
     * <p>
     * This API call turns off a control. It starts an asynchronous operation that deletes Amazon Web Services resources
     * on the specified organizational unit and the accounts it contains. The resources will vary according to the
     * control that you specify. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     *
     * @param disableControlRequest
     * @return Result of the DisableControl operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.DisableControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DisableControl" target="_top">AWS
     *      API Documentation</a>
     */
    default DisableControlResponse disableControl(DisableControlRequest disableControlRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API call turns off a control. It starts an asynchronous operation that deletes Amazon Web Services resources
     * on the specified organizational unit and the accounts it contains. The resources will vary according to the
     * control that you specify. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableControlRequest.Builder} avoiding the need to
     * create one manually via {@link DisableControlRequest#builder()}
     * </p>
     *
     * @param disableControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.DisableControlRequest.Builder} to create a
     *        request.
     * @return Result of the DisableControl operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.DisableControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/DisableControl" target="_top">AWS
     *      API Documentation</a>
     */
    default DisableControlResponse disableControl(Consumer<DisableControlRequest.Builder> disableControlRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return disableControl(DisableControlRequest.builder().applyMutation(disableControlRequest).build());
    }

    /**
     * <p>
     * Enable (apply) a <code>Baseline</code> to a Target. This API starts an asynchronous operation to deploy resources
     * specified by the <code>Baseline</code> to the specified Target. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param enableBaselineRequest
     * @return Result of the EnableBaseline operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.EnableBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/EnableBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableBaselineResponse enableBaseline(EnableBaselineRequest enableBaselineRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable (apply) a <code>Baseline</code> to a Target. This API starts an asynchronous operation to deploy resources
     * specified by the <code>Baseline</code> to the specified Target. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableBaselineRequest.Builder} avoiding the need to
     * create one manually via {@link EnableBaselineRequest#builder()}
     * </p>
     *
     * @param enableBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.EnableBaselineRequest.Builder} to create a
     *        request.
     * @return Result of the EnableBaseline operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.EnableBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/EnableBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableBaselineResponse enableBaseline(Consumer<EnableBaselineRequest.Builder> enableBaselineRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return enableBaseline(EnableBaselineRequest.builder().applyMutation(enableBaselineRequest).build());
    }

    /**
     * <p>
     * This API call activates a control. It starts an asynchronous operation that creates Amazon Web Services resources
     * on the specified organizational unit and the accounts it contains. The resources created will vary according to
     * the control that you specify. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     *
     * @param enableControlRequest
     * @return Result of the EnableControl operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.EnableControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/EnableControl" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableControlResponse enableControl(EnableControlRequest enableControlRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API call activates a control. It starts an asynchronous operation that creates Amazon Web Services resources
     * on the specified organizational unit and the accounts it contains. The resources created will vary according to
     * the control that you specify. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableControlRequest.Builder} avoiding the need to
     * create one manually via {@link EnableControlRequest#builder()}
     * </p>
     *
     * @param enableControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.EnableControlRequest.Builder} to create a
     *        request.
     * @return Result of the EnableControl operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.EnableControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/EnableControl" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableControlResponse enableControl(Consumer<EnableControlRequest.Builder> enableControlRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return enableControl(EnableControlRequest.builder().applyMutation(enableControlRequest).build());
    }

    /**
     * <p>
     * Retrieve details about an existing <code>Baseline</code> resource by specifying its identifier. For usage
     * examples, see <a href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html">
     * <i>the Amazon Web Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param getBaselineRequest
     * @return Result of the GetBaseline operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBaselineResponse getBaseline(GetBaselineRequest getBaselineRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve details about an existing <code>Baseline</code> resource by specifying its identifier. For usage
     * examples, see <a href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html">
     * <i>the Amazon Web Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBaselineRequest.Builder} avoiding the need to
     * create one manually via {@link GetBaselineRequest#builder()}
     * </p>
     *
     * @param getBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetBaselineRequest.Builder} to create a request.
     * @return Result of the GetBaseline operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBaselineResponse getBaseline(Consumer<GetBaselineRequest.Builder> getBaselineRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return getBaseline(GetBaselineRequest.builder().applyMutation(getBaselineRequest).build());
    }

    /**
     * <p>
     * Returns the details of an asynchronous baseline operation, as initiated by any of these APIs:
     * <code>EnableBaseline</code>, <code>DisableBaseline</code>, <code>UpdateEnabledBaseline</code>,
     * <code>ResetEnabledBaseline</code>. A status message is displayed in case of operation failure. For usage
     * examples, see <a href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html">
     * <i>the Amazon Web Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param getBaselineOperationRequest
     * @return Result of the GetBaselineOperation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetBaselineOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetBaselineOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBaselineOperationResponse getBaselineOperation(GetBaselineOperationRequest getBaselineOperationRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of an asynchronous baseline operation, as initiated by any of these APIs:
     * <code>EnableBaseline</code>, <code>DisableBaseline</code>, <code>UpdateEnabledBaseline</code>,
     * <code>ResetEnabledBaseline</code>. A status message is displayed in case of operation failure. For usage
     * examples, see <a href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html">
     * <i>the Amazon Web Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBaselineOperationRequest.Builder} avoiding the
     * need to create one manually via {@link GetBaselineOperationRequest#builder()}
     * </p>
     *
     * @param getBaselineOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetBaselineOperationRequest.Builder} to create a
     *        request.
     * @return Result of the GetBaselineOperation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetBaselineOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetBaselineOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBaselineOperationResponse getBaselineOperation(
            Consumer<GetBaselineOperationRequest.Builder> getBaselineOperationRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return getBaselineOperation(GetBaselineOperationRequest.builder().applyMutation(getBaselineOperationRequest).build());
    }

    /**
     * <p>
     * Returns the status of a particular <code>EnableControl</code> or <code>DisableControl</code> operation. Displays
     * a message in case of error. Details for an operation are available for 90 days. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     *
     * @param getControlOperationRequest
     * @return Result of the GetControlOperation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetControlOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetControlOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetControlOperationResponse getControlOperation(GetControlOperationRequest getControlOperationRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of a particular <code>EnableControl</code> or <code>DisableControl</code> operation. Displays
     * a message in case of error. Details for an operation are available for 90 days. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetControlOperationRequest.Builder} avoiding the
     * need to create one manually via {@link GetControlOperationRequest#builder()}
     * </p>
     *
     * @param getControlOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetControlOperationRequest.Builder} to create a
     *        request.
     * @return Result of the GetControlOperation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetControlOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetControlOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetControlOperationResponse getControlOperation(
            Consumer<GetControlOperationRequest.Builder> getControlOperationRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return getControlOperation(GetControlOperationRequest.builder().applyMutation(getControlOperationRequest).build());
    }

    /**
     * <p>
     * Retrieve details of an <code>EnabledBaseline</code> resource by specifying its identifier.
     * </p>
     *
     * @param getEnabledBaselineRequest
     * @return Result of the GetEnabledBaseline operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledBaselineResponse getEnabledBaseline(GetEnabledBaselineRequest getEnabledBaselineRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve details of an <code>EnabledBaseline</code> resource by specifying its identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnabledBaselineRequest#builder()}
     * </p>
     *
     * @param getEnabledBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetEnabledBaselineRequest.Builder} to create a
     *        request.
     * @return Result of the GetEnabledBaseline operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledBaselineResponse getEnabledBaseline(Consumer<GetEnabledBaselineRequest.Builder> getEnabledBaselineRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return getEnabledBaseline(GetEnabledBaselineRequest.builder().applyMutation(getEnabledBaselineRequest).build());
    }

    /**
     * <p>
     * Retrieves details about an enabled control. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     *
     * @param getEnabledControlRequest
     * @return Result of the GetEnabledControl operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetEnabledControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetEnabledControl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledControlResponse getEnabledControl(GetEnabledControlRequest getEnabledControlRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an enabled control. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledControlRequest.Builder} avoiding the need
     * to create one manually via {@link GetEnabledControlRequest#builder()}
     * </p>
     *
     * @param getEnabledControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetEnabledControlRequest.Builder} to create a
     *        request.
     * @return Result of the GetEnabledControl operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetEnabledControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetEnabledControl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledControlResponse getEnabledControl(Consumer<GetEnabledControlRequest.Builder> getEnabledControlRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return getEnabledControl(GetEnabledControlRequest.builder().applyMutation(getEnabledControlRequest).build());
    }

    /**
     * <p>
     * Returns details about the landing zone. Displays a message in case of error.
     * </p>
     *
     * @param getLandingZoneRequest
     * @return Result of the GetLandingZone operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetLandingZone" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLandingZoneResponse getLandingZone(GetLandingZoneRequest getLandingZoneRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the landing zone. Displays a message in case of error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLandingZoneRequest.Builder} avoiding the need to
     * create one manually via {@link GetLandingZoneRequest#builder()}
     * </p>
     *
     * @param getLandingZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetLandingZoneRequest.Builder} to create a
     *        request.
     * @return Result of the GetLandingZone operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetLandingZone" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLandingZoneResponse getLandingZone(Consumer<GetLandingZoneRequest.Builder> getLandingZoneRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return getLandingZone(GetLandingZoneRequest.builder().applyMutation(getLandingZoneRequest).build());
    }

    /**
     * <p>
     * Returns the status of the specified landing zone operation. Details for an operation are available for 90 days.
     * </p>
     *
     * @param getLandingZoneOperationRequest
     * @return Result of the GetLandingZoneOperation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetLandingZoneOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetLandingZoneOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLandingZoneOperationResponse getLandingZoneOperation(GetLandingZoneOperationRequest getLandingZoneOperationRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of the specified landing zone operation. Details for an operation are available for 90 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLandingZoneOperationRequest.Builder} avoiding
     * the need to create one manually via {@link GetLandingZoneOperationRequest#builder()}
     * </p>
     *
     * @param getLandingZoneOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.GetLandingZoneOperationRequest.Builder} to
     *        create a request.
     * @return Result of the GetLandingZoneOperation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.GetLandingZoneOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetLandingZoneOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLandingZoneOperationResponse getLandingZoneOperation(
            Consumer<GetLandingZoneOperationRequest.Builder> getLandingZoneOperationRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return getLandingZoneOperation(GetLandingZoneOperationRequest.builder().applyMutation(getLandingZoneOperationRequest)
                .build());
    }

    /**
     * <p>
     * Returns a summary list of all available baselines. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param listBaselinesRequest
     * @return Result of the ListBaselines operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBaselinesResponse listBaselines(ListBaselinesRequest listBaselinesRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a summary list of all available baselines. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBaselinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBaselinesRequest#builder()}
     * </p>
     *
     * @param listBaselinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListBaselinesRequest.Builder} to create a
     *        request.
     * @return Result of the ListBaselines operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBaselinesResponse listBaselines(Consumer<ListBaselinesRequest.Builder> listBaselinesRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return listBaselines(ListBaselinesRequest.builder().applyMutation(listBaselinesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBaselines(software.amazon.awssdk.services.controltower.model.ListBaselinesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListBaselinesIterable responses = client.listBaselinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListBaselinesIterable responses = client
     *             .listBaselinesPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListBaselinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListBaselinesIterable responses = client.listBaselinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBaselines(software.amazon.awssdk.services.controltower.model.ListBaselinesRequest)} operation.</b>
     * </p>
     *
     * @param listBaselinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBaselinesIterable listBaselinesPaginator(ListBaselinesRequest listBaselinesRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return new ListBaselinesIterable(this, listBaselinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBaselines(software.amazon.awssdk.services.controltower.model.ListBaselinesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListBaselinesIterable responses = client.listBaselinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListBaselinesIterable responses = client
     *             .listBaselinesPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListBaselinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListBaselinesIterable responses = client.listBaselinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBaselines(software.amazon.awssdk.services.controltower.model.ListBaselinesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBaselinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBaselinesRequest#builder()}
     * </p>
     *
     * @param listBaselinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListBaselinesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBaselinesIterable listBaselinesPaginator(Consumer<ListBaselinesRequest.Builder> listBaselinesRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return listBaselinesPaginator(ListBaselinesRequest.builder().applyMutation(listBaselinesRequest).build());
    }

    /**
     * <p>
     * Provides a list of operations in progress or queued. For usage examples, see <a href=
     * "https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html#list-control-operations-api-examples"
     * >ListControlOperation examples</a>.
     * </p>
     *
     * @param listControlOperationsRequest
     * @return Result of the ListControlOperations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListControlOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListControlOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlOperationsResponse listControlOperations(ListControlOperationsRequest listControlOperationsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of operations in progress or queued. For usage examples, see <a href=
     * "https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html#list-control-operations-api-examples"
     * >ListControlOperation examples</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListControlOperationsRequest#builder()}
     * </p>
     *
     * @param listControlOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListControlOperationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListControlOperations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListControlOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListControlOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlOperationsResponse listControlOperations(
            Consumer<ListControlOperationsRequest.Builder> listControlOperationsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return listControlOperations(ListControlOperationsRequest.builder().applyMutation(listControlOperationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listControlOperations(software.amazon.awssdk.services.controltower.model.ListControlOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListControlOperationsIterable responses = client.listControlOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListControlOperationsIterable responses = client
     *             .listControlOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListControlOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListControlOperationsIterable responses = client.listControlOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlOperations(software.amazon.awssdk.services.controltower.model.ListControlOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listControlOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListControlOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListControlOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlOperationsIterable listControlOperationsPaginator(ListControlOperationsRequest listControlOperationsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return new ListControlOperationsIterable(this, listControlOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listControlOperations(software.amazon.awssdk.services.controltower.model.ListControlOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListControlOperationsIterable responses = client.listControlOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListControlOperationsIterable responses = client
     *             .listControlOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListControlOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListControlOperationsIterable responses = client.listControlOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listControlOperations(software.amazon.awssdk.services.controltower.model.ListControlOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListControlOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListControlOperationsRequest#builder()}
     * </p>
     *
     * @param listControlOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListControlOperationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListControlOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListControlOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListControlOperationsIterable listControlOperationsPaginator(
            Consumer<ListControlOperationsRequest.Builder> listControlOperationsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return listControlOperationsPaginator(ListControlOperationsRequest.builder().applyMutation(listControlOperationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of summaries describing <code>EnabledBaseline</code> resources. You can filter the list by the
     * corresponding <code>Baseline</code> or <code>Target</code> of the <code>EnabledBaseline</code> resources. For
     * usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param listEnabledBaselinesRequest
     * @return Result of the ListEnabledBaselines operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListEnabledBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledBaselines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledBaselinesResponse listEnabledBaselines(ListEnabledBaselinesRequest listEnabledBaselinesRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of summaries describing <code>EnabledBaseline</code> resources. You can filter the list by the
     * corresponding <code>Baseline</code> or <code>Target</code> of the <code>EnabledBaseline</code> resources. For
     * usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledBaselinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnabledBaselinesRequest#builder()}
     * </p>
     *
     * @param listEnabledBaselinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest.Builder} to create a
     *        request.
     * @return Result of the ListEnabledBaselines operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListEnabledBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledBaselines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledBaselinesResponse listEnabledBaselines(
            Consumer<ListEnabledBaselinesRequest.Builder> listEnabledBaselinesRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return listEnabledBaselines(ListEnabledBaselinesRequest.builder().applyMutation(listEnabledBaselinesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledBaselines(software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesIterable responses = client.listEnabledBaselinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesIterable responses = client
     *             .listEnabledBaselinesPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesIterable responses = client.listEnabledBaselinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledBaselines(software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnabledBaselinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListEnabledBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledBaselines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledBaselinesIterable listEnabledBaselinesPaginator(ListEnabledBaselinesRequest listEnabledBaselinesRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return new ListEnabledBaselinesIterable(this, listEnabledBaselinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledBaselines(software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesIterable responses = client.listEnabledBaselinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesIterable responses = client
     *             .listEnabledBaselinesPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledBaselinesIterable responses = client.listEnabledBaselinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledBaselines(software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledBaselinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnabledBaselinesRequest#builder()}
     * </p>
     *
     * @param listEnabledBaselinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListEnabledBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledBaselines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledBaselinesIterable listEnabledBaselinesPaginator(
            Consumer<ListEnabledBaselinesRequest.Builder> listEnabledBaselinesRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return listEnabledBaselinesPaginator(ListEnabledBaselinesRequest.builder().applyMutation(listEnabledBaselinesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the controls enabled by Amazon Web Services Control Tower on the specified organizational unit and the
     * accounts it contains. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     *
     * @param listEnabledControlsRequest
     * @return Result of the ListEnabledControls operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListEnabledControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledControlsResponse listEnabledControls(ListEnabledControlsRequest listEnabledControlsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the controls enabled by Amazon Web Services Control Tower on the specified organizational unit and the
     * accounts it contains. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledControlsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnabledControlsRequest#builder()}
     * </p>
     *
     * @param listEnabledControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEnabledControls operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListEnabledControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledControlsResponse listEnabledControls(
            Consumer<ListEnabledControlsRequest.Builder> listEnabledControlsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return listEnabledControls(ListEnabledControlsRequest.builder().applyMutation(listEnabledControlsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledControls(software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsIterable responses = client.listEnabledControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsIterable responses = client
     *             .listEnabledControlsPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsIterable responses = client.listEnabledControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledControls(software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnabledControlsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListEnabledControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledControlsIterable listEnabledControlsPaginator(ListEnabledControlsRequest listEnabledControlsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return new ListEnabledControlsIterable(this, listEnabledControlsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledControls(software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsIterable responses = client.listEnabledControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsIterable responses = client
     *             .listEnabledControlsPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListEnabledControlsIterable responses = client.listEnabledControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledControls(software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledControlsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnabledControlsRequest#builder()}
     * </p>
     *
     * @param listEnabledControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListEnabledControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListEnabledControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledControlsIterable listEnabledControlsPaginator(
            Consumer<ListEnabledControlsRequest.Builder> listEnabledControlsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return listEnabledControlsPaginator(ListEnabledControlsRequest.builder().applyMutation(listEnabledControlsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all landing zone operations from the past 90 days. Results are sorted by time, with the most recent
     * operation first.
     * </p>
     *
     * @param listLandingZoneOperationsRequest
     * @return Result of the ListLandingZoneOperations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListLandingZoneOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZoneOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLandingZoneOperationsResponse listLandingZoneOperations(
            ListLandingZoneOperationsRequest listLandingZoneOperationsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all landing zone operations from the past 90 days. Results are sorted by time, with the most recent
     * operation first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLandingZoneOperationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLandingZoneOperationsRequest#builder()}
     * </p>
     *
     * @param listLandingZoneOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListLandingZoneOperations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListLandingZoneOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZoneOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLandingZoneOperationsResponse listLandingZoneOperations(
            Consumer<ListLandingZoneOperationsRequest.Builder> listLandingZoneOperationsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return listLandingZoneOperations(ListLandingZoneOperationsRequest.builder()
                .applyMutation(listLandingZoneOperationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLandingZoneOperations(software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZoneOperationsIterable responses = client.listLandingZoneOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListLandingZoneOperationsIterable responses = client
     *             .listLandingZoneOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZoneOperationsIterable responses = client.listLandingZoneOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLandingZoneOperations(software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLandingZoneOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListLandingZoneOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZoneOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLandingZoneOperationsIterable listLandingZoneOperationsPaginator(
            ListLandingZoneOperationsRequest listLandingZoneOperationsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return new ListLandingZoneOperationsIterable(this, listLandingZoneOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLandingZoneOperations(software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZoneOperationsIterable responses = client.listLandingZoneOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListLandingZoneOperationsIterable responses = client
     *             .listLandingZoneOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZoneOperationsIterable responses = client.listLandingZoneOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLandingZoneOperations(software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLandingZoneOperationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLandingZoneOperationsRequest#builder()}
     * </p>
     *
     * @param listLandingZoneOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListLandingZoneOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZoneOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLandingZoneOperationsIterable listLandingZoneOperationsPaginator(
            Consumer<ListLandingZoneOperationsRequest.Builder> listLandingZoneOperationsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        return listLandingZoneOperationsPaginator(ListLandingZoneOperationsRequest.builder()
                .applyMutation(listLandingZoneOperationsRequest).build());
    }

    /**
     * <p>
     * Returns the landing zone ARN for the landing zone deployed in your managed account. This API also creates an ARN
     * for existing accounts that do not yet have a landing zone ARN.
     * </p>
     * <p>
     * Returns one landing zone ARN.
     * </p>
     *
     * @param listLandingZonesRequest
     * @return Result of the ListLandingZones operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListLandingZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZones" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLandingZonesResponse listLandingZones(ListLandingZonesRequest listLandingZonesRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the landing zone ARN for the landing zone deployed in your managed account. This API also creates an ARN
     * for existing accounts that do not yet have a landing zone ARN.
     * </p>
     * <p>
     * Returns one landing zone ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLandingZonesRequest.Builder} avoiding the need
     * to create one manually via {@link ListLandingZonesRequest#builder()}
     * </p>
     *
     * @param listLandingZonesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest.Builder} to create a
     *        request.
     * @return Result of the ListLandingZones operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListLandingZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZones" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLandingZonesResponse listLandingZones(Consumer<ListLandingZonesRequest.Builder> listLandingZonesRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return listLandingZones(ListLandingZonesRequest.builder().applyMutation(listLandingZonesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLandingZones(software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZonesIterable responses = client.listLandingZonesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListLandingZonesIterable responses = client
     *             .listLandingZonesPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListLandingZonesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZonesIterable responses = client.listLandingZonesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLandingZones(software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLandingZonesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListLandingZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZones" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLandingZonesIterable listLandingZonesPaginator(ListLandingZonesRequest listLandingZonesRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return new ListLandingZonesIterable(this, listLandingZonesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLandingZones(software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZonesIterable responses = client.listLandingZonesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.controltower.paginators.ListLandingZonesIterable responses = client
     *             .listLandingZonesPaginator(request);
     *     for (software.amazon.awssdk.services.controltower.model.ListLandingZonesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.controltower.paginators.ListLandingZonesIterable responses = client.listLandingZonesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLandingZones(software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLandingZonesRequest.Builder} avoiding the need
     * to create one manually via {@link ListLandingZonesRequest#builder()}
     * </p>
     *
     * @param listLandingZonesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListLandingZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListLandingZones" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLandingZonesIterable listLandingZonesPaginator(Consumer<ListLandingZonesRequest.Builder> listLandingZonesRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return listLandingZonesPaginator(ListLandingZonesRequest.builder().applyMutation(listLandingZonesRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags associated with the resource. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags associated with the resource. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, ControlTowerException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Re-enables an <code>EnabledBaseline</code> resource. For example, this API can re-apply the existing
     * <code>Baseline</code> after a new member account is moved to the target OU. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param resetEnabledBaselineRequest
     * @return Result of the ResetEnabledBaseline operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ResetEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ResetEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetEnabledBaselineResponse resetEnabledBaseline(ResetEnabledBaselineRequest resetEnabledBaselineRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Re-enables an <code>EnabledBaseline</code> resource. For example, this API can re-apply the existing
     * <code>Baseline</code> after a new member account is moved to the target OU. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetEnabledBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link ResetEnabledBaselineRequest#builder()}
     * </p>
     *
     * @param resetEnabledBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ResetEnabledBaselineRequest.Builder} to create a
     *        request.
     * @return Result of the ResetEnabledBaseline operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ResetEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ResetEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetEnabledBaselineResponse resetEnabledBaseline(
            Consumer<ResetEnabledBaselineRequest.Builder> resetEnabledBaselineRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return resetEnabledBaseline(ResetEnabledBaselineRequest.builder().applyMutation(resetEnabledBaselineRequest).build());
    }

    /**
     * <p>
     * Resets an enabled control. Does not work for controls implemented with SCPs.
     * </p>
     *
     * @param resetEnabledControlRequest
     * @return Result of the ResetEnabledControl operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ResetEnabledControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ResetEnabledControl"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetEnabledControlResponse resetEnabledControl(ResetEnabledControlRequest resetEnabledControlRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets an enabled control. Does not work for controls implemented with SCPs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetEnabledControlRequest.Builder} avoiding the
     * need to create one manually via {@link ResetEnabledControlRequest#builder()}
     * </p>
     *
     * @param resetEnabledControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ResetEnabledControlRequest.Builder} to create a
     *        request.
     * @return Result of the ResetEnabledControl operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ResetEnabledControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ResetEnabledControl"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetEnabledControlResponse resetEnabledControl(
            Consumer<ResetEnabledControlRequest.Builder> resetEnabledControlRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return resetEnabledControl(ResetEnabledControlRequest.builder().applyMutation(resetEnabledControlRequest).build());
    }

    /**
     * <p>
     * This API call resets a landing zone. It starts an asynchronous operation that resets the landing zone to the
     * parameters specified in the original configuration, which you specified in the manifest file. Nothing in the
     * manifest file's original landing zone configuration is changed during the reset process, by default. This API is
     * not the same as a rollback of a landing zone version, which is not a supported operation.
     * </p>
     *
     * @param resetLandingZoneRequest
     * @return Result of the ResetLandingZone operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ResetLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ResetLandingZone" target="_top">AWS
     *      API Documentation</a>
     */
    default ResetLandingZoneResponse resetLandingZone(ResetLandingZoneRequest resetLandingZoneRequest) throws ConflictException,
            ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API call resets a landing zone. It starts an asynchronous operation that resets the landing zone to the
     * parameters specified in the original configuration, which you specified in the manifest file. Nothing in the
     * manifest file's original landing zone configuration is changed during the reset process, by default. This API is
     * not the same as a rollback of a landing zone version, which is not a supported operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetLandingZoneRequest.Builder} avoiding the need
     * to create one manually via {@link ResetLandingZoneRequest#builder()}
     * </p>
     *
     * @param resetLandingZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.ResetLandingZoneRequest.Builder} to create a
     *        request.
     * @return Result of the ResetLandingZone operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.ResetLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/ResetLandingZone" target="_top">AWS
     *      API Documentation</a>
     */
    default ResetLandingZoneResponse resetLandingZone(Consumer<ResetLandingZoneRequest.Builder> resetLandingZoneRequest)
            throws ConflictException, ValidationException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return resetLandingZone(ResetLandingZoneRequest.builder().applyMutation(resetLandingZoneRequest).build());
    }

    /**
     * <p>
     * Applies tags to a resource. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies tags to a resource. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, ControlTowerException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ControlTowerException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an <code>EnabledBaseline</code> resource's applied parameters or version. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     *
     * @param updateEnabledBaselineRequest
     * @return Result of the UpdateEnabledBaseline operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.UpdateEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEnabledBaselineResponse updateEnabledBaseline(UpdateEnabledBaselineRequest updateEnabledBaselineRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an <code>EnabledBaseline</code> resource's applied parameters or version. For usage examples, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html"> <i>the Amazon Web
     * Services Control Tower User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnabledBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEnabledBaselineRequest#builder()}
     * </p>
     *
     * @param updateEnabledBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.UpdateEnabledBaselineRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateEnabledBaseline operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.UpdateEnabledBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateEnabledBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEnabledBaselineResponse updateEnabledBaseline(
            Consumer<UpdateEnabledBaselineRequest.Builder> updateEnabledBaselineRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return updateEnabledBaseline(UpdateEnabledBaselineRequest.builder().applyMutation(updateEnabledBaselineRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an already enabled control.
     * </p>
     * <p>
     * If the enabled control shows an <code>EnablementStatus</code> of SUCCEEDED, supply parameters that are different
     * from the currently configured parameters. Otherwise, Amazon Web Services Control Tower will not accept the
     * request.
     * </p>
     * <p>
     * If the enabled control shows an <code>EnablementStatus</code> of FAILED, Amazon Web Services Control Tower
     * updates the control to match any valid parameters that you supply.
     * </p>
     * <p>
     * If the <code>DriftSummary</code> status for the control shows as <code>DRIFTED</code>, you cannot call this API.
     * Instead, you can update the control by calling the <code>ResetEnabledControl</code> API. Alternatively, you can
     * call <code>DisableControl</code> and then call <code>EnableControl</code> again. Also, you can run an extending
     * governance operation to repair drift. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     *
     * @param updateEnabledControlRequest
     * @return Result of the UpdateEnabledControl operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.UpdateEnabledControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateEnabledControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEnabledControlResponse updateEnabledControl(UpdateEnabledControlRequest updateEnabledControlRequest)
            throws ConflictException, ValidationException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an already enabled control.
     * </p>
     * <p>
     * If the enabled control shows an <code>EnablementStatus</code> of SUCCEEDED, supply parameters that are different
     * from the currently configured parameters. Otherwise, Amazon Web Services Control Tower will not accept the
     * request.
     * </p>
     * <p>
     * If the enabled control shows an <code>EnablementStatus</code> of FAILED, Amazon Web Services Control Tower
     * updates the control to match any valid parameters that you supply.
     * </p>
     * <p>
     * If the <code>DriftSummary</code> status for the control shows as <code>DRIFTED</code>, you cannot call this API.
     * Instead, you can update the control by calling the <code>ResetEnabledControl</code> API. Alternatively, you can
     * call <code>DisableControl</code> and then call <code>EnableControl</code> again. Also, you can run an extending
     * governance operation to repair drift. For usage examples, see the <a
     * href="https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html">
     * <i>Controls Reference Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnabledControlRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEnabledControlRequest#builder()}
     * </p>
     *
     * @param updateEnabledControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.UpdateEnabledControlRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEnabledControl operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded. See <a
     *         href="https://docs.aws.amazon.com/controltower/latest/userguide/request-an-increase.html">Service
     *         quotas</a>.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.UpdateEnabledControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateEnabledControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEnabledControlResponse updateEnabledControl(
            Consumer<UpdateEnabledControlRequest.Builder> updateEnabledControlRequest) throws ConflictException,
            ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return updateEnabledControl(UpdateEnabledControlRequest.builder().applyMutation(updateEnabledControlRequest).build());
    }

    /**
     * <p>
     * This API call updates the landing zone. It starts an asynchronous operation that updates the landing zone based
     * on the new landing zone version, or on the changed parameters specified in the updated manifest file.
     * </p>
     *
     * @param updateLandingZoneRequest
     * @return Result of the UpdateLandingZone operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.UpdateLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLandingZoneResponse updateLandingZone(UpdateLandingZoneRequest updateLandingZoneRequest)
            throws ConflictException, ValidationException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API call updates the landing zone. It starts an asynchronous operation that updates the landing zone based
     * on the new landing zone version, or on the changed parameters specified in the updated manifest file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLandingZoneRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLandingZoneRequest#builder()}
     * </p>
     *
     * @param updateLandingZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.controltower.model.UpdateLandingZoneRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLandingZone operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting the resource can cause an inconsistent state.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An unexpected error occurred during processing of a request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ControlTowerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ControlTowerClient.UpdateLandingZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/UpdateLandingZone"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLandingZoneResponse updateLandingZone(Consumer<UpdateLandingZoneRequest.Builder> updateLandingZoneRequest)
            throws ConflictException, ValidationException, InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ControlTowerException {
        return updateLandingZone(UpdateLandingZoneRequest.builder().applyMutation(updateLandingZoneRequest).build());
    }

    /**
     * Create a {@link ControlTowerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ControlTowerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ControlTowerClient}.
     */
    static ControlTowerClientBuilder builder() {
        return new DefaultControlTowerClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ControlTowerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
