/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The drift summary of the enabled control.
 * </p>
 * <p>
 * Amazon Web Services Control Tower expects the enabled control configuration to include all supported and governed
 * Regions. If the enabled control differs from the expected configuration, it is defined to be in a state of drift. You
 * can repair this drift by resetting the enabled control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DriftStatusSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DriftStatusSummary.Builder, DriftStatusSummary> {
    private static final SdkField<String> DRIFT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("driftStatus").getter(getter(DriftStatusSummary::driftStatusAsString))
            .setter(setter(Builder::driftStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatus").build()).build();

    private static final SdkField<EnabledControlDriftTypes> TYPES_FIELD = SdkField
            .<EnabledControlDriftTypes> builder(MarshallingType.SDK_POJO).memberName("types")
            .getter(getter(DriftStatusSummary::types)).setter(setter(Builder::types))
            .constructor(EnabledControlDriftTypes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRIFT_STATUS_FIELD,
            TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String driftStatus;

    private final EnabledControlDriftTypes types;

    private DriftStatusSummary(BuilderImpl builder) {
        this.driftStatus = builder.driftStatus;
        this.types = builder.types;
    }

    /**
     * <p>
     * The drift status of the enabled control.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DRIFTED</code>: The <code>enabledControl</code> deployed in this configuration doesn’t match the
     * configuration that Amazon Web Services Control Tower expected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_SYNC</code>: The <code>enabledControl</code> deployed in this configuration matches the configuration
     * that Amazon Web Services Control Tower expected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CHECKING</code>: Amazon Web Services Control Tower does not check drift for this enabled control. Drift
     * is not supported for the control type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN</code>: Amazon Web Services Control Tower is not able to check the drift status for the enabled
     * control.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driftStatus} will
     * return {@link DriftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #driftStatusAsString}.
     * </p>
     * 
     * @return The drift status of the enabled control.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DRIFTED</code>: The <code>enabledControl</code> deployed in this configuration doesn’t match the
     *         configuration that Amazon Web Services Control Tower expected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code>: The <code>enabledControl</code> deployed in this configuration matches the
     *         configuration that Amazon Web Services Control Tower expected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CHECKING</code>: Amazon Web Services Control Tower does not check drift for this enabled
     *         control. Drift is not supported for the control type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN</code>: Amazon Web Services Control Tower is not able to check the drift status for the
     *         enabled control.
     *         </p>
     *         </li>
     * @see DriftStatus
     */
    public final DriftStatus driftStatus() {
        return DriftStatus.fromValue(driftStatus);
    }

    /**
     * <p>
     * The drift status of the enabled control.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DRIFTED</code>: The <code>enabledControl</code> deployed in this configuration doesn’t match the
     * configuration that Amazon Web Services Control Tower expected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_SYNC</code>: The <code>enabledControl</code> deployed in this configuration matches the configuration
     * that Amazon Web Services Control Tower expected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CHECKING</code>: Amazon Web Services Control Tower does not check drift for this enabled control. Drift
     * is not supported for the control type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN</code>: Amazon Web Services Control Tower is not able to check the drift status for the enabled
     * control.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driftStatus} will
     * return {@link DriftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #driftStatusAsString}.
     * </p>
     * 
     * @return The drift status of the enabled control.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DRIFTED</code>: The <code>enabledControl</code> deployed in this configuration doesn’t match the
     *         configuration that Amazon Web Services Control Tower expected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code>: The <code>enabledControl</code> deployed in this configuration matches the
     *         configuration that Amazon Web Services Control Tower expected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CHECKING</code>: Amazon Web Services Control Tower does not check drift for this enabled
     *         control. Drift is not supported for the control type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN</code>: Amazon Web Services Control Tower is not able to check the drift status for the
     *         enabled control.
     *         </p>
     *         </li>
     * @see DriftStatus
     */
    public final String driftStatusAsString() {
        return driftStatus;
    }

    /**
     * <p>
     * An object that categorizes the different types of drift detected for the enabled control.
     * </p>
     * 
     * @return An object that categorizes the different types of drift detected for the enabled control.
     */
    public final EnabledControlDriftTypes types() {
        return types;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(driftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(types());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DriftStatusSummary)) {
            return false;
        }
        DriftStatusSummary other = (DriftStatusSummary) obj;
        return Objects.equals(driftStatusAsString(), other.driftStatusAsString()) && Objects.equals(types(), other.types());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DriftStatusSummary").add("DriftStatus", driftStatusAsString()).add("Types", types()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "driftStatus":
            return Optional.ofNullable(clazz.cast(driftStatusAsString()));
        case "types":
            return Optional.ofNullable(clazz.cast(types()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("driftStatus", DRIFT_STATUS_FIELD);
        map.put("types", TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DriftStatusSummary, T> g) {
        return obj -> g.apply((DriftStatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DriftStatusSummary> {
        /**
         * <p>
         * The drift status of the enabled control.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DRIFTED</code>: The <code>enabledControl</code> deployed in this configuration doesn’t match the
         * configuration that Amazon Web Services Control Tower expected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The <code>enabledControl</code> deployed in this configuration matches the
         * configuration that Amazon Web Services Control Tower expected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKING</code>: Amazon Web Services Control Tower does not check drift for this enabled control.
         * Drift is not supported for the control type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN</code>: Amazon Web Services Control Tower is not able to check the drift status for the enabled
         * control.
         * </p>
         * </li>
         * </ul>
         * 
         * @param driftStatus
         *        The drift status of the enabled control.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DRIFTED</code>: The <code>enabledControl</code> deployed in this configuration doesn’t match the
         *        configuration that Amazon Web Services Control Tower expected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The <code>enabledControl</code> deployed in this configuration matches the
         *        configuration that Amazon Web Services Control Tower expected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKING</code>: Amazon Web Services Control Tower does not check drift for this enabled
         *        control. Drift is not supported for the control type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN</code>: Amazon Web Services Control Tower is not able to check the drift status for the
         *        enabled control.
         *        </p>
         *        </li>
         * @see DriftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DriftStatus
         */
        Builder driftStatus(String driftStatus);

        /**
         * <p>
         * The drift status of the enabled control.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DRIFTED</code>: The <code>enabledControl</code> deployed in this configuration doesn’t match the
         * configuration that Amazon Web Services Control Tower expected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The <code>enabledControl</code> deployed in this configuration matches the
         * configuration that Amazon Web Services Control Tower expected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKING</code>: Amazon Web Services Control Tower does not check drift for this enabled control.
         * Drift is not supported for the control type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN</code>: Amazon Web Services Control Tower is not able to check the drift status for the enabled
         * control.
         * </p>
         * </li>
         * </ul>
         * 
         * @param driftStatus
         *        The drift status of the enabled control.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DRIFTED</code>: The <code>enabledControl</code> deployed in this configuration doesn’t match the
         *        configuration that Amazon Web Services Control Tower expected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The <code>enabledControl</code> deployed in this configuration matches the
         *        configuration that Amazon Web Services Control Tower expected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKING</code>: Amazon Web Services Control Tower does not check drift for this enabled
         *        control. Drift is not supported for the control type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN</code>: Amazon Web Services Control Tower is not able to check the drift status for the
         *        enabled control.
         *        </p>
         *        </li>
         * @see DriftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DriftStatus
         */
        Builder driftStatus(DriftStatus driftStatus);

        /**
         * <p>
         * An object that categorizes the different types of drift detected for the enabled control.
         * </p>
         * 
         * @param types
         *        An object that categorizes the different types of drift detected for the enabled control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(EnabledControlDriftTypes types);

        /**
         * <p>
         * An object that categorizes the different types of drift detected for the enabled control.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnabledControlDriftTypes.Builder}
         * avoiding the need to create one manually via {@link EnabledControlDriftTypes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnabledControlDriftTypes.Builder#build()} is called immediately
         * and its result is passed to {@link #types(EnabledControlDriftTypes)}.
         * 
         * @param types
         *        a consumer that will call methods on {@link EnabledControlDriftTypes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #types(EnabledControlDriftTypes)
         */
        default Builder types(Consumer<EnabledControlDriftTypes.Builder> types) {
            return types(EnabledControlDriftTypes.builder().applyMutation(types).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String driftStatus;

        private EnabledControlDriftTypes types;

        private BuilderImpl() {
        }

        private BuilderImpl(DriftStatusSummary model) {
            driftStatus(model.driftStatus);
            types(model.types);
        }

        public final String getDriftStatus() {
            return driftStatus;
        }

        public final void setDriftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
        }

        @Override
        public final Builder driftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        @Override
        public final Builder driftStatus(DriftStatus driftStatus) {
            this.driftStatus(driftStatus == null ? null : driftStatus.toString());
            return this;
        }

        public final EnabledControlDriftTypes.Builder getTypes() {
            return types != null ? types.toBuilder() : null;
        }

        public final void setTypes(EnabledControlDriftTypes.BuilderImpl types) {
            this.types = types != null ? types.build() : null;
        }

        @Override
        public final Builder types(EnabledControlDriftTypes types) {
            this.types = types;
            return this;
        }

        @Override
        public DriftStatusSummary build() {
            return new DriftStatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
