/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The drift summary of the enabled baseline. Amazon Web Services Control Tower reports inheritance drift when an
 * enabled baseline configuration of a member account is different than the configuration that applies to the OU. Amazon
 * Web Services Control Tower reports this type of drift for a parent or child enabled baseline. One way to repair this
 * drift by resetting the parent enabled baseline, on the OU.
 * </p>
 * <p>
 * For example, you may see this type of drift if you move accounts between OUs, but the accounts are not yet
 * (re-)enrolled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledBaselineDriftStatusSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnabledBaselineDriftStatusSummary.Builder, EnabledBaselineDriftStatusSummary> {
    private static final SdkField<EnabledBaselineDriftTypes> TYPES_FIELD = SdkField
            .<EnabledBaselineDriftTypes> builder(MarshallingType.SDK_POJO).memberName("types")
            .getter(getter(EnabledBaselineDriftStatusSummary::types)).setter(setter(Builder::types))
            .constructor(EnabledBaselineDriftTypes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EnabledBaselineDriftTypes types;

    private EnabledBaselineDriftStatusSummary(BuilderImpl builder) {
        this.types = builder.types;
    }

    /**
     * <p>
     * The types of drift that can be detected for an enabled baseline. Amazon Web Services Control Tower detects
     * inheritance drift on enabled baselines that apply at the OU level.
     * </p>
     * 
     * @return The types of drift that can be detected for an enabled baseline. Amazon Web Services Control Tower
     *         detects inheritance drift on enabled baselines that apply at the OU level.
     */
    public final EnabledBaselineDriftTypes types() {
        return types;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(types());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledBaselineDriftStatusSummary)) {
            return false;
        }
        EnabledBaselineDriftStatusSummary other = (EnabledBaselineDriftStatusSummary) obj;
        return Objects.equals(types(), other.types());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnabledBaselineDriftStatusSummary").add("Types", types()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "types":
            return Optional.ofNullable(clazz.cast(types()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("types", TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnabledBaselineDriftStatusSummary, T> g) {
        return obj -> g.apply((EnabledBaselineDriftStatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnabledBaselineDriftStatusSummary> {
        /**
         * <p>
         * The types of drift that can be detected for an enabled baseline. Amazon Web Services Control Tower detects
         * inheritance drift on enabled baselines that apply at the OU level.
         * </p>
         * 
         * @param types
         *        The types of drift that can be detected for an enabled baseline. Amazon Web Services Control Tower
         *        detects inheritance drift on enabled baselines that apply at the OU level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(EnabledBaselineDriftTypes types);

        /**
         * <p>
         * The types of drift that can be detected for an enabled baseline. Amazon Web Services Control Tower detects
         * inheritance drift on enabled baselines that apply at the OU level.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnabledBaselineDriftTypes.Builder}
         * avoiding the need to create one manually via {@link EnabledBaselineDriftTypes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnabledBaselineDriftTypes.Builder#build()} is called immediately
         * and its result is passed to {@link #types(EnabledBaselineDriftTypes)}.
         * 
         * @param types
         *        a consumer that will call methods on {@link EnabledBaselineDriftTypes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #types(EnabledBaselineDriftTypes)
         */
        default Builder types(Consumer<EnabledBaselineDriftTypes.Builder> types) {
            return types(EnabledBaselineDriftTypes.builder().applyMutation(types).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EnabledBaselineDriftTypes types;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledBaselineDriftStatusSummary model) {
            types(model.types);
        }

        public final EnabledBaselineDriftTypes.Builder getTypes() {
            return types != null ? types.toBuilder() : null;
        }

        public final void setTypes(EnabledBaselineDriftTypes.BuilderImpl types) {
            this.types = types != null ? types.build() : null;
        }

        @Override
        public final Builder types(EnabledBaselineDriftTypes types) {
            this.types = types;
            return this;
        }

        @Override
        public EnabledBaselineDriftStatusSummary build() {
            return new EnabledBaselineDriftStatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
