/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetControlOperationResponse extends ControlTowerResponse implements
        ToCopyableBuilder<GetControlOperationResponse.Builder, GetControlOperationResponse> {
    private static final SdkField<ControlOperation> CONTROL_OPERATION_FIELD = SdkField
            .<ControlOperation> builder(MarshallingType.SDK_POJO).memberName("controlOperation")
            .getter(getter(GetControlOperationResponse::controlOperation)).setter(setter(Builder::controlOperation))
            .constructor(ControlOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlOperation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ControlOperation controlOperation;

    private GetControlOperationResponse(BuilderImpl builder) {
        super(builder);
        this.controlOperation = builder.controlOperation;
    }

    /**
     * <p>
     * An operation performed by the control.
     * </p>
     * 
     * @return An operation performed by the control.
     */
    public final ControlOperation controlOperation() {
        return controlOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetControlOperationResponse)) {
            return false;
        }
        GetControlOperationResponse other = (GetControlOperationResponse) obj;
        return Objects.equals(controlOperation(), other.controlOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetControlOperationResponse").add("ControlOperation", controlOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlOperation":
            return Optional.ofNullable(clazz.cast(controlOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("controlOperation", CONTROL_OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetControlOperationResponse, T> g) {
        return obj -> g.apply((GetControlOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ControlTowerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetControlOperationResponse> {
        /**
         * <p>
         * An operation performed by the control.
         * </p>
         * 
         * @param controlOperation
         *        An operation performed by the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlOperation(ControlOperation controlOperation);

        /**
         * <p>
         * An operation performed by the control.
         * </p>
         * This is a convenience method that creates an instance of the {@link ControlOperation.Builder} avoiding the
         * need to create one manually via {@link ControlOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ControlOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #controlOperation(ControlOperation)}.
         * 
         * @param controlOperation
         *        a consumer that will call methods on {@link ControlOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlOperation(ControlOperation)
         */
        default Builder controlOperation(Consumer<ControlOperation.Builder> controlOperation) {
            return controlOperation(ControlOperation.builder().applyMutation(controlOperation).build());
        }
    }

    static final class BuilderImpl extends ControlTowerResponse.BuilderImpl implements Builder {
        private ControlOperation controlOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetControlOperationResponse model) {
            super(model);
            controlOperation(model.controlOperation);
        }

        public final ControlOperation.Builder getControlOperation() {
            return controlOperation != null ? controlOperation.toBuilder() : null;
        }

        public final void setControlOperation(ControlOperation.BuilderImpl controlOperation) {
            this.controlOperation = controlOperation != null ? controlOperation.build() : null;
        }

        @Override
        public final Builder controlOperation(ControlOperation controlOperation) {
            this.controlOperation = controlOperation;
            return this;
        }

        @Override
        public GetControlOperationResponse build() {
            return new GetControlOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
