/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a landing zone operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LandingZoneOperationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<LandingZoneOperationDetail.Builder, LandingZoneOperationDetail> {
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationType").getter(getter(LandingZoneOperationDetail::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()).build();

    private static final SdkField<String> OPERATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationIdentifier").getter(getter(LandingZoneOperationDetail::operationIdentifier))
            .setter(setter(Builder::operationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(LandingZoneOperationDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(LandingZoneOperationDetail::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(LandingZoneOperationDetail::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(LandingZoneOperationDetail::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_TYPE_FIELD,
            OPERATION_IDENTIFIER_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String operationType;

    private final String operationIdentifier;

    private final String status;

    private final Instant startTime;

    private final Instant endTime;

    private final String statusMessage;

    private LandingZoneOperationDetail(BuilderImpl builder) {
        this.operationType = builder.operationType;
        this.operationIdentifier = builder.operationIdentifier;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The landing zone operation type.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETE</code>: The <code>DeleteLandingZone</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE</code>: The <code>CreateLandingZone</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE</code>: The <code>UpdateLandingZone</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESET</code>: The <code>ResetLandingZone</code> operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link LandingZoneOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The landing zone operation type. </p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETE</code>: The <code>DeleteLandingZone</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE</code>: The <code>CreateLandingZone</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE</code>: The <code>UpdateLandingZone</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESET</code>: The <code>ResetLandingZone</code> operation.
     *         </p>
     *         </li>
     * @see LandingZoneOperationType
     */
    public final LandingZoneOperationType operationType() {
        return LandingZoneOperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The landing zone operation type.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETE</code>: The <code>DeleteLandingZone</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE</code>: The <code>CreateLandingZone</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE</code>: The <code>UpdateLandingZone</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESET</code>: The <code>ResetLandingZone</code> operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link LandingZoneOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The landing zone operation type. </p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETE</code>: The <code>DeleteLandingZone</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE</code>: The <code>CreateLandingZone</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE</code>: The <code>UpdateLandingZone</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESET</code>: The <code>ResetLandingZone</code> operation.
     *         </p>
     *         </li>
     * @see LandingZoneOperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The <code>operationIdentifier</code> of the landing zone operation.
     * </p>
     * 
     * @return The <code>operationIdentifier</code> of the landing zone operation.
     */
    public final String operationIdentifier() {
        return operationIdentifier;
    }

    /**
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The landing zone operation succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>: The landing zone operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The landing zone operation failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LandingZoneOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The landing zone operation succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>: The landing zone operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The landing zone operation failed.
     *         </p>
     *         </li>
     * @see LandingZoneOperationStatus
     */
    public final LandingZoneOperationStatus status() {
        return LandingZoneOperationStatus.fromValue(status);
    }

    /**
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The landing zone operation succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>: The landing zone operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The landing zone operation failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LandingZoneOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The landing zone operation succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>: The landing zone operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The landing zone operation failed.
     *         </p>
     *         </li>
     * @see LandingZoneOperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The landing zone operation start time.
     * </p>
     * 
     * @return The landing zone operation start time.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The landing zone operation end time.
     * </p>
     * 
     * @return The landing zone operation end time.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * If the operation result is FAILED, this string contains a message explaining why the operation failed.
     * </p>
     * 
     * @return If the operation result is FAILED, this string contains a message explaining why the operation failed.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LandingZoneOperationDetail)) {
            return false;
        }
        LandingZoneOperationDetail other = (LandingZoneOperationDetail) obj;
        return Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(operationIdentifier(), other.operationIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LandingZoneOperationDetail").add("OperationType", operationTypeAsString())
                .add("OperationIdentifier", operationIdentifier()).add("Status", statusAsString()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "operationIdentifier":
            return Optional.ofNullable(clazz.cast(operationIdentifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("operationType", OPERATION_TYPE_FIELD);
        map.put("operationIdentifier", OPERATION_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LandingZoneOperationDetail, T> g) {
        return obj -> g.apply((LandingZoneOperationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LandingZoneOperationDetail> {
        /**
         * <p>
         * The landing zone operation type.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE</code>: The <code>DeleteLandingZone</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE</code>: The <code>CreateLandingZone</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE</code>: The <code>UpdateLandingZone</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESET</code>: The <code>ResetLandingZone</code> operation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operationType
         *        The landing zone operation type. </p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE</code>: The <code>DeleteLandingZone</code> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE</code>: The <code>CreateLandingZone</code> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE</code>: The <code>UpdateLandingZone</code> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESET</code>: The <code>ResetLandingZone</code> operation.
         *        </p>
         *        </li>
         * @see LandingZoneOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneOperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The landing zone operation type.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE</code>: The <code>DeleteLandingZone</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE</code>: The <code>CreateLandingZone</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE</code>: The <code>UpdateLandingZone</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESET</code>: The <code>ResetLandingZone</code> operation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operationType
         *        The landing zone operation type. </p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE</code>: The <code>DeleteLandingZone</code> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE</code>: The <code>CreateLandingZone</code> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE</code>: The <code>UpdateLandingZone</code> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESET</code>: The <code>ResetLandingZone</code> operation.
         *        </p>
         *        </li>
         * @see LandingZoneOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneOperationType
         */
        Builder operationType(LandingZoneOperationType operationType);

        /**
         * <p>
         * The <code>operationIdentifier</code> of the landing zone operation.
         * </p>
         * 
         * @param operationIdentifier
         *        The <code>operationIdentifier</code> of the landing zone operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationIdentifier(String operationIdentifier);

        /**
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The landing zone operation succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: The landing zone operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The landing zone operation failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The landing zone operation succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: The landing zone operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The landing zone operation failed.
         *        </p>
         *        </li>
         * @see LandingZoneOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneOperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The landing zone operation succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: The landing zone operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The landing zone operation failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The landing zone operation succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: The landing zone operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The landing zone operation failed.
         *        </p>
         *        </li>
         * @see LandingZoneOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneOperationStatus
         */
        Builder status(LandingZoneOperationStatus status);

        /**
         * <p>
         * The landing zone operation start time.
         * </p>
         * 
         * @param startTime
         *        The landing zone operation start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The landing zone operation end time.
         * </p>
         * 
         * @param endTime
         *        The landing zone operation end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * If the operation result is FAILED, this string contains a message explaining why the operation failed.
         * </p>
         * 
         * @param statusMessage
         *        If the operation result is FAILED, this string contains a message explaining why the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String operationType;

        private String operationIdentifier;

        private String status;

        private Instant startTime;

        private Instant endTime;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(LandingZoneOperationDetail model) {
            operationType(model.operationType);
            operationIdentifier(model.operationIdentifier);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            statusMessage(model.statusMessage);
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(LandingZoneOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final String getOperationIdentifier() {
            return operationIdentifier;
        }

        public final void setOperationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
        }

        @Override
        public final Builder operationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LandingZoneOperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public LandingZoneOperationDetail build() {
            return new LandingZoneOperationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
