/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnabledBaselinesResponse extends ControlTowerResponse implements
        ToCopyableBuilder<ListEnabledBaselinesResponse.Builder, ListEnabledBaselinesResponse> {
    private static final SdkField<List<EnabledBaselineSummary>> ENABLED_BASELINES_FIELD = SdkField
            .<List<EnabledBaselineSummary>> builder(MarshallingType.LIST)
            .memberName("enabledBaselines")
            .getter(getter(ListEnabledBaselinesResponse::enabledBaselines))
            .setter(setter(Builder::enabledBaselines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledBaselines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnabledBaselineSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnabledBaselineSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnabledBaselinesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_BASELINES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EnabledBaselineSummary> enabledBaselines;

    private final String nextToken;

    private ListEnabledBaselinesResponse(BuilderImpl builder) {
        super(builder);
        this.enabledBaselines = builder.enabledBaselines;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledBaselines property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnabledBaselines() {
        return enabledBaselines != null && !(enabledBaselines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Retuens a list of summaries of <code>EnabledBaseline</code> resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledBaselines} method.
     * </p>
     * 
     * @return Retuens a list of summaries of <code>EnabledBaseline</code> resources.
     */
    public final List<EnabledBaselineSummary> enabledBaselines() {
        return enabledBaselines;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledBaselines() ? enabledBaselines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnabledBaselinesResponse)) {
            return false;
        }
        ListEnabledBaselinesResponse other = (ListEnabledBaselinesResponse) obj;
        return hasEnabledBaselines() == other.hasEnabledBaselines()
                && Objects.equals(enabledBaselines(), other.enabledBaselines()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnabledBaselinesResponse")
                .add("EnabledBaselines", hasEnabledBaselines() ? enabledBaselines() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabledBaselines":
            return Optional.ofNullable(clazz.cast(enabledBaselines()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabledBaselines", ENABLED_BASELINES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnabledBaselinesResponse, T> g) {
        return obj -> g.apply((ListEnabledBaselinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ControlTowerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEnabledBaselinesResponse> {
        /**
         * <p>
         * Retuens a list of summaries of <code>EnabledBaseline</code> resources.
         * </p>
         * 
         * @param enabledBaselines
         *        Retuens a list of summaries of <code>EnabledBaseline</code> resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledBaselines(Collection<EnabledBaselineSummary> enabledBaselines);

        /**
         * <p>
         * Retuens a list of summaries of <code>EnabledBaseline</code> resources.
         * </p>
         * 
         * @param enabledBaselines
         *        Retuens a list of summaries of <code>EnabledBaseline</code> resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledBaselines(EnabledBaselineSummary... enabledBaselines);

        /**
         * <p>
         * Retuens a list of summaries of <code>EnabledBaseline</code> resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #enabledBaselines(List<EnabledBaselineSummary>)}.
         * 
         * @param enabledBaselines
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.controltower.model.EnabledBaselineSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enabledBaselines(java.util.Collection<EnabledBaselineSummary>)
         */
        Builder enabledBaselines(Consumer<EnabledBaselineSummary.Builder>... enabledBaselines);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ControlTowerResponse.BuilderImpl implements Builder {
        private List<EnabledBaselineSummary> enabledBaselines = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnabledBaselinesResponse model) {
            super(model);
            enabledBaselines(model.enabledBaselines);
            nextToken(model.nextToken);
        }

        public final List<EnabledBaselineSummary.Builder> getEnabledBaselines() {
            List<EnabledBaselineSummary.Builder> result = EnabledBaselinesCopier.copyToBuilder(this.enabledBaselines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnabledBaselines(Collection<EnabledBaselineSummary.BuilderImpl> enabledBaselines) {
            this.enabledBaselines = EnabledBaselinesCopier.copyFromBuilder(enabledBaselines);
        }

        @Override
        public final Builder enabledBaselines(Collection<EnabledBaselineSummary> enabledBaselines) {
            this.enabledBaselines = EnabledBaselinesCopier.copy(enabledBaselines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledBaselines(EnabledBaselineSummary... enabledBaselines) {
            enabledBaselines(Arrays.asList(enabledBaselines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledBaselines(Consumer<EnabledBaselineSummary.Builder>... enabledBaselines) {
            enabledBaselines(Stream.of(enabledBaselines).map(c -> EnabledBaselineSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnabledBaselinesResponse build() {
            return new ListEnabledBaselinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
