/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLandingZoneRequest extends ControlTowerRequest implements
        ToCopyableBuilder<UpdateLandingZoneRequest.Builder, UpdateLandingZoneRequest> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(UpdateLandingZoneRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Document> MANIFEST_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("manifest").getter(getter(UpdateLandingZoneRequest::manifest)).setter(setter(Builder::manifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifest").build()).build();

    private static final SdkField<List<String>> REMEDIATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("remediationTypes")
            .getter(getter(UpdateLandingZoneRequest::remediationTypesAsStrings))
            .setter(setter(Builder::remediationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANDING_ZONE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("landingZoneIdentifier").getter(getter(UpdateLandingZoneRequest::landingZoneIdentifier))
            .setter(setter(Builder::landingZoneIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("landingZoneIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, MANIFEST_FIELD,
            REMEDIATION_TYPES_FIELD, LANDING_ZONE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String version;

    private final Document manifest;

    private final List<String> remediationTypes;

    private final String landingZoneIdentifier;

    private UpdateLandingZoneRequest(BuilderImpl builder) {
        super(builder);
        this.version = builder.version;
        this.manifest = builder.manifest;
        this.remediationTypes = builder.remediationTypes;
        this.landingZoneIdentifier = builder.landingZoneIdentifier;
    }

    /**
     * <p>
     * The landing zone version, for example, 3.2.
     * </p>
     * 
     * @return The landing zone version, for example, 3.2.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The manifest file (JSON) is a text file that describes your Amazon Web Services resources. For an example, review
     * <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch your landing zone</a>.
     * The example manifest file contains each of the available parameters. The schema for the landing zone's JSON
     * manifest file is not published, by design.
     * </p>
     * 
     * @return The manifest file (JSON) is a text file that describes your Amazon Web Services resources. For an
     *         example, review <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch
     *         your landing zone</a>. The example manifest file contains each of the available parameters. The schema
     *         for the landing zone's JSON manifest file is not published, by design.
     */
    public final Document manifest() {
        return manifest;
    }

    /**
     * <p>
     * Specifies the types of remediation actions to apply when updating the landing zone configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemediationTypes} method.
     * </p>
     * 
     * @return Specifies the types of remediation actions to apply when updating the landing zone configuration.
     */
    public final List<RemediationType> remediationTypes() {
        return RemediationTypesCopier.copyStringToEnum(remediationTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the RemediationTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemediationTypes() {
        return remediationTypes != null && !(remediationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the types of remediation actions to apply when updating the landing zone configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemediationTypes} method.
     * </p>
     * 
     * @return Specifies the types of remediation actions to apply when updating the landing zone configuration.
     */
    public final List<String> remediationTypesAsStrings() {
        return remediationTypes;
    }

    /**
     * <p>
     * The unique identifier of the landing zone.
     * </p>
     * 
     * @return The unique identifier of the landing zone.
     */
    public final String landingZoneIdentifier() {
        return landingZoneIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(manifest());
        hashCode = 31 * hashCode + Objects.hashCode(hasRemediationTypes() ? remediationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(landingZoneIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLandingZoneRequest)) {
            return false;
        }
        UpdateLandingZoneRequest other = (UpdateLandingZoneRequest) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(manifest(), other.manifest())
                && hasRemediationTypes() == other.hasRemediationTypes()
                && Objects.equals(remediationTypesAsStrings(), other.remediationTypesAsStrings())
                && Objects.equals(landingZoneIdentifier(), other.landingZoneIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLandingZoneRequest").add("Version", version()).add("Manifest", manifest())
                .add("RemediationTypes", hasRemediationTypes() ? remediationTypesAsStrings() : null)
                .add("LandingZoneIdentifier", landingZoneIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "manifest":
            return Optional.ofNullable(clazz.cast(manifest()));
        case "remediationTypes":
            return Optional.ofNullable(clazz.cast(remediationTypesAsStrings()));
        case "landingZoneIdentifier":
            return Optional.ofNullable(clazz.cast(landingZoneIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("version", VERSION_FIELD);
        map.put("manifest", MANIFEST_FIELD);
        map.put("remediationTypes", REMEDIATION_TYPES_FIELD);
        map.put("landingZoneIdentifier", LANDING_ZONE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLandingZoneRequest, T> g) {
        return obj -> g.apply((UpdateLandingZoneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLandingZoneRequest> {
        /**
         * <p>
         * The landing zone version, for example, 3.2.
         * </p>
         * 
         * @param version
         *        The landing zone version, for example, 3.2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The manifest file (JSON) is a text file that describes your Amazon Web Services resources. For an example,
         * review <a href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch your landing
         * zone</a>. The example manifest file contains each of the available parameters. The schema for the landing
         * zone's JSON manifest file is not published, by design.
         * </p>
         * 
         * @param manifest
         *        The manifest file (JSON) is a text file that describes your Amazon Web Services resources. For an
         *        example, review <a
         *        href="https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch">Launch your landing
         *        zone</a>. The example manifest file contains each of the available parameters. The schema for the
         *        landing zone's JSON manifest file is not published, by design.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifest(Document manifest);

        /**
         * <p>
         * Specifies the types of remediation actions to apply when updating the landing zone configuration.
         * </p>
         * 
         * @param remediationTypes
         *        Specifies the types of remediation actions to apply when updating the landing zone configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationTypesWithStrings(Collection<String> remediationTypes);

        /**
         * <p>
         * Specifies the types of remediation actions to apply when updating the landing zone configuration.
         * </p>
         * 
         * @param remediationTypes
         *        Specifies the types of remediation actions to apply when updating the landing zone configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationTypesWithStrings(String... remediationTypes);

        /**
         * <p>
         * Specifies the types of remediation actions to apply when updating the landing zone configuration.
         * </p>
         * 
         * @param remediationTypes
         *        Specifies the types of remediation actions to apply when updating the landing zone configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationTypes(Collection<RemediationType> remediationTypes);

        /**
         * <p>
         * Specifies the types of remediation actions to apply when updating the landing zone configuration.
         * </p>
         * 
         * @param remediationTypes
         *        Specifies the types of remediation actions to apply when updating the landing zone configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationTypes(RemediationType... remediationTypes);

        /**
         * <p>
         * The unique identifier of the landing zone.
         * </p>
         * 
         * @param landingZoneIdentifier
         *        The unique identifier of the landing zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landingZoneIdentifier(String landingZoneIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private String version;

        private Document manifest;

        private List<String> remediationTypes = DefaultSdkAutoConstructList.getInstance();

        private String landingZoneIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLandingZoneRequest model) {
            super(model);
            version(model.version);
            manifest(model.manifest);
            remediationTypesWithStrings(model.remediationTypes);
            landingZoneIdentifier(model.landingZoneIdentifier);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Document getManifest() {
            return manifest;
        }

        public final void setManifest(Document manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(Document manifest) {
            this.manifest = manifest;
            return this;
        }

        public final Collection<String> getRemediationTypes() {
            if (remediationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return remediationTypes;
        }

        public final void setRemediationTypes(Collection<String> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copy(remediationTypes);
        }

        @Override
        public final Builder remediationTypesWithStrings(Collection<String> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copy(remediationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationTypesWithStrings(String... remediationTypes) {
            remediationTypesWithStrings(Arrays.asList(remediationTypes));
            return this;
        }

        @Override
        public final Builder remediationTypes(Collection<RemediationType> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copyEnumToString(remediationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationTypes(RemediationType... remediationTypes) {
            remediationTypes(Arrays.asList(remediationTypes));
            return this;
        }

        public final String getLandingZoneIdentifier() {
            return landingZoneIdentifier;
        }

        public final void setLandingZoneIdentifier(String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
        }

        @Override
        public final Builder landingZoneIdentifier(String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLandingZoneRequest build() {
            return new UpdateLandingZoneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
