/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableControlRequest extends ControlTowerRequest implements
        ToCopyableBuilder<EnableControlRequest.Builder, EnableControlRequest> {
    private static final SdkField<String> CONTROL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlIdentifier").getter(getter(EnableControlRequest::controlIdentifier))
            .setter(setter(Builder::controlIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifier").build()).build();

    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetIdentifier").getter(getter(EnableControlRequest::targetIdentifier))
            .setter(setter(Builder::targetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(EnableControlRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<EnabledControlParameter>> PARAMETERS_FIELD = SdkField
            .<List<EnabledControlParameter>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(EnableControlRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnabledControlParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnabledControlParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_IDENTIFIER_FIELD,
            TARGET_IDENTIFIER_FIELD, TAGS_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String controlIdentifier;

    private final String targetIdentifier;

    private final Map<String, String> tags;

    private final List<EnabledControlParameter> parameters;

    private EnableControlRequest(BuilderImpl builder) {
        super(builder);
        this.controlIdentifier = builder.controlIdentifier;
        this.targetIdentifier = builder.targetIdentifier;
        this.tags = builder.tags;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The ARN of the control. Only <b>Strongly recommended</b> and <b>Elective</b> controls are permitted, with the
     * exception of the <b>Region deny</b> control. For information on how to find the <code>controlIdentifier</code>,
     * see <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
     * </p>
     * 
     * @return The ARN of the control. Only <b>Strongly recommended</b> and <b>Elective</b> controls are permitted, with
     *         the exception of the <b>Region deny</b> control. For information on how to find the
     *         <code>controlIdentifier</code>, see <a
     *         href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
     */
    public final String controlIdentifier() {
        return controlIdentifier;
    }

    /**
     * <p>
     * The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see <a
     * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
     * </p>
     * 
     * @return The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see
     *         <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
     *         page</a>.
     */
    public final String targetIdentifier() {
        return targetIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to be applied to the <code>EnabledControl</code> resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be applied to the <code>EnabledControl</code> resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of input parameter values, which are specified to configure the control when you enable it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of input parameter values, which are specified to configure the control when you enable it.
     */
    public final List<EnabledControlParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableControlRequest)) {
            return false;
        }
        EnableControlRequest other = (EnableControlRequest) obj;
        return Objects.equals(controlIdentifier(), other.controlIdentifier())
                && Objects.equals(targetIdentifier(), other.targetIdentifier()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableControlRequest").add("ControlIdentifier", controlIdentifier())
                .add("TargetIdentifier", targetIdentifier()).add("Tags", hasTags() ? tags() : null)
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlIdentifier":
            return Optional.ofNullable(clazz.cast(controlIdentifier()));
        case "targetIdentifier":
            return Optional.ofNullable(clazz.cast(targetIdentifier()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("controlIdentifier", CONTROL_IDENTIFIER_FIELD);
        map.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableControlRequest, T> g) {
        return obj -> g.apply((EnableControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ControlTowerRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableControlRequest> {
        /**
         * <p>
         * The ARN of the control. Only <b>Strongly recommended</b> and <b>Elective</b> controls are permitted, with the
         * exception of the <b>Region deny</b> control. For information on how to find the
         * <code>controlIdentifier</code>, see <a
         * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
         * </p>
         * 
         * @param controlIdentifier
         *        The ARN of the control. Only <b>Strongly recommended</b> and <b>Elective</b> controls are permitted,
         *        with the exception of the <b>Region deny</b> control. For information on how to find the
         *        <code>controlIdentifier</code>, see <a
         *        href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
         *        page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlIdentifier(String controlIdentifier);

        /**
         * <p>
         * The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>, see <a
         * href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview page</a>.
         * </p>
         * 
         * @param targetIdentifier
         *        The ARN of the organizational unit. For information on how to find the <code>targetIdentifier</code>,
         *        see <a href="https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html">the overview
         *        page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifier(String targetIdentifier);

        /**
         * <p>
         * Tags to be applied to the <code>EnabledControl</code> resource.
         * </p>
         * 
         * @param tags
         *        Tags to be applied to the <code>EnabledControl</code> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of input parameter values, which are specified to configure the control when you enable it.
         * </p>
         * 
         * @param parameters
         *        A list of input parameter values, which are specified to configure the control when you enable it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<EnabledControlParameter> parameters);

        /**
         * <p>
         * A list of input parameter values, which are specified to configure the control when you enable it.
         * </p>
         * 
         * @param parameters
         *        A list of input parameter values, which are specified to configure the control when you enable it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(EnabledControlParameter... parameters);

        /**
         * <p>
         * A list of input parameter values, which are specified to configure the control when you enable it.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.controltower.model.EnabledControlParameter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.controltower.model.EnabledControlParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.controltower.model.EnabledControlParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<EnabledControlParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.controltower.model.EnabledControlParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<EnabledControlParameter>)
         */
        Builder parameters(Consumer<EnabledControlParameter.Builder>... parameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlTowerRequest.BuilderImpl implements Builder {
        private String controlIdentifier;

        private String targetIdentifier;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<EnabledControlParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableControlRequest model) {
            super(model);
            controlIdentifier(model.controlIdentifier);
            targetIdentifier(model.targetIdentifier);
            tags(model.tags);
            parameters(model.parameters);
        }

        public final String getControlIdentifier() {
            return controlIdentifier;
        }

        public final void setControlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
        }

        @Override
        public final Builder controlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
            return this;
        }

        public final String getTargetIdentifier() {
            return targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<EnabledControlParameter.Builder> getParameters() {
            List<EnabledControlParameter.Builder> result = EnabledControlParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<EnabledControlParameter.BuilderImpl> parameters) {
            this.parameters = EnabledControlParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<EnabledControlParameter> parameters) {
            this.parameters = EnabledControlParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(EnabledControlParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<EnabledControlParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> EnabledControlParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableControlRequest build() {
            return new EnableControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
