/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The types of drift that can be detected for an enabled baseline.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Amazon Web Services Control Tower detects inheritance drift on the enabled baselines that target OUs:
 * <code>AWSControlTowerBaseline</code> and <code>BackupBaseline</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon Web Services Control Tower does not detect drift on the baselines that apply to your landing zone:
 * <code>IdentityCenterBaseline</code>, <code>AuditBaseline</code>, <code>LogArchiveBaseline</code>,
 * <code>BackupCentralVaultBaseline</code>, or <code>BackupAdminBaseline</code>. For more information, see <a
 * href="https://docs.aws.amazon.com/controltower/latest/userguide/types-of-baselines.html">Types of baselines</a>.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Baselines enabled on an OU are inherited by its member accounts as child <code>EnabledBaseline</code> resources. The
 * baseline on the OU serves as the parent <code>EnabledBaseline</code>, which governs the configuration of each child
 * <code>EnabledBaseline</code>.
 * </p>
 * <p>
 * If the baseline configuration of a member account in an OU does not match the configuration of the parent OU, the
 * parent and child baseline is in a state of inheritance drift. This drift could occur in the
 * <code>AWSControlTowerBaseline</code> or the <code>BackupBaseline</code> related to that account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledBaselineDriftTypes implements SdkPojo, Serializable,
        ToCopyableBuilder<EnabledBaselineDriftTypes.Builder, EnabledBaselineDriftTypes> {
    private static final SdkField<EnabledBaselineInheritanceDrift> INHERITANCE_FIELD = SdkField
            .<EnabledBaselineInheritanceDrift> builder(MarshallingType.SDK_POJO).memberName("inheritance")
            .getter(getter(EnabledBaselineDriftTypes::inheritance)).setter(setter(Builder::inheritance))
            .constructor(EnabledBaselineInheritanceDrift::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inheritance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INHERITANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EnabledBaselineInheritanceDrift inheritance;

    private EnabledBaselineDriftTypes(BuilderImpl builder) {
        this.inheritance = builder.inheritance;
    }

    /**
     * <p>
     * At least one account within the target OU does not match the baseline configuration defined on that OU. An
     * account is in inheritance drift when it does not match the configuration of a parent OU, possibly a new parent
     * OU, if the account is moved.
     * </p>
     * 
     * @return At least one account within the target OU does not match the baseline configuration defined on that OU.
     *         An account is in inheritance drift when it does not match the configuration of a parent OU, possibly a
     *         new parent OU, if the account is moved.
     */
    public final EnabledBaselineInheritanceDrift inheritance() {
        return inheritance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inheritance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledBaselineDriftTypes)) {
            return false;
        }
        EnabledBaselineDriftTypes other = (EnabledBaselineDriftTypes) obj;
        return Objects.equals(inheritance(), other.inheritance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnabledBaselineDriftTypes").add("Inheritance", inheritance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inheritance":
            return Optional.ofNullable(clazz.cast(inheritance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inheritance", INHERITANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnabledBaselineDriftTypes, T> g) {
        return obj -> g.apply((EnabledBaselineDriftTypes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnabledBaselineDriftTypes> {
        /**
         * <p>
         * At least one account within the target OU does not match the baseline configuration defined on that OU. An
         * account is in inheritance drift when it does not match the configuration of a parent OU, possibly a new
         * parent OU, if the account is moved.
         * </p>
         * 
         * @param inheritance
         *        At least one account within the target OU does not match the baseline configuration defined on that
         *        OU. An account is in inheritance drift when it does not match the configuration of a parent OU,
         *        possibly a new parent OU, if the account is moved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inheritance(EnabledBaselineInheritanceDrift inheritance);

        /**
         * <p>
         * At least one account within the target OU does not match the baseline configuration defined on that OU. An
         * account is in inheritance drift when it does not match the configuration of a parent OU, possibly a new
         * parent OU, if the account is moved.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnabledBaselineInheritanceDrift.Builder}
         * avoiding the need to create one manually via {@link EnabledBaselineInheritanceDrift#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnabledBaselineInheritanceDrift.Builder#build()} is called
         * immediately and its result is passed to {@link #inheritance(EnabledBaselineInheritanceDrift)}.
         * 
         * @param inheritance
         *        a consumer that will call methods on {@link EnabledBaselineInheritanceDrift.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inheritance(EnabledBaselineInheritanceDrift)
         */
        default Builder inheritance(Consumer<EnabledBaselineInheritanceDrift.Builder> inheritance) {
            return inheritance(EnabledBaselineInheritanceDrift.builder().applyMutation(inheritance).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EnabledBaselineInheritanceDrift inheritance;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledBaselineDriftTypes model) {
            inheritance(model.inheritance);
        }

        public final EnabledBaselineInheritanceDrift.Builder getInheritance() {
            return inheritance != null ? inheritance.toBuilder() : null;
        }

        public final void setInheritance(EnabledBaselineInheritanceDrift.BuilderImpl inheritance) {
            this.inheritance = inheritance != null ? inheritance.build() : null;
        }

        @Override
        public final Builder inheritance(EnabledBaselineInheritanceDrift inheritance) {
            this.inheritance = inheritance;
            return this;
        }

        @Override
        public EnabledBaselineDriftTypes build() {
            return new EnabledBaselineDriftTypes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
