/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the various categories of drift that can occur for an enabled control resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledControlDriftTypes implements SdkPojo, Serializable,
        ToCopyableBuilder<EnabledControlDriftTypes.Builder, EnabledControlDriftTypes> {
    private static final SdkField<EnabledControlInheritanceDrift> INHERITANCE_FIELD = SdkField
            .<EnabledControlInheritanceDrift> builder(MarshallingType.SDK_POJO).memberName("inheritance")
            .getter(getter(EnabledControlDriftTypes::inheritance)).setter(setter(Builder::inheritance))
            .constructor(EnabledControlInheritanceDrift::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inheritance").build()).build();

    private static final SdkField<EnabledControlResourceDrift> RESOURCE_FIELD = SdkField
            .<EnabledControlResourceDrift> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(EnabledControlDriftTypes::resource)).setter(setter(Builder::resource))
            .constructor(EnabledControlResourceDrift::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INHERITANCE_FIELD,
            RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EnabledControlInheritanceDrift inheritance;

    private final EnabledControlResourceDrift resource;

    private EnabledControlDriftTypes(BuilderImpl builder) {
        this.inheritance = builder.inheritance;
        this.resource = builder.resource;
    }

    /**
     * <p>
     * Indicates drift related to inheritance configuration between parent and child controls.
     * </p>
     * 
     * @return Indicates drift related to inheritance configuration between parent and child controls.
     */
    public final EnabledControlInheritanceDrift inheritance() {
        return inheritance;
    }

    /**
     * <p>
     * Indicates drift related to the underlying Amazon Web Services resources managed by the control.
     * </p>
     * 
     * @return Indicates drift related to the underlying Amazon Web Services resources managed by the control.
     */
    public final EnabledControlResourceDrift resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inheritance());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledControlDriftTypes)) {
            return false;
        }
        EnabledControlDriftTypes other = (EnabledControlDriftTypes) obj;
        return Objects.equals(inheritance(), other.inheritance()) && Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnabledControlDriftTypes").add("Inheritance", inheritance()).add("Resource", resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inheritance":
            return Optional.ofNullable(clazz.cast(inheritance()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inheritance", INHERITANCE_FIELD);
        map.put("resource", RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnabledControlDriftTypes, T> g) {
        return obj -> g.apply((EnabledControlDriftTypes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnabledControlDriftTypes> {
        /**
         * <p>
         * Indicates drift related to inheritance configuration between parent and child controls.
         * </p>
         * 
         * @param inheritance
         *        Indicates drift related to inheritance configuration between parent and child controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inheritance(EnabledControlInheritanceDrift inheritance);

        /**
         * <p>
         * Indicates drift related to inheritance configuration between parent and child controls.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnabledControlInheritanceDrift.Builder}
         * avoiding the need to create one manually via {@link EnabledControlInheritanceDrift#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnabledControlInheritanceDrift.Builder#build()} is called
         * immediately and its result is passed to {@link #inheritance(EnabledControlInheritanceDrift)}.
         * 
         * @param inheritance
         *        a consumer that will call methods on {@link EnabledControlInheritanceDrift.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inheritance(EnabledControlInheritanceDrift)
         */
        default Builder inheritance(Consumer<EnabledControlInheritanceDrift.Builder> inheritance) {
            return inheritance(EnabledControlInheritanceDrift.builder().applyMutation(inheritance).build());
        }

        /**
         * <p>
         * Indicates drift related to the underlying Amazon Web Services resources managed by the control.
         * </p>
         * 
         * @param resource
         *        Indicates drift related to the underlying Amazon Web Services resources managed by the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(EnabledControlResourceDrift resource);

        /**
         * <p>
         * Indicates drift related to the underlying Amazon Web Services resources managed by the control.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnabledControlResourceDrift.Builder}
         * avoiding the need to create one manually via {@link EnabledControlResourceDrift#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnabledControlResourceDrift.Builder#build()} is called
         * immediately and its result is passed to {@link #resource(EnabledControlResourceDrift)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link EnabledControlResourceDrift.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(EnabledControlResourceDrift)
         */
        default Builder resource(Consumer<EnabledControlResourceDrift.Builder> resource) {
            return resource(EnabledControlResourceDrift.builder().applyMutation(resource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EnabledControlInheritanceDrift inheritance;

        private EnabledControlResourceDrift resource;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledControlDriftTypes model) {
            inheritance(model.inheritance);
            resource(model.resource);
        }

        public final EnabledControlInheritanceDrift.Builder getInheritance() {
            return inheritance != null ? inheritance.toBuilder() : null;
        }

        public final void setInheritance(EnabledControlInheritanceDrift.BuilderImpl inheritance) {
            this.inheritance = inheritance != null ? inheritance.build() : null;
        }

        @Override
        public final Builder inheritance(EnabledControlInheritanceDrift inheritance) {
            this.inheritance = inheritance;
            return this;
        }

        public final EnabledControlResourceDrift.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(EnabledControlResourceDrift.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(EnabledControlResourceDrift resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public EnabledControlDriftTypes build() {
            return new EnabledControlDriftTypes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
