/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the landing zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LandingZoneDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<LandingZoneDetail.Builder, LandingZoneDetail> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(LandingZoneDetail::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Document> MANIFEST_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("manifest").getter(getter(LandingZoneDetail::manifest)).setter(setter(Builder::manifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifest").build()).build();

    private static final SdkField<List<String>> REMEDIATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("remediationTypes")
            .getter(getter(LandingZoneDetail::remediationTypesAsStrings))
            .setter(setter(Builder::remediationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(LandingZoneDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(LandingZoneDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> LATEST_AVAILABLE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestAvailableVersion").getter(getter(LandingZoneDetail::latestAvailableVersion))
            .setter(setter(Builder::latestAvailableVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAvailableVersion").build())
            .build();

    private static final SdkField<LandingZoneDriftStatusSummary> DRIFT_STATUS_FIELD = SdkField
            .<LandingZoneDriftStatusSummary> builder(MarshallingType.SDK_POJO).memberName("driftStatus")
            .getter(getter(LandingZoneDetail::driftStatus)).setter(setter(Builder::driftStatus))
            .constructor(LandingZoneDriftStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, MANIFEST_FIELD,
            REMEDIATION_TYPES_FIELD, ARN_FIELD, STATUS_FIELD, LATEST_AVAILABLE_VERSION_FIELD, DRIFT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String version;

    private final Document manifest;

    private final List<String> remediationTypes;

    private final String arn;

    private final String status;

    private final String latestAvailableVersion;

    private final LandingZoneDriftStatusSummary driftStatus;

    private LandingZoneDetail(BuilderImpl builder) {
        this.version = builder.version;
        this.manifest = builder.manifest;
        this.remediationTypes = builder.remediationTypes;
        this.arn = builder.arn;
        this.status = builder.status;
        this.latestAvailableVersion = builder.latestAvailableVersion;
        this.driftStatus = builder.driftStatus;
    }

    /**
     * <p>
     * The landing zone's current deployed version.
     * </p>
     * 
     * @return The landing zone's current deployed version.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The landing zone manifest JSON text file that specifies the landing zone configurations.
     * </p>
     * 
     * @return The landing zone manifest JSON text file that specifies the landing zone configurations.
     */
    public final Document manifest() {
        return manifest;
    }

    /**
     * <p>
     * The types of remediation actions configured for the landing zone, such as automatic drift correction or
     * compliance enforcement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemediationTypes} method.
     * </p>
     * 
     * @return The types of remediation actions configured for the landing zone, such as automatic drift correction or
     *         compliance enforcement.
     */
    public final List<RemediationType> remediationTypes() {
        return RemediationTypesCopier.copyStringToEnum(remediationTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the RemediationTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemediationTypes() {
        return remediationTypes != null && !(remediationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of remediation actions configured for the landing zone, such as automatic drift correction or
     * compliance enforcement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemediationTypes} method.
     * </p>
     * 
     * @return The types of remediation actions configured for the landing zone, such as automatic drift correction or
     *         compliance enforcement.
     */
    public final List<String> remediationTypesAsStrings() {
        return remediationTypes;
    }

    /**
     * <p>
     * The ARN of the landing zone.
     * </p>
     * 
     * @return The ARN of the landing zone.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The landing zone deployment status. One of <code>ACTIVE</code>, <code>PROCESSING</code>, <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LandingZoneStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The landing zone deployment status. One of <code>ACTIVE</code>, <code>PROCESSING</code>,
     *         <code>FAILED</code>.
     * @see LandingZoneStatus
     */
    public final LandingZoneStatus status() {
        return LandingZoneStatus.fromValue(status);
    }

    /**
     * <p>
     * The landing zone deployment status. One of <code>ACTIVE</code>, <code>PROCESSING</code>, <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LandingZoneStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The landing zone deployment status. One of <code>ACTIVE</code>, <code>PROCESSING</code>,
     *         <code>FAILED</code>.
     * @see LandingZoneStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The latest available version of the landing zone.
     * </p>
     * 
     * @return The latest available version of the landing zone.
     */
    public final String latestAvailableVersion() {
        return latestAvailableVersion;
    }

    /**
     * <p>
     * The drift status of the landing zone.
     * </p>
     * 
     * @return The drift status of the landing zone.
     */
    public final LandingZoneDriftStatusSummary driftStatus() {
        return driftStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(manifest());
        hashCode = 31 * hashCode + Objects.hashCode(hasRemediationTypes() ? remediationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestAvailableVersion());
        hashCode = 31 * hashCode + Objects.hashCode(driftStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LandingZoneDetail)) {
            return false;
        }
        LandingZoneDetail other = (LandingZoneDetail) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(manifest(), other.manifest())
                && hasRemediationTypes() == other.hasRemediationTypes()
                && Objects.equals(remediationTypesAsStrings(), other.remediationTypesAsStrings())
                && Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(latestAvailableVersion(), other.latestAvailableVersion())
                && Objects.equals(driftStatus(), other.driftStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LandingZoneDetail").add("Version", version()).add("Manifest", manifest())
                .add("RemediationTypes", hasRemediationTypes() ? remediationTypesAsStrings() : null).add("Arn", arn())
                .add("Status", statusAsString()).add("LatestAvailableVersion", latestAvailableVersion())
                .add("DriftStatus", driftStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "manifest":
            return Optional.ofNullable(clazz.cast(manifest()));
        case "remediationTypes":
            return Optional.ofNullable(clazz.cast(remediationTypesAsStrings()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "latestAvailableVersion":
            return Optional.ofNullable(clazz.cast(latestAvailableVersion()));
        case "driftStatus":
            return Optional.ofNullable(clazz.cast(driftStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("version", VERSION_FIELD);
        map.put("manifest", MANIFEST_FIELD);
        map.put("remediationTypes", REMEDIATION_TYPES_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("latestAvailableVersion", LATEST_AVAILABLE_VERSION_FIELD);
        map.put("driftStatus", DRIFT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LandingZoneDetail, T> g) {
        return obj -> g.apply((LandingZoneDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LandingZoneDetail> {
        /**
         * <p>
         * The landing zone's current deployed version.
         * </p>
         * 
         * @param version
         *        The landing zone's current deployed version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The landing zone manifest JSON text file that specifies the landing zone configurations.
         * </p>
         * 
         * @param manifest
         *        The landing zone manifest JSON text file that specifies the landing zone configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifest(Document manifest);

        /**
         * <p>
         * The types of remediation actions configured for the landing zone, such as automatic drift correction or
         * compliance enforcement.
         * </p>
         * 
         * @param remediationTypes
         *        The types of remediation actions configured for the landing zone, such as automatic drift correction
         *        or compliance enforcement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationTypesWithStrings(Collection<String> remediationTypes);

        /**
         * <p>
         * The types of remediation actions configured for the landing zone, such as automatic drift correction or
         * compliance enforcement.
         * </p>
         * 
         * @param remediationTypes
         *        The types of remediation actions configured for the landing zone, such as automatic drift correction
         *        or compliance enforcement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationTypesWithStrings(String... remediationTypes);

        /**
         * <p>
         * The types of remediation actions configured for the landing zone, such as automatic drift correction or
         * compliance enforcement.
         * </p>
         * 
         * @param remediationTypes
         *        The types of remediation actions configured for the landing zone, such as automatic drift correction
         *        or compliance enforcement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationTypes(Collection<RemediationType> remediationTypes);

        /**
         * <p>
         * The types of remediation actions configured for the landing zone, such as automatic drift correction or
         * compliance enforcement.
         * </p>
         * 
         * @param remediationTypes
         *        The types of remediation actions configured for the landing zone, such as automatic drift correction
         *        or compliance enforcement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationTypes(RemediationType... remediationTypes);

        /**
         * <p>
         * The ARN of the landing zone.
         * </p>
         * 
         * @param arn
         *        The ARN of the landing zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The landing zone deployment status. One of <code>ACTIVE</code>, <code>PROCESSING</code>, <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The landing zone deployment status. One of <code>ACTIVE</code>, <code>PROCESSING</code>,
         *        <code>FAILED</code>.
         * @see LandingZoneStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The landing zone deployment status. One of <code>ACTIVE</code>, <code>PROCESSING</code>, <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The landing zone deployment status. One of <code>ACTIVE</code>, <code>PROCESSING</code>,
         *        <code>FAILED</code>.
         * @see LandingZoneStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandingZoneStatus
         */
        Builder status(LandingZoneStatus status);

        /**
         * <p>
         * The latest available version of the landing zone.
         * </p>
         * 
         * @param latestAvailableVersion
         *        The latest available version of the landing zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestAvailableVersion(String latestAvailableVersion);

        /**
         * <p>
         * The drift status of the landing zone.
         * </p>
         * 
         * @param driftStatus
         *        The drift status of the landing zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftStatus(LandingZoneDriftStatusSummary driftStatus);

        /**
         * <p>
         * The drift status of the landing zone.
         * </p>
         * This is a convenience method that creates an instance of the {@link LandingZoneDriftStatusSummary.Builder}
         * avoiding the need to create one manually via {@link LandingZoneDriftStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LandingZoneDriftStatusSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #driftStatus(LandingZoneDriftStatusSummary)}.
         * 
         * @param driftStatus
         *        a consumer that will call methods on {@link LandingZoneDriftStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driftStatus(LandingZoneDriftStatusSummary)
         */
        default Builder driftStatus(Consumer<LandingZoneDriftStatusSummary.Builder> driftStatus) {
            return driftStatus(LandingZoneDriftStatusSummary.builder().applyMutation(driftStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private Document manifest;

        private List<String> remediationTypes = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private String status;

        private String latestAvailableVersion;

        private LandingZoneDriftStatusSummary driftStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LandingZoneDetail model) {
            version(model.version);
            manifest(model.manifest);
            remediationTypesWithStrings(model.remediationTypes);
            arn(model.arn);
            status(model.status);
            latestAvailableVersion(model.latestAvailableVersion);
            driftStatus(model.driftStatus);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Document getManifest() {
            return manifest;
        }

        public final void setManifest(Document manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(Document manifest) {
            this.manifest = manifest;
            return this;
        }

        public final Collection<String> getRemediationTypes() {
            if (remediationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return remediationTypes;
        }

        public final void setRemediationTypes(Collection<String> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copy(remediationTypes);
        }

        @Override
        public final Builder remediationTypesWithStrings(Collection<String> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copy(remediationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationTypesWithStrings(String... remediationTypes) {
            remediationTypesWithStrings(Arrays.asList(remediationTypes));
            return this;
        }

        @Override
        public final Builder remediationTypes(Collection<RemediationType> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copyEnumToString(remediationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationTypes(RemediationType... remediationTypes) {
            remediationTypes(Arrays.asList(remediationTypes));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LandingZoneStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLatestAvailableVersion() {
            return latestAvailableVersion;
        }

        public final void setLatestAvailableVersion(String latestAvailableVersion) {
            this.latestAvailableVersion = latestAvailableVersion;
        }

        @Override
        public final Builder latestAvailableVersion(String latestAvailableVersion) {
            this.latestAvailableVersion = latestAvailableVersion;
            return this;
        }

        public final LandingZoneDriftStatusSummary.Builder getDriftStatus() {
            return driftStatus != null ? driftStatus.toBuilder() : null;
        }

        public final void setDriftStatus(LandingZoneDriftStatusSummary.BuilderImpl driftStatus) {
            this.driftStatus = driftStatus != null ? driftStatus.build() : null;
        }

        @Override
        public final Builder driftStatus(LandingZoneDriftStatusSummary driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        @Override
        public LandingZoneDetail build() {
            return new LandingZoneDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
