/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costandusagereport.model.CostAndUsageReportRequest;
import software.amazon.awssdk.services.costandusagereport.model.ReportDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutReportDefinitionRequest
extends CostAndUsageReportRequest
implements ToCopyableBuilder<Builder, PutReportDefinitionRequest> {
    private static final SdkField<ReportDefinition> REPORT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportDefinition").getter(PutReportDefinitionRequest.getter(PutReportDefinitionRequest::reportDefinition)).setter(PutReportDefinitionRequest.setter(Builder::reportDefinition)).constructor(ReportDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_DEFINITION_FIELD));
    private final ReportDefinition reportDefinition;

    private PutReportDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.reportDefinition = builder.reportDefinition;
    }

    public ReportDefinition reportDefinition() {
        return this.reportDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportDefinition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutReportDefinitionRequest)) {
            return false;
        }
        PutReportDefinitionRequest other = (PutReportDefinitionRequest)((Object)obj);
        return Objects.equals(this.reportDefinition(), other.reportDefinition());
    }

    public String toString() {
        return ToString.builder((String)"PutReportDefinitionRequest").add("ReportDefinition", (Object)this.reportDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportDefinition": {
                return Optional.ofNullable(clazz.cast(this.reportDefinition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutReportDefinitionRequest, T> g) {
        return obj -> g.apply((PutReportDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostAndUsageReportRequest.BuilderImpl
    implements Builder {
        private ReportDefinition reportDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(PutReportDefinitionRequest model) {
            super(model);
            this.reportDefinition(model.reportDefinition);
        }

        public final ReportDefinition.Builder getReportDefinition() {
            return this.reportDefinition != null ? this.reportDefinition.toBuilder() : null;
        }

        @Override
        public final Builder reportDefinition(ReportDefinition reportDefinition) {
            this.reportDefinition = reportDefinition;
            return this;
        }

        public final void setReportDefinition(ReportDefinition.BuilderImpl reportDefinition) {
            this.reportDefinition = reportDefinition != null ? reportDefinition.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutReportDefinitionRequest build() {
            return new PutReportDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostAndUsageReportRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutReportDefinitionRequest> {
        public Builder reportDefinition(ReportDefinition var1);

        default public Builder reportDefinition(Consumer<ReportDefinition.Builder> reportDefinition) {
            return this.reportDefinition((ReportDefinition)((ReportDefinition.Builder)ReportDefinition.builder().applyMutation(reportDefinition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

