/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costandusagereport.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReportDefinitionRequest extends CostAndUsageReportRequest implements
        ToCopyableBuilder<ModifyReportDefinitionRequest.Builder, ModifyReportDefinitionRequest> {
    private static final SdkField<String> REPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportName").getter(getter(ModifyReportDefinitionRequest::reportName))
            .setter(setter(Builder::reportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportName").build()).build();

    private static final SdkField<ReportDefinition> REPORT_DEFINITION_FIELD = SdkField
            .<ReportDefinition> builder(MarshallingType.SDK_POJO).memberName("ReportDefinition")
            .getter(getter(ModifyReportDefinitionRequest::reportDefinition)).setter(setter(Builder::reportDefinition))
            .constructor(ReportDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_NAME_FIELD,
            REPORT_DEFINITION_FIELD));

    private final String reportName;

    private final ReportDefinition reportDefinition;

    private ModifyReportDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.reportName = builder.reportName;
        this.reportDefinition = builder.reportDefinition;
    }

    /**
     * Returns the value of the ReportName property for this object.
     * 
     * @return The value of the ReportName property for this object.
     */
    public final String reportName() {
        return reportName;
    }

    /**
     * Returns the value of the ReportDefinition property for this object.
     * 
     * @return The value of the ReportDefinition property for this object.
     */
    public final ReportDefinition reportDefinition() {
        return reportDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportName());
        hashCode = 31 * hashCode + Objects.hashCode(reportDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReportDefinitionRequest)) {
            return false;
        }
        ModifyReportDefinitionRequest other = (ModifyReportDefinitionRequest) obj;
        return Objects.equals(reportName(), other.reportName()) && Objects.equals(reportDefinition(), other.reportDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyReportDefinitionRequest").add("ReportName", reportName())
                .add("ReportDefinition", reportDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportName":
            return Optional.ofNullable(clazz.cast(reportName()));
        case "ReportDefinition":
            return Optional.ofNullable(clazz.cast(reportDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReportDefinitionRequest, T> g) {
        return obj -> g.apply((ModifyReportDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostAndUsageReportRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyReportDefinitionRequest> {
        /**
         * Sets the value of the ReportName property for this object.
         *
         * @param reportName
         *        The new value for the ReportName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportName(String reportName);

        /**
         * Sets the value of the ReportDefinition property for this object.
         *
         * @param reportDefinition
         *        The new value for the ReportDefinition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDefinition(ReportDefinition reportDefinition);

        /**
         * Sets the value of the ReportDefinition property for this object.
         *
         * This is a convenience that creates an instance of the {@link ReportDefinition.Builder} avoiding the need to
         * create one manually via {@link ReportDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #reportDefinition(ReportDefinition)}.
         * 
         * @param reportDefinition
         *        a consumer that will call methods on {@link ReportDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportDefinition(ReportDefinition)
         */
        default Builder reportDefinition(Consumer<ReportDefinition.Builder> reportDefinition) {
            return reportDefinition(ReportDefinition.builder().applyMutation(reportDefinition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostAndUsageReportRequest.BuilderImpl implements Builder {
        private String reportName;

        private ReportDefinition reportDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReportDefinitionRequest model) {
            super(model);
            reportName(model.reportName);
            reportDefinition(model.reportDefinition);
        }

        public final String getReportName() {
            return reportName;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        @Override
        @Transient
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public final ReportDefinition.Builder getReportDefinition() {
            return reportDefinition != null ? reportDefinition.toBuilder() : null;
        }

        public final void setReportDefinition(ReportDefinition.BuilderImpl reportDefinition) {
            this.reportDefinition = reportDefinition != null ? reportDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder reportDefinition(ReportDefinition reportDefinition) {
            this.reportDefinition = reportDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReportDefinitionRequest build() {
            return new ModifyReportDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
