/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costandusagereport;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.costandusagereport.model.DeleteReportDefinitionRequest;
import software.amazon.awssdk.services.costandusagereport.model.DeleteReportDefinitionResponse;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse;
import software.amazon.awssdk.services.costandusagereport.model.ModifyReportDefinitionRequest;
import software.amazon.awssdk.services.costandusagereport.model.ModifyReportDefinitionResponse;
import software.amazon.awssdk.services.costandusagereport.model.PutReportDefinitionRequest;
import software.amazon.awssdk.services.costandusagereport.model.PutReportDefinitionResponse;
import software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsPublisher;

/**
 * Service client for accessing AWS Cost and Usage Report Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The AWS Cost and Usage Report API enables you to programmatically create, query, and delete AWS Cost and Usage report
 * definitions.
 * </p>
 * <p>
 * AWS Cost and Usage reports track the monthly AWS costs and usage associated with your AWS account. The report
 * contains line items for each unique combination of AWS product, usage type, and operation that your AWS account uses.
 * You can configure the AWS Cost and Usage report to show only the data that you want, using the AWS Cost and Usage
 * API.
 * </p>
 * <p>
 * Service Endpoint
 * </p>
 * <p>
 * The AWS Cost and Usage Report API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * cur.us-east-1.amazonaws.com
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CostAndUsageReportAsyncClient extends AwsClient {
    String SERVICE_NAME = "cur";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cur";

    /**
     * <p>
     * Deletes the specified report.
     * </p>
     *
     * @param deleteReportDefinitionRequest
     *        Deletes the specified report.
     * @return A Java Future containing the result of the DeleteReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.DeleteReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DeleteReportDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReportDefinitionResponse> deleteReportDefinition(
            DeleteReportDefinitionRequest deleteReportDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReportDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReportDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteReportDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReportDefinitionRequest.Builder} to create a
     *        request. Deletes the specified report.
     * @return A Java Future containing the result of the DeleteReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.DeleteReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DeleteReportDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReportDefinitionResponse> deleteReportDefinition(
            Consumer<DeleteReportDefinitionRequest.Builder> deleteReportDefinitionRequest) {
        return deleteReportDefinition(DeleteReportDefinitionRequest.builder().applyMutation(deleteReportDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     *
     * @param describeReportDefinitionsRequest
     *        Requests a list of AWS Cost and Usage reports owned by the account.
     * @return A Java Future containing the result of the DescribeReportDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.DescribeReportDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReportDefinitionsResponse> describeReportDefinitions(
            DescribeReportDefinitionsRequest describeReportDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReportDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReportDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeReportDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReportDefinitionsRequest.Builder} to create a
     *        request. Requests a list of AWS Cost and Usage reports owned by the account.
     * @return A Java Future containing the result of the DescribeReportDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.DescribeReportDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReportDefinitionsResponse> describeReportDefinitions(
            Consumer<DescribeReportDefinitionsRequest.Builder> describeReportDefinitionsRequest) {
        return describeReportDefinitions(DescribeReportDefinitionsRequest.builder()
                .applyMutation(describeReportDefinitionsRequest).build());
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReportDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.DescribeReportDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReportDefinitionsResponse> describeReportDefinitions() {
        return describeReportDefinitions(DescribeReportDefinitionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsPublisher publisher = client.describeReportDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsPublisher publisher = client.describeReportDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.DescribeReportDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReportDefinitionsPublisher describeReportDefinitionsPaginator() {
        return describeReportDefinitionsPaginator(DescribeReportDefinitionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsPublisher publisher = client.describeReportDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsPublisher publisher = client.describeReportDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReportDefinitionsRequest
     *        Requests a list of AWS Cost and Usage reports owned by the account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.DescribeReportDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReportDefinitionsPublisher describeReportDefinitionsPaginator(
            DescribeReportDefinitionsRequest describeReportDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsPublisher publisher = client.describeReportDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsPublisher publisher = client.describeReportDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReportDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReportDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeReportDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReportDefinitionsRequest.Builder} to create a
     *        request. Requests a list of AWS Cost and Usage reports owned by the account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.DescribeReportDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReportDefinitionsPublisher describeReportDefinitionsPaginator(
            Consumer<DescribeReportDefinitionsRequest.Builder> describeReportDefinitionsRequest) {
        return describeReportDefinitionsPaginator(DescribeReportDefinitionsRequest.builder()
                .applyMutation(describeReportDefinitionsRequest).build());
    }

    /**
     * <p>
     * Allows you to programatically update your report preferences.
     * </p>
     *
     * @param modifyReportDefinitionRequest
     * @return A Java Future containing the result of the ModifyReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.ModifyReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ModifyReportDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyReportDefinitionResponse> modifyReportDefinition(
            ModifyReportDefinitionRequest modifyReportDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to programatically update your report preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReportDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyReportDefinitionRequest#builder()}
     * </p>
     *
     * @param modifyReportDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link ModifyReportDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.ModifyReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ModifyReportDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyReportDefinitionResponse> modifyReportDefinition(
            Consumer<ModifyReportDefinitionRequest.Builder> modifyReportDefinitionRequest) {
        return modifyReportDefinition(ModifyReportDefinitionRequest.builder().applyMutation(modifyReportDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new report using the description that you provide.
     * </p>
     *
     * @param putReportDefinitionRequest
     *        Creates a Cost and Usage Report.
     * @return A Java Future containing the result of the PutReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateReportNameException A report with the specified name already exists in the account. Specify
     *         a different report name.</li>
     *         <li>ReportLimitReachedException This account already has five reports defined. To define a new report,
     *         you must delete an existing report.</li>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.PutReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/PutReportDefinition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutReportDefinitionResponse> putReportDefinition(
            PutReportDefinitionRequest putReportDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new report using the description that you provide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutReportDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link PutReportDefinitionRequest#builder()}
     * </p>
     *
     * @param putReportDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link PutReportDefinitionRequest.Builder} to create a
     *        request. Creates a Cost and Usage Report.
     * @return A Java Future containing the result of the PutReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateReportNameException A report with the specified name already exists in the account. Specify
     *         a different report name.</li>
     *         <li>ReportLimitReachedException This account already has five reports defined. To define a new report,
     *         you must delete an existing report.</li>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostAndUsageReportException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostAndUsageReportAsyncClient.PutReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/PutReportDefinition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutReportDefinitionResponse> putReportDefinition(
            Consumer<PutReportDefinitionRequest.Builder> putReportDefinitionRequest) {
        return putReportDefinition(PutReportDefinitionRequest.builder().applyMutation(putReportDefinitionRequest).build());
    }

    @Override
    CostAndUsageReportServiceClientConfiguration serviceClientConfiguration();

    /**
     * Create a {@link CostAndUsageReportAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CostAndUsageReportAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CostAndUsageReportAsyncClient}.
     */
    static CostAndUsageReportAsyncClientBuilder builder() {
        return new DefaultCostAndUsageReportAsyncClientBuilder();
    }
}
