/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costandusagereport.model.CostAndUsageReportRequest;
import software.amazon.awssdk.services.costandusagereport.model.ReportDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyReportDefinitionRequest
extends CostAndUsageReportRequest
implements ToCopyableBuilder<Builder, ModifyReportDefinitionRequest> {
    private static final SdkField<String> REPORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportName").getter(ModifyReportDefinitionRequest.getter(ModifyReportDefinitionRequest::reportName)).setter(ModifyReportDefinitionRequest.setter(Builder::reportName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportName").build()}).build();
    private static final SdkField<ReportDefinition> REPORT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportDefinition").getter(ModifyReportDefinitionRequest.getter(ModifyReportDefinitionRequest::reportDefinition)).setter(ModifyReportDefinitionRequest.setter(Builder::reportDefinition)).constructor(ReportDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_NAME_FIELD, REPORT_DEFINITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReportName", REPORT_NAME_FIELD);
            this.put("ReportDefinition", REPORT_DEFINITION_FIELD);
        }
    });
    private final String reportName;
    private final ReportDefinition reportDefinition;

    private ModifyReportDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.reportName = builder.reportName;
        this.reportDefinition = builder.reportDefinition;
    }

    public final String reportName() {
        return this.reportName;
    }

    public final ReportDefinition reportDefinition() {
        return this.reportDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReportDefinitionRequest)) {
            return false;
        }
        ModifyReportDefinitionRequest other = (ModifyReportDefinitionRequest)((Object)obj);
        return Objects.equals(this.reportName(), other.reportName()) && Objects.equals(this.reportDefinition(), other.reportDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyReportDefinitionRequest").add("ReportName", (Object)this.reportName()).add("ReportDefinition", (Object)this.reportDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportName": {
                return Optional.ofNullable(clazz.cast(this.reportName()));
            }
            case "ReportDefinition": {
                return Optional.ofNullable(clazz.cast(this.reportDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReportDefinitionRequest, T> g) {
        return obj -> g.apply((ModifyReportDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostAndUsageReportRequest.BuilderImpl
    implements Builder {
        private String reportName;
        private ReportDefinition reportDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReportDefinitionRequest model) {
            super(model);
            this.reportName(model.reportName);
            this.reportDefinition(model.reportDefinition);
        }

        public final String getReportName() {
            return this.reportName;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public final ReportDefinition.Builder getReportDefinition() {
            return this.reportDefinition != null ? this.reportDefinition.toBuilder() : null;
        }

        public final void setReportDefinition(ReportDefinition.BuilderImpl reportDefinition) {
            this.reportDefinition = reportDefinition != null ? reportDefinition.build() : null;
        }

        @Override
        public final Builder reportDefinition(ReportDefinition reportDefinition) {
            this.reportDefinition = reportDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReportDefinitionRequest build() {
            return new ModifyReportDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostAndUsageReportRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyReportDefinitionRequest> {
        public Builder reportName(String var1);

        public Builder reportDefinition(ReportDefinition var1);

        default public Builder reportDefinition(Consumer<ReportDefinition.Builder> reportDefinition) {
            return this.reportDefinition((ReportDefinition)((ReportDefinition.Builder)ReportDefinition.builder().applyMutation(reportDefinition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

