/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costandusagereport.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of Amazon Web Services Cost and Usage Report. You can specify the report name, time unit, report
 * format, compression format, S3 bucket, additional artifacts, and schema elements in the definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ReportDefinition.Builder, ReportDefinition> {
    private static final SdkField<String> REPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportName").getter(getter(ReportDefinition::reportName)).setter(setter(Builder::reportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportName").build()).build();

    private static final SdkField<String> TIME_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeUnit").getter(getter(ReportDefinition::timeUnitAsString)).setter(setter(Builder::timeUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeUnit").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(ReportDefinition::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Compression").getter(getter(ReportDefinition::compressionAsString)).setter(setter(Builder::compression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compression").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_SCHEMA_ELEMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalSchemaElements")
            .getter(getter(ReportDefinition::additionalSchemaElementsAsStrings))
            .setter(setter(Builder::additionalSchemaElementsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalSchemaElements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(ReportDefinition::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix").getter(getter(ReportDefinition::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final SdkField<String> S3_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Region").getter(getter(ReportDefinition::s3RegionAsString)).setter(setter(Builder::s3Region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Region").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_ARTIFACTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalArtifacts")
            .getter(getter(ReportDefinition::additionalArtifactsAsStrings))
            .setter(setter(Builder::additionalArtifactsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> REFRESH_CLOSED_REPORTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RefreshClosedReports").getter(getter(ReportDefinition::refreshClosedReports))
            .setter(setter(Builder::refreshClosedReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshClosedReports").build())
            .build();

    private static final SdkField<String> REPORT_VERSIONING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportVersioning").getter(getter(ReportDefinition::reportVersioningAsString))
            .setter(setter(Builder::reportVersioning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportVersioning").build()).build();

    private static final SdkField<String> BILLING_VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingViewArn").getter(getter(ReportDefinition::billingViewArn))
            .setter(setter(Builder::billingViewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingViewArn").build()).build();

    private static final SdkField<ReportStatus> REPORT_STATUS_FIELD = SdkField.<ReportStatus> builder(MarshallingType.SDK_POJO)
            .memberName("ReportStatus").getter(getter(ReportDefinition::reportStatus)).setter(setter(Builder::reportStatus))
            .constructor(ReportStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_NAME_FIELD,
            TIME_UNIT_FIELD, FORMAT_FIELD, COMPRESSION_FIELD, ADDITIONAL_SCHEMA_ELEMENTS_FIELD, S3_BUCKET_FIELD, S3_PREFIX_FIELD,
            S3_REGION_FIELD, ADDITIONAL_ARTIFACTS_FIELD, REFRESH_CLOSED_REPORTS_FIELD, REPORT_VERSIONING_FIELD,
            BILLING_VIEW_ARN_FIELD, REPORT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reportName;

    private final String timeUnit;

    private final String format;

    private final String compression;

    private final List<String> additionalSchemaElements;

    private final String s3Bucket;

    private final String s3Prefix;

    private final String s3Region;

    private final List<String> additionalArtifacts;

    private final Boolean refreshClosedReports;

    private final String reportVersioning;

    private final String billingViewArn;

    private final ReportStatus reportStatus;

    private ReportDefinition(BuilderImpl builder) {
        this.reportName = builder.reportName;
        this.timeUnit = builder.timeUnit;
        this.format = builder.format;
        this.compression = builder.compression;
        this.additionalSchemaElements = builder.additionalSchemaElements;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.s3Region = builder.s3Region;
        this.additionalArtifacts = builder.additionalArtifacts;
        this.refreshClosedReports = builder.refreshClosedReports;
        this.reportVersioning = builder.reportVersioning;
        this.billingViewArn = builder.billingViewArn;
        this.reportStatus = builder.reportStatus;
    }

    /**
     * Returns the value of the ReportName property for this object.
     * 
     * @return The value of the ReportName property for this object.
     */
    public final String reportName() {
        return reportName;
    }

    /**
     * Returns the value of the TimeUnit property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeUnit} will
     * return {@link TimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeUnitAsString}.
     * </p>
     * 
     * @return The value of the TimeUnit property for this object.
     * @see TimeUnit
     */
    public final TimeUnit timeUnit() {
        return TimeUnit.fromValue(timeUnit);
    }

    /**
     * Returns the value of the TimeUnit property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeUnit} will
     * return {@link TimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeUnitAsString}.
     * </p>
     * 
     * @return The value of the TimeUnit property for this object.
     * @see TimeUnit
     */
    public final String timeUnitAsString() {
        return timeUnit;
    }

    /**
     * Returns the value of the Format property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ReportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The value of the Format property for this object.
     * @see ReportFormat
     */
    public final ReportFormat format() {
        return ReportFormat.fromValue(format);
    }

    /**
     * Returns the value of the Format property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ReportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The value of the Format property for this object.
     * @see ReportFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * Returns the value of the Compression property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compression} will
     * return {@link CompressionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compressionAsString}.
     * </p>
     * 
     * @return The value of the Compression property for this object.
     * @see CompressionFormat
     */
    public final CompressionFormat compression() {
        return CompressionFormat.fromValue(compression);
    }

    /**
     * Returns the value of the Compression property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compression} will
     * return {@link CompressionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compressionAsString}.
     * </p>
     * 
     * @return The value of the Compression property for this object.
     * @see CompressionFormat
     */
    public final String compressionAsString() {
        return compression;
    }

    /**
     * <p>
     * A list of strings that indicate additional content that Amazon Web Services includes in the report, such as
     * individual resource IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalSchemaElements} method.
     * </p>
     * 
     * @return A list of strings that indicate additional content that Amazon Web Services includes in the report, such
     *         as individual resource IDs.
     */
    public final List<SchemaElement> additionalSchemaElements() {
        return SchemaElementListCopier.copyStringToEnum(additionalSchemaElements);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalSchemaElements property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalSchemaElements() {
        return additionalSchemaElements != null && !(additionalSchemaElements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings that indicate additional content that Amazon Web Services includes in the report, such as
     * individual resource IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalSchemaElements} method.
     * </p>
     * 
     * @return A list of strings that indicate additional content that Amazon Web Services includes in the report, such
     *         as individual resource IDs.
     */
    public final List<String> additionalSchemaElementsAsStrings() {
        return additionalSchemaElements;
    }

    /**
     * Returns the value of the S3Bucket property for this object.
     * 
     * @return The value of the S3Bucket property for this object.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * Returns the value of the S3Prefix property for this object.
     * 
     * @return The value of the S3Prefix property for this object.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    /**
     * Returns the value of the S3Region property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3Region} will
     * return {@link AWSRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3RegionAsString}.
     * </p>
     * 
     * @return The value of the S3Region property for this object.
     * @see AWSRegion
     */
    public final AWSRegion s3Region() {
        return AWSRegion.fromValue(s3Region);
    }

    /**
     * Returns the value of the S3Region property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3Region} will
     * return {@link AWSRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3RegionAsString}.
     * </p>
     * 
     * @return The value of the S3Region property for this object.
     * @see AWSRegion
     */
    public final String s3RegionAsString() {
        return s3Region;
    }

    /**
     * <p>
     * A list of manifests that you want Amazon Web Services to create for this report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalArtifacts} method.
     * </p>
     * 
     * @return A list of manifests that you want Amazon Web Services to create for this report.
     */
    public final List<AdditionalArtifact> additionalArtifacts() {
        return AdditionalArtifactListCopier.copyStringToEnum(additionalArtifacts);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalArtifacts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalArtifacts() {
        return additionalArtifacts != null && !(additionalArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of manifests that you want Amazon Web Services to create for this report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalArtifacts} method.
     * </p>
     * 
     * @return A list of manifests that you want Amazon Web Services to create for this report.
     */
    public final List<String> additionalArtifactsAsStrings() {
        return additionalArtifacts;
    }

    /**
     * <p>
     * Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web Services
     * detects charges related to previous months. These charges can include refunds, credits, or support fees.
     * </p>
     * 
     * @return Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web
     *         Services detects charges related to previous months. These charges can include refunds, credits, or
     *         support fees.
     */
    public final Boolean refreshClosedReports() {
        return refreshClosedReports;
    }

    /**
     * <p>
     * Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the report in
     * addition to the previous versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportVersioning}
     * will return {@link ReportVersioning#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reportVersioningAsString}.
     * </p>
     * 
     * @return Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the
     *         report in addition to the previous versions.
     * @see ReportVersioning
     */
    public final ReportVersioning reportVersioning() {
        return ReportVersioning.fromValue(reportVersioning);
    }

    /**
     * <p>
     * Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the report in
     * addition to the previous versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportVersioning}
     * will return {@link ReportVersioning#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reportVersioningAsString}.
     * </p>
     * 
     * @return Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the
     *         report in addition to the previous versions.
     * @see ReportVersioning
     */
    public final String reportVersioningAsString() {
        return reportVersioning;
    }

    /**
     * <p>
     * The Amazon resource name of the billing view. The <code>BillingViewArn</code> is needed to create Amazon Web
     * Services Cost and Usage Report for each billing group maintained in the Amazon Web Services Billing Conductor
     * service. The <code>BillingViewArn</code> for a billing group can be constructed as:
     * <code>arn:aws:billing::payer-account-id:billingview/billing-group-primary-account-id</code>
     * </p>
     * 
     * @return The Amazon resource name of the billing view. The <code>BillingViewArn</code> is needed to create Amazon
     *         Web Services Cost and Usage Report for each billing group maintained in the Amazon Web Services Billing
     *         Conductor service. The <code>BillingViewArn</code> for a billing group can be constructed as:
     *         <code>arn:aws:billing::payer-account-id:billingview/billing-group-primary-account-id</code>
     */
    public final String billingViewArn() {
        return billingViewArn;
    }

    /**
     * <p>
     * The status of the report.
     * </p>
     * 
     * @return The status of the report.
     */
    public final ReportStatus reportStatus() {
        return reportStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportName());
        hashCode = 31 * hashCode + Objects.hashCode(timeUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalSchemaElements() ? additionalSchemaElementsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3RegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalArtifacts() ? additionalArtifactsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(refreshClosedReports());
        hashCode = 31 * hashCode + Objects.hashCode(reportVersioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(billingViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(reportStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDefinition)) {
            return false;
        }
        ReportDefinition other = (ReportDefinition) obj;
        return Objects.equals(reportName(), other.reportName()) && Objects.equals(timeUnitAsString(), other.timeUnitAsString())
                && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(compressionAsString(), other.compressionAsString())
                && hasAdditionalSchemaElements() == other.hasAdditionalSchemaElements()
                && Objects.equals(additionalSchemaElementsAsStrings(), other.additionalSchemaElementsAsStrings())
                && Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Prefix(), other.s3Prefix())
                && Objects.equals(s3RegionAsString(), other.s3RegionAsString())
                && hasAdditionalArtifacts() == other.hasAdditionalArtifacts()
                && Objects.equals(additionalArtifactsAsStrings(), other.additionalArtifactsAsStrings())
                && Objects.equals(refreshClosedReports(), other.refreshClosedReports())
                && Objects.equals(reportVersioningAsString(), other.reportVersioningAsString())
                && Objects.equals(billingViewArn(), other.billingViewArn())
                && Objects.equals(reportStatus(), other.reportStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportDefinition").add("ReportName", reportName()).add("TimeUnit", timeUnitAsString())
                .add("Format", formatAsString()).add("Compression", compressionAsString())
                .add("AdditionalSchemaElements", hasAdditionalSchemaElements() ? additionalSchemaElementsAsStrings() : null)
                .add("S3Bucket", s3Bucket()).add("S3Prefix", s3Prefix()).add("S3Region", s3RegionAsString())
                .add("AdditionalArtifacts", hasAdditionalArtifacts() ? additionalArtifactsAsStrings() : null)
                .add("RefreshClosedReports", refreshClosedReports()).add("ReportVersioning", reportVersioningAsString())
                .add("BillingViewArn", billingViewArn()).add("ReportStatus", reportStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportName":
            return Optional.ofNullable(clazz.cast(reportName()));
        case "TimeUnit":
            return Optional.ofNullable(clazz.cast(timeUnitAsString()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "Compression":
            return Optional.ofNullable(clazz.cast(compressionAsString()));
        case "AdditionalSchemaElements":
            return Optional.ofNullable(clazz.cast(additionalSchemaElementsAsStrings()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "S3Region":
            return Optional.ofNullable(clazz.cast(s3RegionAsString()));
        case "AdditionalArtifacts":
            return Optional.ofNullable(clazz.cast(additionalArtifactsAsStrings()));
        case "RefreshClosedReports":
            return Optional.ofNullable(clazz.cast(refreshClosedReports()));
        case "ReportVersioning":
            return Optional.ofNullable(clazz.cast(reportVersioningAsString()));
        case "BillingViewArn":
            return Optional.ofNullable(clazz.cast(billingViewArn()));
        case "ReportStatus":
            return Optional.ofNullable(clazz.cast(reportStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReportName", REPORT_NAME_FIELD);
        map.put("TimeUnit", TIME_UNIT_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("Compression", COMPRESSION_FIELD);
        map.put("AdditionalSchemaElements", ADDITIONAL_SCHEMA_ELEMENTS_FIELD);
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("S3Prefix", S3_PREFIX_FIELD);
        map.put("S3Region", S3_REGION_FIELD);
        map.put("AdditionalArtifacts", ADDITIONAL_ARTIFACTS_FIELD);
        map.put("RefreshClosedReports", REFRESH_CLOSED_REPORTS_FIELD);
        map.put("ReportVersioning", REPORT_VERSIONING_FIELD);
        map.put("BillingViewArn", BILLING_VIEW_ARN_FIELD);
        map.put("ReportStatus", REPORT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportDefinition, T> g) {
        return obj -> g.apply((ReportDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportDefinition> {
        /**
         * Sets the value of the ReportName property for this object.
         *
         * @param reportName
         *        The new value for the ReportName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportName(String reportName);

        /**
         * Sets the value of the TimeUnit property for this object.
         *
         * @param timeUnit
         *        The new value for the TimeUnit property for this object.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder timeUnit(String timeUnit);

        /**
         * Sets the value of the TimeUnit property for this object.
         *
         * @param timeUnit
         *        The new value for the TimeUnit property for this object.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder timeUnit(TimeUnit timeUnit);

        /**
         * Sets the value of the Format property for this object.
         *
         * @param format
         *        The new value for the Format property for this object.
         * @see ReportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFormat
         */
        Builder format(String format);

        /**
         * Sets the value of the Format property for this object.
         *
         * @param format
         *        The new value for the Format property for this object.
         * @see ReportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFormat
         */
        Builder format(ReportFormat format);

        /**
         * Sets the value of the Compression property for this object.
         *
         * @param compression
         *        The new value for the Compression property for this object.
         * @see CompressionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionFormat
         */
        Builder compression(String compression);

        /**
         * Sets the value of the Compression property for this object.
         *
         * @param compression
         *        The new value for the Compression property for this object.
         * @see CompressionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionFormat
         */
        Builder compression(CompressionFormat compression);

        /**
         * <p>
         * A list of strings that indicate additional content that Amazon Web Services includes in the report, such as
         * individual resource IDs.
         * </p>
         * 
         * @param additionalSchemaElements
         *        A list of strings that indicate additional content that Amazon Web Services includes in the report,
         *        such as individual resource IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalSchemaElementsWithStrings(Collection<String> additionalSchemaElements);

        /**
         * <p>
         * A list of strings that indicate additional content that Amazon Web Services includes in the report, such as
         * individual resource IDs.
         * </p>
         * 
         * @param additionalSchemaElements
         *        A list of strings that indicate additional content that Amazon Web Services includes in the report,
         *        such as individual resource IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalSchemaElementsWithStrings(String... additionalSchemaElements);

        /**
         * <p>
         * A list of strings that indicate additional content that Amazon Web Services includes in the report, such as
         * individual resource IDs.
         * </p>
         * 
         * @param additionalSchemaElements
         *        A list of strings that indicate additional content that Amazon Web Services includes in the report,
         *        such as individual resource IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalSchemaElements(Collection<SchemaElement> additionalSchemaElements);

        /**
         * <p>
         * A list of strings that indicate additional content that Amazon Web Services includes in the report, such as
         * individual resource IDs.
         * </p>
         * 
         * @param additionalSchemaElements
         *        A list of strings that indicate additional content that Amazon Web Services includes in the report,
         *        such as individual resource IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalSchemaElements(SchemaElement... additionalSchemaElements);

        /**
         * Sets the value of the S3Bucket property for this object.
         *
         * @param s3Bucket
         *        The new value for the S3Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * Sets the value of the S3Prefix property for this object.
         *
         * @param s3Prefix
         *        The new value for the S3Prefix property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * Sets the value of the S3Region property for this object.
         *
         * @param s3Region
         *        The new value for the S3Region property for this object.
         * @see AWSRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AWSRegion
         */
        Builder s3Region(String s3Region);

        /**
         * Sets the value of the S3Region property for this object.
         *
         * @param s3Region
         *        The new value for the S3Region property for this object.
         * @see AWSRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AWSRegion
         */
        Builder s3Region(AWSRegion s3Region);

        /**
         * <p>
         * A list of manifests that you want Amazon Web Services to create for this report.
         * </p>
         * 
         * @param additionalArtifacts
         *        A list of manifests that you want Amazon Web Services to create for this report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalArtifactsWithStrings(Collection<String> additionalArtifacts);

        /**
         * <p>
         * A list of manifests that you want Amazon Web Services to create for this report.
         * </p>
         * 
         * @param additionalArtifacts
         *        A list of manifests that you want Amazon Web Services to create for this report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalArtifactsWithStrings(String... additionalArtifacts);

        /**
         * <p>
         * A list of manifests that you want Amazon Web Services to create for this report.
         * </p>
         * 
         * @param additionalArtifacts
         *        A list of manifests that you want Amazon Web Services to create for this report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalArtifacts(Collection<AdditionalArtifact> additionalArtifacts);

        /**
         * <p>
         * A list of manifests that you want Amazon Web Services to create for this report.
         * </p>
         * 
         * @param additionalArtifacts
         *        A list of manifests that you want Amazon Web Services to create for this report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalArtifacts(AdditionalArtifact... additionalArtifacts);

        /**
         * <p>
         * Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web
         * Services detects charges related to previous months. These charges can include refunds, credits, or support
         * fees.
         * </p>
         * 
         * @param refreshClosedReports
         *        Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon
         *        Web Services detects charges related to previous months. These charges can include refunds, credits,
         *        or support fees.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshClosedReports(Boolean refreshClosedReports);

        /**
         * <p>
         * Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the
         * report in addition to the previous versions.
         * </p>
         * 
         * @param reportVersioning
         *        Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver
         *        the report in addition to the previous versions.
         * @see ReportVersioning
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportVersioning
         */
        Builder reportVersioning(String reportVersioning);

        /**
         * <p>
         * Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the
         * report in addition to the previous versions.
         * </p>
         * 
         * @param reportVersioning
         *        Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver
         *        the report in addition to the previous versions.
         * @see ReportVersioning
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportVersioning
         */
        Builder reportVersioning(ReportVersioning reportVersioning);

        /**
         * <p>
         * The Amazon resource name of the billing view. The <code>BillingViewArn</code> is needed to create Amazon Web
         * Services Cost and Usage Report for each billing group maintained in the Amazon Web Services Billing Conductor
         * service. The <code>BillingViewArn</code> for a billing group can be constructed as:
         * <code>arn:aws:billing::payer-account-id:billingview/billing-group-primary-account-id</code>
         * </p>
         * 
         * @param billingViewArn
         *        The Amazon resource name of the billing view. The <code>BillingViewArn</code> is needed to create
         *        Amazon Web Services Cost and Usage Report for each billing group maintained in the Amazon Web Services
         *        Billing Conductor service. The <code>BillingViewArn</code> for a billing group can be constructed as:
         *        <code>arn:aws:billing::payer-account-id:billingview/billing-group-primary-account-id</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingViewArn(String billingViewArn);

        /**
         * <p>
         * The status of the report.
         * </p>
         * 
         * @param reportStatus
         *        The status of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportStatus(ReportStatus reportStatus);

        /**
         * <p>
         * The status of the report.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportStatus.Builder} avoiding the need
         * to create one manually via {@link ReportStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #reportStatus(ReportStatus)}.
         * 
         * @param reportStatus
         *        a consumer that will call methods on {@link ReportStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportStatus(ReportStatus)
         */
        default Builder reportStatus(Consumer<ReportStatus.Builder> reportStatus) {
            return reportStatus(ReportStatus.builder().applyMutation(reportStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String reportName;

        private String timeUnit;

        private String format;

        private String compression;

        private List<String> additionalSchemaElements = DefaultSdkAutoConstructList.getInstance();

        private String s3Bucket;

        private String s3Prefix;

        private String s3Region;

        private List<String> additionalArtifacts = DefaultSdkAutoConstructList.getInstance();

        private Boolean refreshClosedReports;

        private String reportVersioning;

        private String billingViewArn;

        private ReportStatus reportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDefinition model) {
            reportName(model.reportName);
            timeUnit(model.timeUnit);
            format(model.format);
            compression(model.compression);
            additionalSchemaElementsWithStrings(model.additionalSchemaElements);
            s3Bucket(model.s3Bucket);
            s3Prefix(model.s3Prefix);
            s3Region(model.s3Region);
            additionalArtifactsWithStrings(model.additionalArtifacts);
            refreshClosedReports(model.refreshClosedReports);
            reportVersioning(model.reportVersioning);
            billingViewArn(model.billingViewArn);
            reportStatus(model.reportStatus);
        }

        public final String getReportName() {
            return reportName;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public final String getTimeUnit() {
            return timeUnit;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit == null ? null : timeUnit.toString());
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ReportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getCompression() {
            return compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(CompressionFormat compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final Collection<String> getAdditionalSchemaElements() {
            if (additionalSchemaElements instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalSchemaElements;
        }

        public final void setAdditionalSchemaElements(Collection<String> additionalSchemaElements) {
            this.additionalSchemaElements = SchemaElementListCopier.copy(additionalSchemaElements);
        }

        @Override
        public final Builder additionalSchemaElementsWithStrings(Collection<String> additionalSchemaElements) {
            this.additionalSchemaElements = SchemaElementListCopier.copy(additionalSchemaElements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSchemaElementsWithStrings(String... additionalSchemaElements) {
            additionalSchemaElementsWithStrings(Arrays.asList(additionalSchemaElements));
            return this;
        }

        @Override
        public final Builder additionalSchemaElements(Collection<SchemaElement> additionalSchemaElements) {
            this.additionalSchemaElements = SchemaElementListCopier.copyEnumToString(additionalSchemaElements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSchemaElements(SchemaElement... additionalSchemaElements) {
            additionalSchemaElements(Arrays.asList(additionalSchemaElements));
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3Region() {
            return s3Region;
        }

        public final void setS3Region(String s3Region) {
            this.s3Region = s3Region;
        }

        @Override
        public final Builder s3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        @Override
        public final Builder s3Region(AWSRegion s3Region) {
            this.s3Region(s3Region == null ? null : s3Region.toString());
            return this;
        }

        public final Collection<String> getAdditionalArtifacts() {
            if (additionalArtifacts instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalArtifacts;
        }

        public final void setAdditionalArtifacts(Collection<String> additionalArtifacts) {
            this.additionalArtifacts = AdditionalArtifactListCopier.copy(additionalArtifacts);
        }

        @Override
        public final Builder additionalArtifactsWithStrings(Collection<String> additionalArtifacts) {
            this.additionalArtifacts = AdditionalArtifactListCopier.copy(additionalArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifactsWithStrings(String... additionalArtifacts) {
            additionalArtifactsWithStrings(Arrays.asList(additionalArtifacts));
            return this;
        }

        @Override
        public final Builder additionalArtifacts(Collection<AdditionalArtifact> additionalArtifacts) {
            this.additionalArtifacts = AdditionalArtifactListCopier.copyEnumToString(additionalArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifacts(AdditionalArtifact... additionalArtifacts) {
            additionalArtifacts(Arrays.asList(additionalArtifacts));
            return this;
        }

        public final Boolean getRefreshClosedReports() {
            return refreshClosedReports;
        }

        public final void setRefreshClosedReports(Boolean refreshClosedReports) {
            this.refreshClosedReports = refreshClosedReports;
        }

        @Override
        public final Builder refreshClosedReports(Boolean refreshClosedReports) {
            this.refreshClosedReports = refreshClosedReports;
            return this;
        }

        public final String getReportVersioning() {
            return reportVersioning;
        }

        public final void setReportVersioning(String reportVersioning) {
            this.reportVersioning = reportVersioning;
        }

        @Override
        public final Builder reportVersioning(String reportVersioning) {
            this.reportVersioning = reportVersioning;
            return this;
        }

        @Override
        public final Builder reportVersioning(ReportVersioning reportVersioning) {
            this.reportVersioning(reportVersioning == null ? null : reportVersioning.toString());
            return this;
        }

        public final String getBillingViewArn() {
            return billingViewArn;
        }

        public final void setBillingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
        }

        @Override
        public final Builder billingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
            return this;
        }

        public final ReportStatus.Builder getReportStatus() {
            return reportStatus != null ? reportStatus.toBuilder() : null;
        }

        public final void setReportStatus(ReportStatus.BuilderImpl reportStatus) {
            this.reportStatus = reportStatus != null ? reportStatus.build() : null;
        }

        @Override
        public final Builder reportStatus(ReportStatus reportStatus) {
            this.reportStatus = reportStatus;
            return this;
        }

        @Override
        public ReportDefinition build() {
            return new ReportDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
