/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costandusagereport.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A two element dictionary with a <code>lastDelivery</code> and <code>lastStatus</code> key whose values describe the
 * date and status of the last delivered report for a particular report definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportStatus implements SdkPojo, Serializable, ToCopyableBuilder<ReportStatus.Builder, ReportStatus> {
    private static final SdkField<String> LAST_DELIVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastDelivery").getter(getter(ReportStatus::lastDelivery)).setter(setter(Builder::lastDelivery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDelivery").build()).build();

    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastStatus").getter(getter(ReportStatus::lastStatusAsString)).setter(setter(Builder::lastStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_DELIVERY_FIELD,
            LAST_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lastDelivery;

    private final String lastStatus;

    private ReportStatus(BuilderImpl builder) {
        this.lastDelivery = builder.lastDelivery;
        this.lastStatus = builder.lastStatus;
    }

    /**
     * <p>
     * A timestamp that gives the date of a report delivery.
     * </p>
     * 
     * @return A timestamp that gives the date of a report delivery.
     */
    public final String lastDelivery() {
        return lastDelivery;
    }

    /**
     * <p>
     * An enum that gives the status of a report delivery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link LastStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusAsString}.
     * </p>
     * 
     * @return An enum that gives the status of a report delivery.
     * @see LastStatus
     */
    public final LastStatus lastStatus() {
        return LastStatus.fromValue(lastStatus);
    }

    /**
     * <p>
     * An enum that gives the status of a report delivery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link LastStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusAsString}.
     * </p>
     * 
     * @return An enum that gives the status of a report delivery.
     * @see LastStatus
     */
    public final String lastStatusAsString() {
        return lastStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportStatus)) {
            return false;
        }
        ReportStatus other = (ReportStatus) obj;
        return Objects.equals(lastDelivery(), other.lastDelivery())
                && Objects.equals(lastStatusAsString(), other.lastStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportStatus").add("LastDelivery", lastDelivery()).add("LastStatus", lastStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastDelivery":
            return Optional.ofNullable(clazz.cast(lastDelivery()));
        case "lastStatus":
            return Optional.ofNullable(clazz.cast(lastStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lastDelivery", LAST_DELIVERY_FIELD);
        map.put("lastStatus", LAST_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportStatus, T> g) {
        return obj -> g.apply((ReportStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportStatus> {
        /**
         * <p>
         * A timestamp that gives the date of a report delivery.
         * </p>
         * 
         * @param lastDelivery
         *        A timestamp that gives the date of a report delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDelivery(String lastDelivery);

        /**
         * <p>
         * An enum that gives the status of a report delivery.
         * </p>
         * 
         * @param lastStatus
         *        An enum that gives the status of a report delivery.
         * @see LastStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastStatus
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * An enum that gives the status of a report delivery.
         * </p>
         * 
         * @param lastStatus
         *        An enum that gives the status of a report delivery.
         * @see LastStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastStatus
         */
        Builder lastStatus(LastStatus lastStatus);
    }

    static final class BuilderImpl implements Builder {
        private String lastDelivery;

        private String lastStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportStatus model) {
            lastDelivery(model.lastDelivery);
            lastStatus(model.lastStatus);
        }

        public final String getLastDelivery() {
            return lastDelivery;
        }

        public final void setLastDelivery(String lastDelivery) {
            this.lastDelivery = lastDelivery;
        }

        @Override
        public final Builder lastDelivery(String lastDelivery) {
            this.lastDelivery = lastDelivery;
            return this;
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(LastStatus lastStatus) {
            this.lastStatus(lastStatus == null ? null : lastStatus.toString());
            return this;
        }

        @Override
        public ReportStatus build() {
            return new ReportStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
