/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForecastResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ForecastResult> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimePeriod").getter(ForecastResult.getter(ForecastResult::timePeriod)).setter(ForecastResult.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<String> MEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeanValue").getter(ForecastResult.getter(ForecastResult::meanValue)).setter(ForecastResult.setter(Builder::meanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeanValue").build()}).build();
    private static final SdkField<String> PREDICTION_INTERVAL_LOWER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictionIntervalLowerBound").getter(ForecastResult.getter(ForecastResult::predictionIntervalLowerBound)).setter(ForecastResult.setter(Builder::predictionIntervalLowerBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionIntervalLowerBound").build()}).build();
    private static final SdkField<String> PREDICTION_INTERVAL_UPPER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictionIntervalUpperBound").getter(ForecastResult.getter(ForecastResult::predictionIntervalUpperBound)).setter(ForecastResult.setter(Builder::predictionIntervalUpperBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionIntervalUpperBound").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD, MEAN_VALUE_FIELD, PREDICTION_INTERVAL_LOWER_BOUND_FIELD, PREDICTION_INTERVAL_UPPER_BOUND_FIELD));
    private static final long serialVersionUID = 1L;
    private final DateInterval timePeriod;
    private final String meanValue;
    private final String predictionIntervalLowerBound;
    private final String predictionIntervalUpperBound;

    private ForecastResult(BuilderImpl builder) {
        this.timePeriod = builder.timePeriod;
        this.meanValue = builder.meanValue;
        this.predictionIntervalLowerBound = builder.predictionIntervalLowerBound;
        this.predictionIntervalUpperBound = builder.predictionIntervalUpperBound;
    }

    public DateInterval timePeriod() {
        return this.timePeriod;
    }

    public String meanValue() {
        return this.meanValue;
    }

    public String predictionIntervalLowerBound() {
        return this.predictionIntervalLowerBound;
    }

    public String predictionIntervalUpperBound() {
        return this.predictionIntervalUpperBound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.meanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionIntervalLowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionIntervalUpperBound());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastResult)) {
            return false;
        }
        ForecastResult other = (ForecastResult)obj;
        return Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.meanValue(), other.meanValue()) && Objects.equals(this.predictionIntervalLowerBound(), other.predictionIntervalLowerBound()) && Objects.equals(this.predictionIntervalUpperBound(), other.predictionIntervalUpperBound());
    }

    public String toString() {
        return ToString.builder((String)"ForecastResult").add("TimePeriod", (Object)this.timePeriod()).add("MeanValue", (Object)this.meanValue()).add("PredictionIntervalLowerBound", (Object)this.predictionIntervalLowerBound()).add("PredictionIntervalUpperBound", (Object)this.predictionIntervalUpperBound()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "MeanValue": {
                return Optional.ofNullable(clazz.cast(this.meanValue()));
            }
            case "PredictionIntervalLowerBound": {
                return Optional.ofNullable(clazz.cast(this.predictionIntervalLowerBound()));
            }
            case "PredictionIntervalUpperBound": {
                return Optional.ofNullable(clazz.cast(this.predictionIntervalUpperBound()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForecastResult, T> g) {
        return obj -> g.apply((ForecastResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DateInterval timePeriod;
        private String meanValue;
        private String predictionIntervalLowerBound;
        private String predictionIntervalUpperBound;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastResult model) {
            this.timePeriod(model.timePeriod);
            this.meanValue(model.meanValue);
            this.predictionIntervalLowerBound(model.predictionIntervalLowerBound);
            this.predictionIntervalUpperBound(model.predictionIntervalUpperBound);
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getMeanValue() {
            return this.meanValue;
        }

        @Override
        public final Builder meanValue(String meanValue) {
            this.meanValue = meanValue;
            return this;
        }

        public final void setMeanValue(String meanValue) {
            this.meanValue = meanValue;
        }

        public final String getPredictionIntervalLowerBound() {
            return this.predictionIntervalLowerBound;
        }

        @Override
        public final Builder predictionIntervalLowerBound(String predictionIntervalLowerBound) {
            this.predictionIntervalLowerBound = predictionIntervalLowerBound;
            return this;
        }

        public final void setPredictionIntervalLowerBound(String predictionIntervalLowerBound) {
            this.predictionIntervalLowerBound = predictionIntervalLowerBound;
        }

        public final String getPredictionIntervalUpperBound() {
            return this.predictionIntervalUpperBound;
        }

        @Override
        public final Builder predictionIntervalUpperBound(String predictionIntervalUpperBound) {
            this.predictionIntervalUpperBound = predictionIntervalUpperBound;
            return this;
        }

        public final void setPredictionIntervalUpperBound(String predictionIntervalUpperBound) {
            this.predictionIntervalUpperBound = predictionIntervalUpperBound;
        }

        public ForecastResult build() {
            return new ForecastResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ForecastResult> {
        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder meanValue(String var1);

        public Builder predictionIntervalLowerBound(String var1);

        public Builder predictionIntervalUpperBound(String var1);
    }
}

