/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationAggregates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservationAggregates> {
    private static final SdkField<String> UTILIZATION_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UtilizationPercentage").getter(ReservationAggregates.getter(ReservationAggregates::utilizationPercentage)).setter(ReservationAggregates.setter(Builder::utilizationPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationPercentage").build()}).build();
    private static final SdkField<String> UTILIZATION_PERCENTAGE_IN_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UtilizationPercentageInUnits").getter(ReservationAggregates.getter(ReservationAggregates::utilizationPercentageInUnits)).setter(ReservationAggregates.setter(Builder::utilizationPercentageInUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationPercentageInUnits").build()}).build();
    private static final SdkField<String> PURCHASED_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchasedHours").getter(ReservationAggregates.getter(ReservationAggregates::purchasedHours)).setter(ReservationAggregates.setter(Builder::purchasedHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchasedHours").build()}).build();
    private static final SdkField<String> PURCHASED_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchasedUnits").getter(ReservationAggregates.getter(ReservationAggregates::purchasedUnits)).setter(ReservationAggregates.setter(Builder::purchasedUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchasedUnits").build()}).build();
    private static final SdkField<String> TOTAL_ACTUAL_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalActualHours").getter(ReservationAggregates.getter(ReservationAggregates::totalActualHours)).setter(ReservationAggregates.setter(Builder::totalActualHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalActualHours").build()}).build();
    private static final SdkField<String> TOTAL_ACTUAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalActualUnits").getter(ReservationAggregates.getter(ReservationAggregates::totalActualUnits)).setter(ReservationAggregates.setter(Builder::totalActualUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalActualUnits").build()}).build();
    private static final SdkField<String> UNUSED_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnusedHours").getter(ReservationAggregates.getter(ReservationAggregates::unusedHours)).setter(ReservationAggregates.setter(Builder::unusedHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnusedHours").build()}).build();
    private static final SdkField<String> UNUSED_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnusedUnits").getter(ReservationAggregates.getter(ReservationAggregates::unusedUnits)).setter(ReservationAggregates.setter(Builder::unusedUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnusedUnits").build()}).build();
    private static final SdkField<String> ON_DEMAND_COST_OF_RI_HOURS_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnDemandCostOfRIHoursUsed").getter(ReservationAggregates.getter(ReservationAggregates::onDemandCostOfRIHoursUsed)).setter(ReservationAggregates.setter(Builder::onDemandCostOfRIHoursUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandCostOfRIHoursUsed").build()}).build();
    private static final SdkField<String> NET_RI_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetRISavings").getter(ReservationAggregates.getter(ReservationAggregates::netRISavings)).setter(ReservationAggregates.setter(Builder::netRISavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetRISavings").build()}).build();
    private static final SdkField<String> TOTAL_POTENTIAL_RI_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalPotentialRISavings").getter(ReservationAggregates.getter(ReservationAggregates::totalPotentialRISavings)).setter(ReservationAggregates.setter(Builder::totalPotentialRISavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalPotentialRISavings").build()}).build();
    private static final SdkField<String> AMORTIZED_UPFRONT_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmortizedUpfrontFee").getter(ReservationAggregates.getter(ReservationAggregates::amortizedUpfrontFee)).setter(ReservationAggregates.setter(Builder::amortizedUpfrontFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmortizedUpfrontFee").build()}).build();
    private static final SdkField<String> AMORTIZED_RECURRING_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmortizedRecurringFee").getter(ReservationAggregates.getter(ReservationAggregates::amortizedRecurringFee)).setter(ReservationAggregates.setter(Builder::amortizedRecurringFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmortizedRecurringFee").build()}).build();
    private static final SdkField<String> TOTAL_AMORTIZED_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalAmortizedFee").getter(ReservationAggregates.getter(ReservationAggregates::totalAmortizedFee)).setter(ReservationAggregates.setter(Builder::totalAmortizedFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmortizedFee").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTILIZATION_PERCENTAGE_FIELD, UTILIZATION_PERCENTAGE_IN_UNITS_FIELD, PURCHASED_HOURS_FIELD, PURCHASED_UNITS_FIELD, TOTAL_ACTUAL_HOURS_FIELD, TOTAL_ACTUAL_UNITS_FIELD, UNUSED_HOURS_FIELD, UNUSED_UNITS_FIELD, ON_DEMAND_COST_OF_RI_HOURS_USED_FIELD, NET_RI_SAVINGS_FIELD, TOTAL_POTENTIAL_RI_SAVINGS_FIELD, AMORTIZED_UPFRONT_FEE_FIELD, AMORTIZED_RECURRING_FEE_FIELD, TOTAL_AMORTIZED_FEE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String utilizationPercentage;
    private final String utilizationPercentageInUnits;
    private final String purchasedHours;
    private final String purchasedUnits;
    private final String totalActualHours;
    private final String totalActualUnits;
    private final String unusedHours;
    private final String unusedUnits;
    private final String onDemandCostOfRIHoursUsed;
    private final String netRISavings;
    private final String totalPotentialRISavings;
    private final String amortizedUpfrontFee;
    private final String amortizedRecurringFee;
    private final String totalAmortizedFee;

    private ReservationAggregates(BuilderImpl builder) {
        this.utilizationPercentage = builder.utilizationPercentage;
        this.utilizationPercentageInUnits = builder.utilizationPercentageInUnits;
        this.purchasedHours = builder.purchasedHours;
        this.purchasedUnits = builder.purchasedUnits;
        this.totalActualHours = builder.totalActualHours;
        this.totalActualUnits = builder.totalActualUnits;
        this.unusedHours = builder.unusedHours;
        this.unusedUnits = builder.unusedUnits;
        this.onDemandCostOfRIHoursUsed = builder.onDemandCostOfRIHoursUsed;
        this.netRISavings = builder.netRISavings;
        this.totalPotentialRISavings = builder.totalPotentialRISavings;
        this.amortizedUpfrontFee = builder.amortizedUpfrontFee;
        this.amortizedRecurringFee = builder.amortizedRecurringFee;
        this.totalAmortizedFee = builder.totalAmortizedFee;
    }

    public String utilizationPercentage() {
        return this.utilizationPercentage;
    }

    public String utilizationPercentageInUnits() {
        return this.utilizationPercentageInUnits;
    }

    public String purchasedHours() {
        return this.purchasedHours;
    }

    public String purchasedUnits() {
        return this.purchasedUnits;
    }

    public String totalActualHours() {
        return this.totalActualHours;
    }

    public String totalActualUnits() {
        return this.totalActualUnits;
    }

    public String unusedHours() {
        return this.unusedHours;
    }

    public String unusedUnits() {
        return this.unusedUnits;
    }

    public String onDemandCostOfRIHoursUsed() {
        return this.onDemandCostOfRIHoursUsed;
    }

    public String netRISavings() {
        return this.netRISavings;
    }

    public String totalPotentialRISavings() {
        return this.totalPotentialRISavings;
    }

    public String amortizedUpfrontFee() {
        return this.amortizedUpfrontFee;
    }

    public String amortizedRecurringFee() {
        return this.amortizedRecurringFee;
    }

    public String totalAmortizedFee() {
        return this.totalAmortizedFee;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationPercentageInUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchasedHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchasedUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalActualHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalActualUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandCostOfRIHoursUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.netRISavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalPotentialRISavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.amortizedUpfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.amortizedRecurringFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAmortizedFee());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationAggregates)) {
            return false;
        }
        ReservationAggregates other = (ReservationAggregates)obj;
        return Objects.equals(this.utilizationPercentage(), other.utilizationPercentage()) && Objects.equals(this.utilizationPercentageInUnits(), other.utilizationPercentageInUnits()) && Objects.equals(this.purchasedHours(), other.purchasedHours()) && Objects.equals(this.purchasedUnits(), other.purchasedUnits()) && Objects.equals(this.totalActualHours(), other.totalActualHours()) && Objects.equals(this.totalActualUnits(), other.totalActualUnits()) && Objects.equals(this.unusedHours(), other.unusedHours()) && Objects.equals(this.unusedUnits(), other.unusedUnits()) && Objects.equals(this.onDemandCostOfRIHoursUsed(), other.onDemandCostOfRIHoursUsed()) && Objects.equals(this.netRISavings(), other.netRISavings()) && Objects.equals(this.totalPotentialRISavings(), other.totalPotentialRISavings()) && Objects.equals(this.amortizedUpfrontFee(), other.amortizedUpfrontFee()) && Objects.equals(this.amortizedRecurringFee(), other.amortizedRecurringFee()) && Objects.equals(this.totalAmortizedFee(), other.totalAmortizedFee());
    }

    public String toString() {
        return ToString.builder((String)"ReservationAggregates").add("UtilizationPercentage", (Object)this.utilizationPercentage()).add("UtilizationPercentageInUnits", (Object)this.utilizationPercentageInUnits()).add("PurchasedHours", (Object)this.purchasedHours()).add("PurchasedUnits", (Object)this.purchasedUnits()).add("TotalActualHours", (Object)this.totalActualHours()).add("TotalActualUnits", (Object)this.totalActualUnits()).add("UnusedHours", (Object)this.unusedHours()).add("UnusedUnits", (Object)this.unusedUnits()).add("OnDemandCostOfRIHoursUsed", (Object)this.onDemandCostOfRIHoursUsed()).add("NetRISavings", (Object)this.netRISavings()).add("TotalPotentialRISavings", (Object)this.totalPotentialRISavings()).add("AmortizedUpfrontFee", (Object)this.amortizedUpfrontFee()).add("AmortizedRecurringFee", (Object)this.amortizedRecurringFee()).add("TotalAmortizedFee", (Object)this.totalAmortizedFee()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UtilizationPercentage": {
                return Optional.ofNullable(clazz.cast(this.utilizationPercentage()));
            }
            case "UtilizationPercentageInUnits": {
                return Optional.ofNullable(clazz.cast(this.utilizationPercentageInUnits()));
            }
            case "PurchasedHours": {
                return Optional.ofNullable(clazz.cast(this.purchasedHours()));
            }
            case "PurchasedUnits": {
                return Optional.ofNullable(clazz.cast(this.purchasedUnits()));
            }
            case "TotalActualHours": {
                return Optional.ofNullable(clazz.cast(this.totalActualHours()));
            }
            case "TotalActualUnits": {
                return Optional.ofNullable(clazz.cast(this.totalActualUnits()));
            }
            case "UnusedHours": {
                return Optional.ofNullable(clazz.cast(this.unusedHours()));
            }
            case "UnusedUnits": {
                return Optional.ofNullable(clazz.cast(this.unusedUnits()));
            }
            case "OnDemandCostOfRIHoursUsed": {
                return Optional.ofNullable(clazz.cast(this.onDemandCostOfRIHoursUsed()));
            }
            case "NetRISavings": {
                return Optional.ofNullable(clazz.cast(this.netRISavings()));
            }
            case "TotalPotentialRISavings": {
                return Optional.ofNullable(clazz.cast(this.totalPotentialRISavings()));
            }
            case "AmortizedUpfrontFee": {
                return Optional.ofNullable(clazz.cast(this.amortizedUpfrontFee()));
            }
            case "AmortizedRecurringFee": {
                return Optional.ofNullable(clazz.cast(this.amortizedRecurringFee()));
            }
            case "TotalAmortizedFee": {
                return Optional.ofNullable(clazz.cast(this.totalAmortizedFee()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationAggregates, T> g) {
        return obj -> g.apply((ReservationAggregates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String utilizationPercentage;
        private String utilizationPercentageInUnits;
        private String purchasedHours;
        private String purchasedUnits;
        private String totalActualHours;
        private String totalActualUnits;
        private String unusedHours;
        private String unusedUnits;
        private String onDemandCostOfRIHoursUsed;
        private String netRISavings;
        private String totalPotentialRISavings;
        private String amortizedUpfrontFee;
        private String amortizedRecurringFee;
        private String totalAmortizedFee;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationAggregates model) {
            this.utilizationPercentage(model.utilizationPercentage);
            this.utilizationPercentageInUnits(model.utilizationPercentageInUnits);
            this.purchasedHours(model.purchasedHours);
            this.purchasedUnits(model.purchasedUnits);
            this.totalActualHours(model.totalActualHours);
            this.totalActualUnits(model.totalActualUnits);
            this.unusedHours(model.unusedHours);
            this.unusedUnits(model.unusedUnits);
            this.onDemandCostOfRIHoursUsed(model.onDemandCostOfRIHoursUsed);
            this.netRISavings(model.netRISavings);
            this.totalPotentialRISavings(model.totalPotentialRISavings);
            this.amortizedUpfrontFee(model.amortizedUpfrontFee);
            this.amortizedRecurringFee(model.amortizedRecurringFee);
            this.totalAmortizedFee(model.totalAmortizedFee);
        }

        public final String getUtilizationPercentage() {
            return this.utilizationPercentage;
        }

        @Override
        public final Builder utilizationPercentage(String utilizationPercentage) {
            this.utilizationPercentage = utilizationPercentage;
            return this;
        }

        public final void setUtilizationPercentage(String utilizationPercentage) {
            this.utilizationPercentage = utilizationPercentage;
        }

        public final String getUtilizationPercentageInUnits() {
            return this.utilizationPercentageInUnits;
        }

        @Override
        public final Builder utilizationPercentageInUnits(String utilizationPercentageInUnits) {
            this.utilizationPercentageInUnits = utilizationPercentageInUnits;
            return this;
        }

        public final void setUtilizationPercentageInUnits(String utilizationPercentageInUnits) {
            this.utilizationPercentageInUnits = utilizationPercentageInUnits;
        }

        public final String getPurchasedHours() {
            return this.purchasedHours;
        }

        @Override
        public final Builder purchasedHours(String purchasedHours) {
            this.purchasedHours = purchasedHours;
            return this;
        }

        public final void setPurchasedHours(String purchasedHours) {
            this.purchasedHours = purchasedHours;
        }

        public final String getPurchasedUnits() {
            return this.purchasedUnits;
        }

        @Override
        public final Builder purchasedUnits(String purchasedUnits) {
            this.purchasedUnits = purchasedUnits;
            return this;
        }

        public final void setPurchasedUnits(String purchasedUnits) {
            this.purchasedUnits = purchasedUnits;
        }

        public final String getTotalActualHours() {
            return this.totalActualHours;
        }

        @Override
        public final Builder totalActualHours(String totalActualHours) {
            this.totalActualHours = totalActualHours;
            return this;
        }

        public final void setTotalActualHours(String totalActualHours) {
            this.totalActualHours = totalActualHours;
        }

        public final String getTotalActualUnits() {
            return this.totalActualUnits;
        }

        @Override
        public final Builder totalActualUnits(String totalActualUnits) {
            this.totalActualUnits = totalActualUnits;
            return this;
        }

        public final void setTotalActualUnits(String totalActualUnits) {
            this.totalActualUnits = totalActualUnits;
        }

        public final String getUnusedHours() {
            return this.unusedHours;
        }

        @Override
        public final Builder unusedHours(String unusedHours) {
            this.unusedHours = unusedHours;
            return this;
        }

        public final void setUnusedHours(String unusedHours) {
            this.unusedHours = unusedHours;
        }

        public final String getUnusedUnits() {
            return this.unusedUnits;
        }

        @Override
        public final Builder unusedUnits(String unusedUnits) {
            this.unusedUnits = unusedUnits;
            return this;
        }

        public final void setUnusedUnits(String unusedUnits) {
            this.unusedUnits = unusedUnits;
        }

        public final String getOnDemandCostOfRIHoursUsed() {
            return this.onDemandCostOfRIHoursUsed;
        }

        @Override
        public final Builder onDemandCostOfRIHoursUsed(String onDemandCostOfRIHoursUsed) {
            this.onDemandCostOfRIHoursUsed = onDemandCostOfRIHoursUsed;
            return this;
        }

        public final void setOnDemandCostOfRIHoursUsed(String onDemandCostOfRIHoursUsed) {
            this.onDemandCostOfRIHoursUsed = onDemandCostOfRIHoursUsed;
        }

        public final String getNetRISavings() {
            return this.netRISavings;
        }

        @Override
        public final Builder netRISavings(String netRISavings) {
            this.netRISavings = netRISavings;
            return this;
        }

        public final void setNetRISavings(String netRISavings) {
            this.netRISavings = netRISavings;
        }

        public final String getTotalPotentialRISavings() {
            return this.totalPotentialRISavings;
        }

        @Override
        public final Builder totalPotentialRISavings(String totalPotentialRISavings) {
            this.totalPotentialRISavings = totalPotentialRISavings;
            return this;
        }

        public final void setTotalPotentialRISavings(String totalPotentialRISavings) {
            this.totalPotentialRISavings = totalPotentialRISavings;
        }

        public final String getAmortizedUpfrontFee() {
            return this.amortizedUpfrontFee;
        }

        @Override
        public final Builder amortizedUpfrontFee(String amortizedUpfrontFee) {
            this.amortizedUpfrontFee = amortizedUpfrontFee;
            return this;
        }

        public final void setAmortizedUpfrontFee(String amortizedUpfrontFee) {
            this.amortizedUpfrontFee = amortizedUpfrontFee;
        }

        public final String getAmortizedRecurringFee() {
            return this.amortizedRecurringFee;
        }

        @Override
        public final Builder amortizedRecurringFee(String amortizedRecurringFee) {
            this.amortizedRecurringFee = amortizedRecurringFee;
            return this;
        }

        public final void setAmortizedRecurringFee(String amortizedRecurringFee) {
            this.amortizedRecurringFee = amortizedRecurringFee;
        }

        public final String getTotalAmortizedFee() {
            return this.totalAmortizedFee;
        }

        @Override
        public final Builder totalAmortizedFee(String totalAmortizedFee) {
            this.totalAmortizedFee = totalAmortizedFee;
            return this;
        }

        public final void setTotalAmortizedFee(String totalAmortizedFee) {
            this.totalAmortizedFee = totalAmortizedFee;
        }

        public ReservationAggregates build() {
            return new ReservationAggregates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservationAggregates> {
        public Builder utilizationPercentage(String var1);

        public Builder utilizationPercentageInUnits(String var1);

        public Builder purchasedHours(String var1);

        public Builder purchasedUnits(String var1);

        public Builder totalActualHours(String var1);

        public Builder totalActualUnits(String var1);

        public Builder unusedHours(String var1);

        public Builder unusedUnits(String var1);

        public Builder onDemandCostOfRIHoursUsed(String var1);

        public Builder netRISavings(String var1);

        public Builder totalPotentialRISavings(String var1);

        public Builder amortizedUpfrontFee(String var1);

        public Builder amortizedRecurringFee(String var1);

        public Builder totalAmortizedFee(String var1);
    }
}

